/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.integration.proxy;

import com.google.common.base.Charsets;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockserver.integration.proxy.AbstractClientProxyIntegrationTest;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.socket.SSLFactory;
import org.mockserver.streams.IOStreamUtils;

public abstract class AbstractClientSecureProxyIntegrationTest
extends AbstractClientProxyIntegrationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldConnectToSecurePort() throws Exception {
        Socket socket = null;
        try {
            socket = new Socket("localhost", this.getProxyPort());
            OutputStream output = socket.getOutputStream();
            output.write(("CONNECT localhost:666 HTTP/1.1\r" + System.getProperty("line.separator") + "Host: localhost:" + this.getServerSecurePort() + "\r" + System.getProperty("line.separator") + "\r" + System.getProperty("line.separator")).getBytes(Charsets.UTF_8));
            output.flush();
            org.mockserver.test.Assert.assertContains(IOStreamUtils.readInputStreamToString((Socket)socket), "HTTP/1.1 200 OK");
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldForwardRequestsToSecurePortUsingSocketDirectly() throws Exception {
        Socket socket = null;
        try {
            socket = new Socket("localhost", this.getProxyPort());
            OutputStream output = socket.getOutputStream();
            output.write(("CONNECT localhost:666 HTTP/1.1\r" + System.getProperty("line.separator") + "Host: localhost:" + this.getServerSecurePort() + "\r" + System.getProperty("line.separator") + "\r" + System.getProperty("line.separator")).getBytes(Charsets.UTF_8));
            output.flush();
            org.mockserver.test.Assert.assertContains(IOStreamUtils.readInputStreamToString((Socket)socket), "HTTP/1.1 200 OK");
            SSLSocket sslSocket = null;
            try {
                sslSocket = SSLFactory.getInstance().wrapSocket(socket);
                output = sslSocket.getOutputStream();
                output.write(("GET /test_headers_only HTTP/1.1\r" + System.getProperty("line.separator") + "Host: localhost:" + this.getServerSecurePort() + "\r" + System.getProperty("line.separator") + "Connection: keep-alive\r" + System.getProperty("line.separator") + "\r" + System.getProperty("line.separator")).getBytes(Charsets.UTF_8));
                output.flush();
                org.mockserver.test.Assert.assertContains(IOStreamUtils.readInputStreamToString((Socket)sslSocket), "X-Test: test_headers_only");
                output.write(("GET /test_headers_and_body HTTP/1.1\r" + System.getProperty("line.separator") + "Host: localhost:" + this.getServerSecurePort() + "\r" + System.getProperty("line.separator") + "\r" + System.getProperty("line.separator")).getBytes(Charsets.UTF_8));
                output.flush();
                String response = IOStreamUtils.readInputStreamToString((Socket)sslSocket);
                org.mockserver.test.Assert.assertContains(response, "X-Test: test_headers_and_body");
                org.mockserver.test.Assert.assertContains(response, "an_example_body");
            }
            finally {
                if (sslSocket != null) {
                    sslSocket.close();
                }
            }
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    @Test
    public void shouldForwardRequestsToSecurePortUsingHttpClient() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        HttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("https").setHost("localhost").setPort(this.getServerSecurePort()).setPath("/test_headers_and_body").build()));
        Assert.assertEquals((long)HttpStatusCode.OK_200.code(), (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"an_example_body", (Object)new String(EntityUtils.toByteArray((HttpEntity)response.getEntity()), Charsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldForwardRequestsToSecurePortAndUnknownPath() throws Exception {
        Socket socket = null;
        try {
            socket = new Socket("localhost", this.getProxyPort());
            OutputStream output = socket.getOutputStream();
            output.write(("CONNECT localhost:666 HTTP/1.1\r" + System.getProperty("line.separator") + "Host: localhost:" + this.getServerSecurePort() + "\r" + System.getProperty("line.separator") + "\r" + System.getProperty("line.separator")).getBytes(Charsets.UTF_8));
            output.flush();
            org.mockserver.test.Assert.assertContains(IOStreamUtils.readInputStreamToString((Socket)socket), "HTTP/1.1 200 OK");
            SSLSocket sslSocket = null;
            try {
                sslSocket = SSLFactory.getInstance().wrapSocket(socket);
                output = sslSocket.getOutputStream();
                output.write(("GET /unknown HTTP/1.1\r" + System.getProperty("line.separator") + "Host: localhost:" + this.getServerSecurePort() + "\r" + System.getProperty("line.separator") + "\r" + System.getProperty("line.separator")).getBytes(Charsets.UTF_8));
                output.flush();
                org.mockserver.test.Assert.assertContains(IOStreamUtils.readInputStreamToString((Socket)sslSocket), "HTTP/1.1 404 Not Found");
            }
            finally {
                if (sslSocket != null) {
                    sslSocket.close();
                }
            }
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }
}

