/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.integration.server;

import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringStartsWith;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.server.MockServerClient;
import org.mockserver.configuration.SystemProperties;
import org.mockserver.matchers.Times;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.Delay;
import org.mockserver.model.Header;
import org.mockserver.model.HttpCallback;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.model.OutboundHttpRequest;
import org.mockserver.model.Parameter;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.StringBody;
import org.mockserver.verify.VerificationTimes;

public abstract class AbstractClientServerIntegrationTest {
    protected static MockServerClient mockServerClient;
    protected static String servletContext;
    protected List<String> headersToIgnore = Arrays.asList("server", "expires", "date", "host", "connection", "user-agent", "content-type", "content-length", "accept-encoding", "transfer-encoding");
    private NettyHttpClient httpClient = new NettyHttpClient();

    public AbstractClientServerIntegrationTest() {
        SystemProperties.bufferSize((int)1024);
        SystemProperties.maxTimeout((long)TimeUnit.SECONDS.toMillis(10L));
    }

    public abstract int getMockServerPort();

    public abstract int getMockServerSecurePort();

    public abstract int getTestServerPort();

    public abstract int getTestServerSecurePort();

    protected String calculatePath(String path) {
        return "/" + path;
    }

    @Before
    public void resetServer() {
        mockServerClient.reset();
    }

    @Test
    public void clientCanCallServerForSimpleResponse() {
        mockServerClient.when(HttpRequest.request()).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("")), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerForForwardInHTTP() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("echo"))).forward(HttpForward.forward().withHost("127.0.0.1").withPort(Integer.valueOf(this.getTestServerPort())));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_https"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_https"), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerForForwardInHTTPS() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("echo"))).forward(HttpForward.forward().withHost("127.0.0.1").withPort(Integer.valueOf(this.getTestServerSecurePort())).withScheme(HttpForward.Scheme.HTTPS));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_https"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_https"), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerForResponseThenForward() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("echo")), Times.once()).forward(HttpForward.forward().withHost("127.0.0.1").withPort(Integer.valueOf(this.getTestServerPort())));
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("test_headers_and_body")), Times.once()).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("test_headers_and_body")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("test_headers_and_body")), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerForCallbackInHTTP() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("callback"))).callback(HttpCallback.callback().withCallbackClass("org.mockserver.integration.callback.PrecannedTestExpectationCallback"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withHeaders(new Header[]{Header.header((String)"x-callback", (String[])new String[]{"test_callback_header"})}).withBody("a_callback_response"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("callback")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withHeaders(new Header[]{Header.header((String)"x-callback", (String[])new String[]{"test_callback_header"})}).withBody("a_callback_response"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("callback")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_https"), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerForResponseWithNoBody() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_path"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path")).withMethod("POST"), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerMatchPath() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1"));
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path2")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path1")), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerMatchPathXTimes() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path")), this.headersToIgnore));
    }

    @Test
    public void clientCanVerifyRequestsReceived() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request().withPath(this.calculatePath("some_path"))});
        mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.exactly((int)1));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path")), this.headersToIgnore));
        mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.atLeast((int)1));
        mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.exactly((int)2));
    }

    @Test
    public void clientCanVerifyRequestsReceivedWithNoBody() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response());
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request().withPath(this.calculatePath("some_path"))});
        mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.exactly((int)1));
    }

    @Test
    public void clientCanVerifyNotEnoughRequestsReceived() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        try {
            mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.atLeast((int)2));
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found at least 2 times, expected:<{" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path") + "\"" + System.getProperty("line.separator") + "}> but was:<{" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path") + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void clientCanVerifyTooManyRequestsReceived() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        try {
            mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.exactly((int)0));
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found exactly 0 times, expected:<{" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path") + "\"" + System.getProperty("line.separator") + "}> but was:<{" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path") + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void clientCanVerifyNotMatchingRequestsReceived() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        try {
            mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_other_path")), VerificationTimes.exactly((int)2));
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found exactly 2 times, expected:<{" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_other_path") + "\"" + System.getProperty("line.separator") + "}> but was:<{" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path") + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void clientCanVerifySequenceOfRequestsReceived() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)6)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_two")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_three")), this.headersToIgnore));
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_two"))});
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_two")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path_one")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path_two")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path_three")), this.headersToIgnore));
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_two"))});
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_two")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
    }

    @Test
    public void clientCanVerifySequenceOfRequestsReceivedEvenThoseNotMatchingAnException() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.notFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("not_found")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_three")), this.headersToIgnore));
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("not_found"))});
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("not_found")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path_one")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.notFoundResponse(), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("not_found")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path_three")), this.headersToIgnore));
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("not_found"))});
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("not_found")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
    }

    @Test
    public void clientCanVerifySequenceOfRequestsNotReceived() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)6)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_two")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_three")), this.headersToIgnore));
        try {
            mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_two")), HttpRequest.request((String)this.calculatePath("some_path_one"))});
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request sequence not found, expected:<[ {" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path_two") + "\"" + System.getProperty("line.separator") + "}, {" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path_one") + "\"" + System.getProperty("line.separator") + "} ]> but was:<[ {" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path_one") + "\"," + System.getProperty("line.separator"))));
        }
        try {
            mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_three")), HttpRequest.request((String)this.calculatePath("some_path_two"))});
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request sequence not found, expected:<[ {" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path_three") + "\"" + System.getProperty("line.separator") + "}, {" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path_two") + "\"" + System.getProperty("line.separator") + "} ]> but was:<[ {" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path_one") + "\"," + System.getProperty("line.separator"))));
        }
        try {
            mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_four"))});
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request sequence not found, expected:<[ {" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path_four") + "\"" + System.getProperty("line.separator") + "} ]> but was:<[ {" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path_one") + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void clientCanCallServerMatchBodyWithXPath() {
        mockServerClient.when(HttpRequest.request().withBody((Body)StringBody.xpath((String)"/bookstore/book[price>35]/price")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)new StringBody("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "<bookstore>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "<book category=\"COOKING\">" + System.getProperty("line.separator") + "  <title lang=\"en\">Everyday Italian</title>" + System.getProperty("line.separator") + "  <author>Giada De Laurentiis</author>" + System.getProperty("line.separator") + "  <year>2005</year>" + System.getProperty("line.separator") + "  <price>30.00</price>" + System.getProperty("line.separator") + "</book>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "<book category=\"CHILDREN\">" + System.getProperty("line.separator") + "  <title lang=\"en\">Harry Potter</title>" + System.getProperty("line.separator") + "  <author>J K. Rowling</author>" + System.getProperty("line.separator") + "  <year>2005</year>" + System.getProperty("line.separator") + "  <price>29.99</price>" + System.getProperty("line.separator") + "</book>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "<book category=\"WEB\">" + System.getProperty("line.separator") + "  <title lang=\"en\">Learning XML</title>" + System.getProperty("line.separator") + "  <author>Erik T. Ray</author>" + System.getProperty("line.separator") + "  <year>2003</year>" + System.getProperty("line.separator") + "  <price>39.95</price>" + System.getProperty("line.separator") + "</book>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "</bookstore>", Body.Type.STRING)), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)new StringBody("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "<bookstore>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "<book category=\"COOKING\">" + System.getProperty("line.separator") + "  <title lang=\"en\">Everyday Italian</title>" + System.getProperty("line.separator") + "  <author>Giada De Laurentiis</author>" + System.getProperty("line.separator") + "  <year>2005</year>" + System.getProperty("line.separator") + "  <price>30.00</price>" + System.getProperty("line.separator") + "</book>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "<book category=\"CHILDREN\">" + System.getProperty("line.separator") + "  <title lang=\"en\">Harry Potter</title>" + System.getProperty("line.separator") + "  <author>J K. Rowling</author>" + System.getProperty("line.separator") + "  <year>2005</year>" + System.getProperty("line.separator") + "  <price>29.99</price>" + System.getProperty("line.separator") + "</book>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "<book category=\"WEB\">" + System.getProperty("line.separator") + "  <title lang=\"en\">Learning XML</title>" + System.getProperty("line.separator") + "  <author>Erik T. Ray</author>" + System.getProperty("line.separator") + "  <year>2003</year>" + System.getProperty("line.separator") + "  <price>39.95</price>" + System.getProperty("line.separator") + "</book>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "</bookstore>", Body.Type.STRING)), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerMatchBodyWithJson() {
        mockServerClient.when(HttpRequest.request().withBody((Body)StringBody.json((String)("{" + System.getProperty("line.separator") + "    \"GlossDiv\": {" + System.getProperty("line.separator") + "        \"title\": \"S\", " + System.getProperty("line.separator") + "        \"GlossList\": {" + System.getProperty("line.separator") + "            \"GlossEntry\": {" + System.getProperty("line.separator") + "                \"ID\": \"SGML\", " + System.getProperty("line.separator") + "                \"SortAs\": \"SGML\", " + System.getProperty("line.separator") + "                \"GlossTerm\": \"Standard Generalized Markup Language\", " + System.getProperty("line.separator") + "                \"Acronym\": \"SGML\", " + System.getProperty("line.separator") + "                \"Abbrev\": \"ISO 8879:1986\", " + System.getProperty("line.separator") + "                \"GlossDef\": {" + System.getProperty("line.separator") + "                    \"para\": \"A meta-markup language, used to create markup languages such as DocBook.\", " + System.getProperty("line.separator") + "                    \"GlossSeeAlso\": [" + System.getProperty("line.separator") + "                        \"GML\", " + System.getProperty("line.separator") + "                        \"XML\"" + System.getProperty("line.separator") + "                    ]" + System.getProperty("line.separator") + "                }, " + System.getProperty("line.separator") + "                \"GlossSee\": \"markup\"" + System.getProperty("line.separator") + "            }" + System.getProperty("line.separator") + "        }" + System.getProperty("line.separator") + "    }" + System.getProperty("line.separator") + "}"))), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"title\": \"example glossary\", " + System.getProperty("line.separator") + "    \"GlossDiv\": {" + System.getProperty("line.separator") + "        \"title\": \"S\", " + System.getProperty("line.separator") + "        \"GlossList\": {" + System.getProperty("line.separator") + "            \"GlossEntry\": {" + System.getProperty("line.separator") + "                \"ID\": \"SGML\", " + System.getProperty("line.separator") + "                \"SortAs\": \"SGML\", " + System.getProperty("line.separator") + "                \"GlossTerm\": \"Standard Generalized Markup Language\", " + System.getProperty("line.separator") + "                \"Acronym\": \"SGML\", " + System.getProperty("line.separator") + "                \"Abbrev\": \"ISO 8879:1986\", " + System.getProperty("line.separator") + "                \"GlossDef\": {" + System.getProperty("line.separator") + "                    \"para\": \"A meta-markup language, used to create markup languages such as DocBook.\", " + System.getProperty("line.separator") + "                    \"GlossSeeAlso\": [" + System.getProperty("line.separator") + "                        \"GML\", " + System.getProperty("line.separator") + "                        \"XML\"" + System.getProperty("line.separator") + "                    ]" + System.getProperty("line.separator") + "                }, " + System.getProperty("line.separator") + "                \"GlossSee\": \"markup\"" + System.getProperty("line.separator") + "            }" + System.getProperty("line.separator") + "        }" + System.getProperty("line.separator") + "    }" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"title\": \"example glossary\", " + System.getProperty("line.separator") + "    \"GlossDiv\": {" + System.getProperty("line.separator") + "        \"title\": \"S\", " + System.getProperty("line.separator") + "        \"GlossList\": {" + System.getProperty("line.separator") + "            \"GlossEntry\": {" + System.getProperty("line.separator") + "                \"ID\": \"SGML\", " + System.getProperty("line.separator") + "                \"SortAs\": \"SGML\", " + System.getProperty("line.separator") + "                \"GlossTerm\": \"Standard Generalized Markup Language\", " + System.getProperty("line.separator") + "                \"Acronym\": \"SGML\", " + System.getProperty("line.separator") + "                \"Abbrev\": \"ISO 8879:1986\", " + System.getProperty("line.separator") + "                \"GlossDef\": {" + System.getProperty("line.separator") + "                    \"para\": \"A meta-markup language, used to create markup languages such as DocBook.\", " + System.getProperty("line.separator") + "                    \"GlossSeeAlso\": [" + System.getProperty("line.separator") + "                        \"GML\", " + System.getProperty("line.separator") + "                        \"XML\"" + System.getProperty("line.separator") + "                    ]" + System.getProperty("line.separator") + "                }, " + System.getProperty("line.separator") + "                \"GlossSee\": \"markup\"" + System.getProperty("line.separator") + "            }" + System.getProperty("line.separator") + "        }" + System.getProperty("line.separator") + "    }" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
    }

    @Test
    public void clientCanSetupExpectationForPDF() throws IOException {
        byte[] pdfBytes = new byte[1024];
        IOUtils.readFully((InputStream)this.getClass().getClassLoader().getResourceAsStream("test.pdf"), (byte[])pdfBytes);
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("ws/rest/user/[0-9]+/document/[0-9]+\\.pdf"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Type", (String[])new String[]{MediaType.PDF.toString()}), Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.pdf\"; filename=\"test.pdf\""}), Header.header((String)"Cache-Control", (String[])new String[]{"must-revalidate, post-check=0, pre-check=0"})}).withBody((Body)BinaryBody.binary((byte[])pdfBytes)));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.pdf\"; filename=\"test.pdf\""}), Header.header((String)"Cache-Control", (String[])new String[]{"must-revalidate, post-check=0, pre-check=0"})}).withBody((Body)BinaryBody.binary((byte[])pdfBytes)), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("ws/rest/user/1/document/2.pdf")).withMethod("GET"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.pdf\"; filename=\"test.pdf\""}), Header.header((String)"Cache-Control", (String[])new String[]{"must-revalidate, post-check=0, pre-check=0"})}).withBody((Body)BinaryBody.binary((byte[])pdfBytes)), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("ws/rest/user/1/document/2.pdf")).withMethod("GET"), this.headersToIgnore));
    }

    @Test
    public void clientCanSetupExpectationForPNG() throws IOException {
        byte[] pngBytes = new byte[1024];
        IOUtils.readFully((InputStream)this.getClass().getClassLoader().getResourceAsStream("test.png"), (byte[])pngBytes);
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("ws/rest/user/[0-9]+/icon/[0-9]+\\.png"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Type", (String[])new String[]{MediaType.PNG.toString()}), Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.png\"; filename=\"test.png\""})}).withBody((Body)BinaryBody.binary((byte[])pngBytes)));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.png\"; filename=\"test.png\""})}).withBody((Body)BinaryBody.binary((byte[])pngBytes)), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("ws/rest/user/1/icon/1.png")).withMethod("GET"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.png\"; filename=\"test.png\""})}).withBody((Body)BinaryBody.binary((byte[])pngBytes)), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("ws/rest/user/1/icon/1.png")).withMethod("GET"), this.headersToIgnore));
    }

    @Test
    public void clientCanSetupExpectationForPDFAsBinaryBody() throws IOException {
        byte[] pdfBytes = new byte[1024];
        IOUtils.readFully((InputStream)this.getClass().getClassLoader().getResourceAsStream("test.pdf"), (byte[])pdfBytes);
        mockServerClient.when(HttpRequest.request().withBody((Body)BinaryBody.binary((byte[])pdfBytes))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Type", (String[])new String[]{MediaType.PDF.toString()}), Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.pdf\"; filename=\"test.pdf\""}), Header.header((String)"Cache-Control", (String[])new String[]{"must-revalidate, post-check=0, pre-check=0"})}).withBody((Body)BinaryBody.binary((byte[])pdfBytes)));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.pdf\"; filename=\"test.pdf\""}), Header.header((String)"Cache-Control", (String[])new String[]{"must-revalidate, post-check=0, pre-check=0"})}).withBody((Body)BinaryBody.binary((byte[])pdfBytes)), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("ws/rest/user/1/document/2.pdf")).withBody((Body)BinaryBody.binary((byte[])pdfBytes)).withMethod("POST"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.pdf\"; filename=\"test.pdf\""}), Header.header((String)"Cache-Control", (String[])new String[]{"must-revalidate, post-check=0, pre-check=0"})}).withBody((Body)BinaryBody.binary((byte[])pdfBytes)), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("ws/rest/user/1/document/2.pdf")).withBody((Body)BinaryBody.binary((byte[])pdfBytes)).withMethod("POST"), this.headersToIgnore));
    }

    @Test
    public void clientCanSetupExpectationForPNGAsBinaryBody() throws IOException {
        byte[] pngBytes = new byte[1024];
        IOUtils.readFully((InputStream)this.getClass().getClassLoader().getResourceAsStream("test.png"), (byte[])pngBytes);
        mockServerClient.when(HttpRequest.request().withBody((Body)BinaryBody.binary((byte[])pngBytes))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Type", (String[])new String[]{MediaType.PNG.toString()}), Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.png\"; filename=\"test.png\""})}).withBody((Body)BinaryBody.binary((byte[])pngBytes)));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.png\"; filename=\"test.png\""})}).withBody((Body)BinaryBody.binary((byte[])pngBytes)), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("ws/rest/user/1/icon/1.png")).withBody((Body)BinaryBody.binary((byte[])pngBytes)).withMethod("POST"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.png\"; filename=\"test.png\""})}).withBody((Body)BinaryBody.binary((byte[])pngBytes)), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("ws/rest/user/1/icon/1.png")).withBody((Body)BinaryBody.binary((byte[])pngBytes)).withMethod("POST"), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerMatchPathWithDelay() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1").withDelay(new Delay(TimeUnit.MILLISECONDS, 10L)));
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2").withDelay(new Delay(TimeUnit.MILLISECONDS, 20L)));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path2")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path1")), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerPositiveMatchForGETAndMatchingPath() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").setSecure(true).withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerPositiveMatchForGETAndMatchingPathAndBody() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody("some_bodyRequest")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").setSecure(true).withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerPositiveMatchForGETAndMatchingPathAndParameters() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}).withHeaders(new Header[]{Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}).withHeaders(new Header[]{Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").setSecure(true).withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerPositiveMatchForGETAndMatchingPathAndHeaders() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"requestHeaderNameOne", (String[])new String[]{"requestHeaderValueOne_One", "requestHeaderValueOne_Two"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}).withHeaders(new Header[]{Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"requestHeaderNameOne", (String[])new String[]{"requestHeaderValueOne_One", "requestHeaderValueOne_Two"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}).withHeaders(new Header[]{Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").setSecure(true).withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"requestHeaderNameOne", (String[])new String[]{"requestHeaderValueOne_One", "requestHeaderValueOne_Two"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerPositiveMatchForGETAndMatchingPathAndCookies() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String[])new String[]{"requestCookieValueOne_One", "requestCookieValueOne_Two"}), Cookie.cookie((String)"requestCookieNameTwo", (String[])new String[]{"requestCookieValueTwo"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"responseCookieNameOne", (String[])new String[]{"responseCookieValueOne_One", "responseCookieValueOne_Two"}), Cookie.cookie((String)"responseCookieNameTwo", (String[])new String[]{"responseCookieValueTwo"})}));
        HttpResponse actual = this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String[])new String[]{"requestCookieValueOne_One", "requestCookieValueOne_Two"}), Cookie.cookie((String)"requestCookieNameTwo", (String[])new String[]{"requestCookieValueTwo"})}), this.headersToIgnore);
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"responseCookieNameOne", (String[])new String[]{"responseCookieValueOne_One", "responseCookieValueOne_Two"}), Cookie.cookie((String)"responseCookieNameTwo", (String[])new String[]{"responseCookieValueTwo"})}).withHeaders(new Header[]{Header.header((String)"Set-Cookie", (String[])new String[]{"responseCookieNameOne=responseCookieValueOne_One", "responseCookieNameOne=responseCookieValueOne_Two", "responseCookieNameTwo=responseCookieValueTwo"})}), (Object)actual);
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"responseCookieNameOne", (String[])new String[]{"responseCookieValueOne_One", "responseCookieValueOne_Two"}), Cookie.cookie((String)"responseCookieNameTwo", (String[])new String[]{"responseCookieValueTwo"})}).withHeaders(new Header[]{Header.header((String)"Set-Cookie", (String[])new String[]{"responseCookieNameOne=responseCookieValueOne_One", "responseCookieNameOne=responseCookieValueOne_Two", "responseCookieNameTwo=responseCookieValueTwo"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"}), Header.header((String)"Cookie", (String[])new String[]{"requestCookieNameOne=requestCookieValueOne_One; requestCookieNameOne=requestCookieValueOne_Two; requestCookieNameTwo=requestCookieValueTwo"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"responseCookieNameOne", (String[])new String[]{"responseCookieValueOne_One", "responseCookieValueOne_Two"}), Cookie.cookie((String)"responseCookieNameTwo", (String[])new String[]{"responseCookieValueTwo"})}).withHeaders(new Header[]{Header.header((String)"Set-Cookie", (String[])new String[]{"responseCookieNameOne=responseCookieValueOne_One", "responseCookieNameOne=responseCookieValueOne_Two", "responseCookieNameTwo=responseCookieValueTwo"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").setSecure(true).withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String[])new String[]{"requestCookieValueOne_One", "requestCookieValueOne_Two"}), Cookie.cookie((String)"requestCookieNameTwo", (String[])new String[]{"requestCookieValueTwo"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"responseCookieNameOne", (String[])new String[]{"responseCookieValueOne_One", "responseCookieValueOne_Two"}), Cookie.cookie((String)"responseCookieNameTwo", (String[])new String[]{"responseCookieValueTwo"})}).withHeaders(new Header[]{Header.header((String)"Set-Cookie", (String[])new String[]{"responseCookieNameOne=responseCookieValueOne_One", "responseCookieNameOne=responseCookieValueOne_Two", "responseCookieNameTwo=responseCookieValueTwo"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").setSecure(true).withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"}), Header.header((String)"Cookie", (String[])new String[]{"requestCookieNameOne=requestCookieValueOne_One; requestCookieNameOne=requestCookieValueOne_Two; requestCookieNameTwo=requestCookieValueTwo"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerPositiveMatchForPOSTAndMatchingPathAndParameters() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterName", (String[])new String[]{"bodyParameterValue"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterName", (String[])new String[]{"bodyParameterValue"})})), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterName", (String[])new String[]{"bodyParameterValue"})})), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerPositiveMatchForPOSTAndMatchingPathBodyAndQueryParameters() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerPositiveMatchForPOSTAndMatchingPathBodyParametersAndQueryParameters() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two", Body.Type.STRING)).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerPositiveMatchForPUTAndMatchingPathBodyParametersAndHeadersAndCookies() {
        mockServerClient.when(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two", Body.Type.STRING)).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two", Body.Type.STRING)).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"}), Header.header((String)"Cookie", (String[])new String[]{"cookieNameRequest=cookieValueRequest"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerNegativeMatchBodyOnly() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_other_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").setSecure(true).withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_other_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerNegativeMatchXPathBodyOnly() {
        mockServerClient.when(HttpRequest.request().withBody((Body)new StringBody("/bookstore/book[price>35]/price", Body.Type.XPATH)), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)new StringBody("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "<bookstore>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "<book category=\"COOKING\">" + System.getProperty("line.separator") + "  <title lang=\"en\">Everyday Italian</title>" + System.getProperty("line.separator") + "  <author>Giada De Laurentiis</author>" + System.getProperty("line.separator") + "  <year>2005</year>" + System.getProperty("line.separator") + "  <price>30.00</price>" + System.getProperty("line.separator") + "</book>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "<book category=\"CHILDREN\">" + System.getProperty("line.separator") + "  <title lang=\"en\">Harry Potter</title>" + System.getProperty("line.separator") + "  <author>J K. Rowling</author>" + System.getProperty("line.separator") + "  <year>2005</year>" + System.getProperty("line.separator") + "  <price>29.99</price>" + System.getProperty("line.separator") + "</book>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "<book category=\"WEB\">" + System.getProperty("line.separator") + "  <title lang=\"en\">Learning XML</title>" + System.getProperty("line.separator") + "  <author>Erik T. Ray</author>" + System.getProperty("line.separator") + "  <year>2003</year>" + System.getProperty("line.separator") + "  <price>31.95</price>" + System.getProperty("line.separator") + "</book>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "</bookstore>", Body.Type.STRING)), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)new StringBody("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "<bookstore>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "<book category=\"COOKING\">" + System.getProperty("line.separator") + "  <title lang=\"en\">Everyday Italian</title>" + System.getProperty("line.separator") + "  <author>Giada De Laurentiis</author>" + System.getProperty("line.separator") + "  <year>2005</year>" + System.getProperty("line.separator") + "  <price>30.00</price>" + System.getProperty("line.separator") + "</book>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "<book category=\"CHILDREN\">" + System.getProperty("line.separator") + "  <title lang=\"en\">Harry Potter</title>" + System.getProperty("line.separator") + "  <author>J K. Rowling</author>" + System.getProperty("line.separator") + "  <year>2005</year>" + System.getProperty("line.separator") + "  <price>29.99</price>" + System.getProperty("line.separator") + "</book>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "<book category=\"WEB\">" + System.getProperty("line.separator") + "  <title lang=\"en\">Learning XML</title>" + System.getProperty("line.separator") + "  <author>Erik T. Ray</author>" + System.getProperty("line.separator") + "  <year>2003</year>" + System.getProperty("line.separator") + "  <price>31.95</price>" + System.getProperty("line.separator") + "</book>" + System.getProperty("line.separator") + "" + System.getProperty("line.separator") + "</bookstore>", Body.Type.STRING)), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerNegativeMatchJsonBodyOnly() {
        mockServerClient.when(HttpRequest.request().withBody((Body)StringBody.json((String)("{" + System.getProperty("line.separator") + "    \"title\": \"example glossary\", " + System.getProperty("line.separator") + "    \"GlossDiv\": {" + System.getProperty("line.separator") + "        \"title\": \"wrong_value\", " + System.getProperty("line.separator") + "        \"GlossList\": {" + System.getProperty("line.separator") + "            \"GlossEntry\": {" + System.getProperty("line.separator") + "                \"ID\": \"SGML\", " + System.getProperty("line.separator") + "                \"SortAs\": \"SGML\", " + System.getProperty("line.separator") + "                \"GlossTerm\": \"Standard Generalized Markup Language\", " + System.getProperty("line.separator") + "                \"Acronym\": \"SGML\", " + System.getProperty("line.separator") + "                \"Abbrev\": \"ISO 8879:1986\", " + System.getProperty("line.separator") + "                \"GlossDef\": {" + System.getProperty("line.separator") + "                    \"para\": \"A meta-markup language, used to create markup languages such as DocBook.\", " + System.getProperty("line.separator") + "                    \"GlossSeeAlso\": [" + System.getProperty("line.separator") + "                        \"GML\", " + System.getProperty("line.separator") + "                        \"XML\"" + System.getProperty("line.separator") + "                    ]" + System.getProperty("line.separator") + "                }, " + System.getProperty("line.separator") + "                \"GlossSee\": \"markup\"" + System.getProperty("line.separator") + "            }" + System.getProperty("line.separator") + "        }" + System.getProperty("line.separator") + "    }" + System.getProperty("line.separator") + "}"))), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"title\": \"example glossary\", " + System.getProperty("line.separator") + "    \"GlossDiv\": {" + System.getProperty("line.separator") + "        \"title\": \"S\", " + System.getProperty("line.separator") + "        \"GlossList\": {" + System.getProperty("line.separator") + "            \"GlossEntry\": {" + System.getProperty("line.separator") + "                \"ID\": \"SGML\", " + System.getProperty("line.separator") + "                \"SortAs\": \"SGML\", " + System.getProperty("line.separator") + "                \"GlossTerm\": \"Standard Generalized Markup Language\", " + System.getProperty("line.separator") + "                \"Acronym\": \"SGML\", " + System.getProperty("line.separator") + "                \"Abbrev\": \"ISO 8879:1986\", " + System.getProperty("line.separator") + "                \"GlossDef\": {" + System.getProperty("line.separator") + "                    \"para\": \"A meta-markup language, used to create markup languages such as DocBook.\", " + System.getProperty("line.separator") + "                    \"GlossSeeAlso\": [" + System.getProperty("line.separator") + "                        \"GML\", " + System.getProperty("line.separator") + "                        \"XML\"" + System.getProperty("line.separator") + "                    ]" + System.getProperty("line.separator") + "                }, " + System.getProperty("line.separator") + "                \"GlossSee\": \"markup\"" + System.getProperty("line.separator") + "            }" + System.getProperty("line.separator") + "        }" + System.getProperty("line.separator") + "    }" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"title\": \"example glossary\", " + System.getProperty("line.separator") + "    \"GlossDiv\": {" + System.getProperty("line.separator") + "        \"title\": \"S\", " + System.getProperty("line.separator") + "        \"GlossList\": {" + System.getProperty("line.separator") + "            \"GlossEntry\": {" + System.getProperty("line.separator") + "                \"ID\": \"SGML\", " + System.getProperty("line.separator") + "                \"SortAs\": \"SGML\", " + System.getProperty("line.separator") + "                \"GlossTerm\": \"Standard Generalized Markup Language\", " + System.getProperty("line.separator") + "                \"Acronym\": \"SGML\", " + System.getProperty("line.separator") + "                \"Abbrev\": \"ISO 8879:1986\", " + System.getProperty("line.separator") + "                \"GlossDef\": {" + System.getProperty("line.separator") + "                    \"para\": \"A meta-markup language, used to create markup languages such as DocBook.\", " + System.getProperty("line.separator") + "                    \"GlossSeeAlso\": [" + System.getProperty("line.separator") + "                        \"GML\", " + System.getProperty("line.separator") + "                        \"XML\"" + System.getProperty("line.separator") + "                    ]" + System.getProperty("line.separator") + "                }, " + System.getProperty("line.separator") + "                \"GlossSee\": \"markup\"" + System.getProperty("line.separator") + "            }" + System.getProperty("line.separator") + "        }" + System.getProperty("line.separator") + "    }" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerNegativeMatchPathOnly() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_other_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").setSecure(true).withPath(this.calculatePath("some_other_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerNegativeMatchQueryStringParameterNameOnly() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"OTHERQueryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerNegativeMatchBodyParameterNameOnly() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"OTHERBodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("OTHERBodyParameterOneName=Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two", Body.Type.STRING)).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerNegativeMatchQueryStringParameterValueOnly() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"OTHERqueryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerNegativeMatchBodyParameterValueOnly() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_bodyResponse").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String[])new String[]{"cookieValueResponse"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Other Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Other Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two", Body.Type.STRING)).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String[])new String[]{"cookieValueRequest"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerNegativeMatchCookieNameOnly() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieOtherName", (String[])new String[]{"cookieValue"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").setSecure(true).withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieOtherName", (String[])new String[]{"cookieValue"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerNegativeMatchCookieValueOnly() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieOtherValue"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").setSecure(true).withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieOtherValue"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerNegativeMatchHeaderNameOnly() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerOtherName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").setSecure(true).withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerOtherName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanCallServerNegativeMatchHeaderValueOnly() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerOtherValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").setSecure(true).withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerOtherValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String[])new String[]{"cookieValue"})}), this.headersToIgnore));
    }

    @Test
    public void clientCanClearServerExpectations() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1"));
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2"));
        mockServerClient.clear(HttpRequest.request().withPath(this.calculatePath("some_path1")));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path2")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path1")), this.headersToIgnore));
    }

    @Test
    public void clientCanResetServerExpectations() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1"));
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2"));
        mockServerClient.reset();
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path1")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().setSecure(true).withPath(this.calculatePath("some_path2")), this.headersToIgnore));
    }

    protected HttpResponse makeRequest(HttpRequest httpRequest, Collection<String> headersToIgnore) {
        int port = httpRequest.isSecure() ? this.getMockServerSecurePort() : this.getMockServerPort();
        HttpResponse httpResponse = this.httpClient.sendRequest(OutboundHttpRequest.outboundRequest((String)"localhost", (Integer)port, (String)servletContext, (HttpRequest)httpRequest));
        ArrayList<Header> headers = new ArrayList<Header>();
        for (Header header : httpResponse.getHeaders()) {
            if (headersToIgnore.contains(header.getName().toLowerCase())) continue;
            headers.add(header);
        }
        httpResponse.withHeaders(headers);
        return httpResponse;
    }

    static {
        servletContext = "";
    }
}

