/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.integration.testserver;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.mockserver.integration.testserver.LoggingHandler;
import org.mockserver.integration.testserver.TestServerHandler;
import org.mockserver.socket.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final NioEventLoopGroup workerGroup = new NioEventLoopGroup(1);
    private final NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);

    public TestServer startServer(final int port, final int securePort) {
        final SettableFuture hasBoundToHTTPPort = SettableFuture.create();
        final SettableFuture hasBoundToHTTPSPort = SettableFuture.create();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestServer.this.logger.debug("STARTING SERVER FOR HTTP ON PORT: " + port);
                    ChannelFuture channelFutureHTTP = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().option(ChannelOption.SO_BACKLOG, (Object)1024)).group((EventLoopGroup)TestServer.this.bossGroup, (EventLoopGroup)TestServer.this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                        public void initChannel(SocketChannel ch) throws Exception {
                            ChannelPipeline pipeline = ch.pipeline();
                            pipeline.addLast("logger", (ChannelHandler)new LoggingHandler("TEST_SERVER"));
                            pipeline.addLast("codec", (ChannelHandler)new HttpServerCodec());
                            pipeline.addLast("chunk-aggregator", (ChannelHandler)new HttpObjectAggregator(0xA00000));
                            pipeline.addLast("handler", (ChannelHandler)new TestServerHandler());
                        }
                    }).bind(port).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.isSuccess()) {
                                hasBoundToHTTPPort.set((Object)"CONNECTED");
                            } else {
                                hasBoundToHTTPPort.setException(future.cause());
                            }
                        }
                    });
                    TestServer.this.logger.debug("STARTING SERVER FOR HTTPS ON PORT: " + securePort);
                    ChannelFuture channelFutureHTTPS = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().option(ChannelOption.SO_BACKLOG, (Object)1024)).group((EventLoopGroup)TestServer.this.bossGroup, (EventLoopGroup)TestServer.this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                        public void initChannel(SocketChannel ch) throws Exception {
                            ChannelPipeline pipeline = ch.pipeline();
                            pipeline.addLast("raw logger", (ChannelHandler)new LoggingHandler("RAW TEST_SERVER_SSL"));
                            SSLEngine engine = SSLFactory.getInstance().sslContext().createSSLEngine();
                            engine.setUseClientMode(false);
                            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
                            pipeline.addLast("logger", (ChannelHandler)new LoggingHandler("TEST_SERVER_SSL"));
                            pipeline.addLast("codec", (ChannelHandler)new HttpServerCodec());
                            pipeline.addLast("chunk-aggregator", (ChannelHandler)new HttpObjectAggregator(0xA00000));
                            pipeline.addLast("handler", (ChannelHandler)new TestServerHandler());
                        }
                    }).bind(securePort).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.isSuccess()) {
                                hasBoundToHTTPSPort.set((Object)"CONNECTED");
                            } else {
                                hasBoundToHTTPSPort.setException(future.cause());
                            }
                        }
                    });
                    channelFutureHTTP.channel().closeFuture().sync();
                    channelFutureHTTPS.channel().closeFuture().sync();
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception running test server", e);
                }
                finally {
                    TestServer.this.bossGroup.shutdownGracefully();
                    TestServer.this.workerGroup.shutdownGracefully();
                }
            }
        }).start();
        try {
            hasBoundToHTTPPort.get();
            hasBoundToHTTPSPort.get();
        }
        catch (Exception e) {
            this.logger.debug("Exception while waiting for proxy to complete starting up", (Throwable)e);
        }
        return this;
    }

    public void stop() {
        this.workerGroup.shutdownGracefully(2L, 15L, TimeUnit.SECONDS);
        this.bossGroup.shutdownGracefully(2L, 15L, TimeUnit.SECONDS);
    }
}

