/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.integration.testserver;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.ArrayList;
import java.util.Collections;

public class TestServerHandler
extends SimpleChannelInboundHandler<Object> {
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpMessage && ((HttpObject)msg).getDecoderResult().isSuccess()) {
            HttpRequest request = (HttpRequest)msg;
            ByteBuf requestContent = Unpooled.copiedBuffer((ByteBuf)((HttpContent)msg).content());
            DefaultFullHttpRequest mockServerHttpRequest = new DefaultFullHttpRequest(request.getProtocolVersion(), request.getMethod(), request.getUri(), requestContent);
            mockServerHttpRequest.headers().add(request.headers());
            LastHttpContent trailer = (LastHttpContent)msg;
            if (!trailer.trailingHeaders().isEmpty()) {
                mockServerHttpRequest.headers().entries().addAll(trailer.trailingHeaders().entries());
            }
            this.writeResponse(ctx, this.handleRequest(mockServerHttpRequest), HttpHeaders.isKeepAlive((HttpMessage)request), HttpHeaders.is100ContinueExpected((HttpMessage)request));
        } else {
            ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
        }
    }

    private void writeResponse(ChannelHandlerContext ctx, FullHttpResponse response, boolean isKeepAlive, boolean is100ContinueExpected) {
        if (isKeepAlive) {
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
            response.headers().set("Connection", (Object)"keep-alive");
        }
        if (is100ContinueExpected) {
            ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
        }
        ctx.write((Object)response);
        ctx.flush();
    }

    public FullHttpResponse handleRequest(DefaultFullHttpRequest req) {
        DefaultFullHttpResponse response;
        if (req.getUri().equals("/unknown")) {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
        } else if (req.getUri().equals("/test_headers_and_body")) {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])"an_example_body".getBytes(Charsets.UTF_8)));
            response.headers().set("X-Test", (Object)"test_headers_and_body");
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
        } else if (req.getUri().equals("/test_headers_only")) {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            response.headers().set("X-Test", (Object)"test_headers_only");
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
        } else if (req.getUri().endsWith("/echo")) {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((ByteBuf)req.content()));
            ArrayList headerNames = new ArrayList(req.headers().names());
            Collections.sort(headerNames);
            for (String headerName : headerNames) {
                response.headers().set(headerName.toLowerCase(), (Object)req.headers().get(headerName));
            }
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
        } else {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])"Hello World".getBytes(Charsets.UTF_8)));
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
        }
        return response;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }
}

