/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.netty.handler.codec.http.QueryStringDecoder;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.MultiValueMapMatcher;
import org.mockserver.model.Parameter;
import org.mockserver.model.Parameters;

public class ParameterStringMatcher
extends BodyMatcher<String> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger"};
    private final MultiValueMapMatcher matcher;

    ParameterStringMatcher(MockServerLogger mockServerLogger, Parameters parameters, boolean controlPlaneMatcher) {
        this.matcher = new MultiValueMapMatcher(mockServerLogger, parameters, controlPlaneMatcher);
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        boolean result = false;
        if (this.matcher.matches(context, this.parseString(matched))) {
            result = true;
        }
        return this.not != result;
    }

    private Parameters parseString(String matched) {
        return (Parameters)new Parameters(new Parameter[0]).withEntries(new QueryStringDecoder("?" + matched).parameters());
    }

    @Override
    public boolean isBlank() {
        return this.matcher.isBlank();
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

