/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.log.model.LogEntry;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.model.HttpRequest;
import org.mockserver.netty.MockServerHandler;
import org.mockserver.netty.MockServerUnificationInitializer;
import org.mockserver.proxyconfiguration.ProxyConfiguration;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.slf4j.event.Level;

public class MockServer
extends LifeCycle {
    private InetSocketAddress remoteSocket;

    public MockServer(Integer ... localPorts) {
        this(ProxyConfiguration.proxyConfiguration(), localPorts);
    }

    public MockServer(ProxyConfiguration proxyConfiguration, Integer ... localPorts) {
        this.createServerBootstrap(proxyConfiguration, localPorts);
        this.getLocalPort();
    }

    public MockServer(Integer remotePort, @Nullable String remoteHost, Integer ... localPorts) {
        this(ProxyConfiguration.proxyConfiguration(), remoteHost, remotePort, localPorts);
    }

    public MockServer(ProxyConfiguration proxyConfiguration, @Nullable String remoteHost, Integer remotePort, Integer ... localPorts) {
        if (remotePort == null) {
            throw new IllegalArgumentException("You must specify a remote hostname");
        }
        if (remoteHost == null) {
            remoteHost = "localhost";
        }
        this.remoteSocket = new InetSocketAddress(remoteHost, (int)remotePort);
        if (proxyConfiguration != null) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.INFO).setHttpRequest(HttpRequest.request()).setMessageFormat("using proxy configuration for forwarded requests:{}").setArguments(proxyConfiguration));
        }
        this.createServerBootstrap(proxyConfiguration, localPorts);
        this.getLocalPort();
    }

    private void createServerBootstrap(ProxyConfiguration proxyConfiguration, Integer ... localPorts) {
        List<Integer> portBindings = Collections.singletonList(0);
        if (localPorts != null && localPorts.length > 0) {
            portBindings = Arrays.asList(localPorts);
        }
        NettySslContextFactory nettySslContextFactory = new NettySslContextFactory(this.mockServerLogger);
        this.serverServerBootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).option(ChannelOption.SO_BACKLOG, 1024)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, true).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT).option(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(8192, 32768))).childHandler(new MockServerUnificationInitializer(this, this.httpStateHandler, new ActionHandler(this.getEventLoopGroup(), this.httpStateHandler, proxyConfiguration, nettySslContextFactory), nettySslContextFactory)).childAttr(ActionHandler.REMOTE_SOCKET, this.remoteSocket).childAttr(MockServerHandler.PROXYING, this.remoteSocket != null);
        try {
            this.bindServerPorts(portBindings);
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.ERROR).setMessageFormat("exception binding to port(s) " + portBindings).setThrowable(throwable));
            this.stop();
            throw throwable;
        }
        this.startedServer(this.getLocalPorts());
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteSocket;
    }
}

