/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.delta;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.util.Util;
import org.infinispan.schematic.document.Immutable;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.HashCode;
import org.infinispan.schematic.internal.SchematicExternalizer;
import org.infinispan.schematic.internal.delta.Operation;
import org.infinispan.schematic.internal.document.MutableDocument;

@Immutable
@SerializeWith(value=Externalizer.class)
public class RemoveOperation
extends Operation {
    protected final String fieldName;
    protected final Object oldValue;
    private transient boolean removed;

    public RemoveOperation(Path parentPath, String fieldName, Object oldValue) {
        super(parentPath, HashCode.compute(parentPath, fieldName));
        this.fieldName = fieldName;
        this.oldValue = oldValue;
    }

    @Override
    public RemoveOperation clone() {
        return new RemoveOperation(this.getParentPath(), this.fieldName, this.cloneValue(this.oldValue));
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void rollback(MutableDocument delegate) {
        if (this.oldValue != null) {
            delegate = this.mutableParent(delegate);
            delegate.put(this.fieldName, this.oldValue);
        }
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableDocument parent = this.mutableParent(delegate);
        assert (parent != null);
        this.removed = parent.remove(this.fieldName) != null;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public String toString() {
        return "Remove from '" + this.parentPath + "' the '" + this.fieldName + "' field value '" + this.oldValue + "'";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoveOperation) {
            RemoveOperation other = (RemoveOperation)obj;
            return this.equalsIfNotNull(this.fieldName, other.fieldName) && this.equalsIfNotNull(this.getParentPath(), other.getParentPath());
        }
        return false;
    }

    public static final class Externalizer
    extends SchematicExternalizer<RemoveOperation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, RemoveOperation remove) throws IOException {
            output.writeObject(remove.parentPath);
            output.writeUTF(remove.fieldName);
        }

        public RemoveOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Path parentPath = (Path)input.readObject();
            String fieldName = input.readUTF();
            return new RemoveOperation(parentPath, fieldName, null);
        }

        @Override
        public Integer getId() {
            return 1603;
        }

        @Override
        public Set<Class<? extends RemoveOperation>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{RemoveOperation.class});
        }
    }
}

