/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson.internal.io;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonBinary;
import org.mongodb.kbson.BsonBoolean;
import org.mongodb.kbson.BsonDBPointer;
import org.mongodb.kbson.BsonDateTime;
import org.mongodb.kbson.BsonDecimal128;
import org.mongodb.kbson.BsonDouble;
import org.mongodb.kbson.BsonException;
import org.mongodb.kbson.BsonInt32;
import org.mongodb.kbson.BsonInt64;
import org.mongodb.kbson.BsonInvalidOperationException;
import org.mongodb.kbson.BsonJavaScript;
import org.mongodb.kbson.BsonMaxKey;
import org.mongodb.kbson.BsonMinKey;
import org.mongodb.kbson.BsonNull;
import org.mongodb.kbson.BsonObjectId;
import org.mongodb.kbson.BsonRegularExpression;
import org.mongodb.kbson.BsonString;
import org.mongodb.kbson.BsonSymbol;
import org.mongodb.kbson.BsonTimestamp;
import org.mongodb.kbson.BsonType;
import org.mongodb.kbson.BsonUndefined;
import org.mongodb.kbson.internal.io.BsonContextType;
import org.mongodb.kbson.internal.io.BsonReader;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u00002\u00020\u0001:\u0002qrB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u000bH\u0014J\b\u0010'\u001a\u00020$H\u0016J\b\u0010(\u001a\u00020)H$J\b\u0010*\u001a\u00020\u0017H$J\b\u0010+\u001a\u00020,H$J\b\u0010-\u001a\u00020.H$J\b\u0010/\u001a\u000200H$J\b\u00101\u001a\u000202H$J\b\u00103\u001a\u00020$H$J\b\u00104\u001a\u00020$H$J\b\u00105\u001a\u000206H$J\b\u00107\u001a\u00020.H$J\b\u00108\u001a\u00020\u0011H$J\b\u00109\u001a\u00020\u0011H$J\b\u0010:\u001a\u00020$H$J\b\u0010;\u001a\u00020$H$J\b\u0010<\u001a\u00020$H$J\b\u0010=\u001a\u00020>H$J\b\u0010?\u001a\u00020@H$J\b\u0010A\u001a\u00020$H$J\b\u0010B\u001a\u00020$H$J\b\u0010C\u001a\u00020\u0011H$J\b\u0010D\u001a\u00020\u0011H$J\b\u0010E\u001a\u00020.H$J\b\u0010F\u001a\u00020$H$J\b\u0010G\u001a\u00020$H$J\b\u0010H\u001a\u00020$H$J\b\u0010I\u001a\u00020)H\u0016J\b\u0010J\u001a\u00020KH\u0016J\b\u0010L\u001a\u00020,H\u0016J\b\u0010M\u001a\u00020NH\u0016J\b\u0010O\u001a\u000200H\u0016J\b\u0010P\u001a\u00020QH\u0016J\b\u0010R\u001a\u00020$H\u0016J\b\u0010S\u001a\u00020$H\u0016J\b\u0010T\u001a\u00020UH\u0016J\b\u0010V\u001a\u00020WH\u0016J\b\u0010X\u001a\u00020YH\u0016J\b\u0010Z\u001a\u00020\u0011H\u0016J\b\u0010[\u001a\u00020\\H\u0016J\b\u0010]\u001a\u00020^H\u0016J\b\u0010_\u001a\u00020\u0011H\u0016J\b\u0010`\u001a\u00020aH\u0016J\b\u0010b\u001a\u00020>H\u0016J\b\u0010c\u001a\u00020@H\u0016J\b\u0010d\u001a\u00020$H\u0016J\b\u0010e\u001a\u00020$H\u0016J\b\u0010f\u001a\u00020gH\u0016J\b\u0010h\u001a\u00020iH\u0016J\b\u0010j\u001a\u00020kH\u0016J\b\u0010l\u001a\u00020mH\u0016J\b\u0010n\u001a\u00020$H\u0002J\b\u0010o\u001a\u00020$H\u0016J\b\u0010p\u001a\u00020$H\u0016R&\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u0000X\u0084\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u001c8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001e\"\u0004\b!\u0010\"\u00a8\u0006s"}, d2={"Lorg/mongodb/kbson/internal/io/AbstractBsonReader;", "Lorg/mongodb/kbson/internal/io/BsonReader;", "()V", "_context", "Lorg/mongodb/kbson/internal/io/AbstractBsonReader$Context;", "get_context$annotations", "get_context", "()Lorg/mongodb/kbson/internal/io/AbstractBsonReader$Context;", "set_context", "(Lorg/mongodb/kbson/internal/io/AbstractBsonReader$Context;)V", "currentBsonType", "Lorg/mongodb/kbson/BsonType;", "getCurrentBsonType", "()Lorg/mongodb/kbson/BsonType;", "setCurrentBsonType", "(Lorg/mongodb/kbson/BsonType;)V", "currentName", "", "getCurrentName", "()Ljava/lang/String;", "setCurrentName", "(Ljava/lang/String;)V", "isClosed", "", "()Z", "setClosed", "(Z)V", "nextState", "Lorg/mongodb/kbson/internal/io/AbstractBsonReader$State;", "getNextState", "()Lorg/mongodb/kbson/internal/io/AbstractBsonReader$State;", "state", "getState", "setState", "(Lorg/mongodb/kbson/internal/io/AbstractBsonReader$State;)V", "checkPreconditions", "", "methodName", "type", "close", "doReadBinaryData", "Lorg/mongodb/kbson/BsonBinary;", "doReadBoolean", "doReadDBPointer", "Lorg/mongodb/kbson/BsonDBPointer;", "doReadDateTime", "", "doReadDecimal128", "Lorg/mongodb/kbson/BsonDecimal128;", "doReadDouble", "", "doReadEndArray", "doReadEndDocument", "doReadInt32", "", "doReadInt64", "doReadJavaScript", "doReadJavaScriptWithScope", "doReadMaxKey", "doReadMinKey", "doReadNull", "doReadObjectId", "Lorg/mongodb/kbson/BsonObjectId;", "doReadRegularExpression", "Lorg/mongodb/kbson/BsonRegularExpression;", "doReadStartArray", "doReadStartDocument", "doReadString", "doReadSymbol", "doReadTimestamp", "doReadUndefined", "doSkipName", "doSkipValue", "readBinary", "readBoolean", "Lorg/mongodb/kbson/BsonBoolean;", "readDBPointer", "readDateTime", "Lorg/mongodb/kbson/BsonDateTime;", "readDecimal128", "readDouble", "Lorg/mongodb/kbson/BsonDouble;", "readEndArray", "readEndDocument", "readInt32", "Lorg/mongodb/kbson/BsonInt32;", "readInt64", "Lorg/mongodb/kbson/BsonInt64;", "readJavaScript", "Lorg/mongodb/kbson/BsonJavaScript;", "readJavaScriptWithScope", "readMaxKey", "Lorg/mongodb/kbson/BsonMaxKey;", "readMinKey", "Lorg/mongodb/kbson/BsonMinKey;", "readName", "readNull", "Lorg/mongodb/kbson/BsonNull;", "readObjectId", "readRegularExpression", "readStartArray", "readStartDocument", "readString", "Lorg/mongodb/kbson/BsonString;", "readSymbol", "Lorg/mongodb/kbson/BsonSymbol;", "readTimestamp", "Lorg/mongodb/kbson/BsonTimestamp;", "readUndefined", "Lorg/mongodb/kbson/BsonUndefined;", "setStateOnEnd", "skipName", "skipValue", "Context", "State", "kbson"})
public abstract class AbstractBsonReader
implements BsonReader {
    @Nullable
    private BsonType currentBsonType;
    @NotNull
    private State state = State.INITIAL;
    @Nullable
    private Context _context;
    private boolean isClosed;
    @Nullable
    private String currentName;
    @NotNull
    private State nextState = State.INITIAL;

    @Override
    @Nullable
    public BsonType getCurrentBsonType() {
        return this.currentBsonType;
    }

    @Override
    public void setCurrentBsonType(@Nullable BsonType bsonType) {
        this.currentBsonType = bsonType;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    public final void setState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    @Nullable
    protected final Context get_context() {
        return this._context;
    }

    protected final void set_context(@Nullable Context context) {
        this._context = context;
    }

    protected static /* synthetic */ void get_context$annotations() {
    }

    protected final boolean isClosed() {
        return this.isClosed;
    }

    protected final void setClosed(boolean bl) {
        this.isClosed = bl;
    }

    @Override
    @Nullable
    public String getCurrentName() {
        return this.currentName;
    }

    @Override
    public void setCurrentName(@Nullable String string) {
        this.currentName = string;
    }

    protected abstract void doReadStartDocument();

    protected abstract void doReadEndDocument();

    protected abstract void doReadStartArray();

    protected abstract void doReadEndArray();

    @NotNull
    protected abstract BsonBinary doReadBinaryData();

    protected abstract boolean doReadBoolean();

    protected abstract long doReadDateTime();

    protected abstract double doReadDouble();

    protected abstract int doReadInt32();

    protected abstract long doReadInt64();

    @NotNull
    protected abstract BsonDecimal128 doReadDecimal128();

    @NotNull
    protected abstract String doReadJavaScript();

    @NotNull
    protected abstract String doReadJavaScriptWithScope();

    @NotNull
    protected abstract BsonObjectId doReadObjectId();

    @NotNull
    protected abstract BsonRegularExpression doReadRegularExpression();

    @NotNull
    protected abstract BsonDBPointer doReadDBPointer();

    @NotNull
    protected abstract String doReadString();

    @NotNull
    protected abstract String doReadSymbol();

    protected abstract long doReadTimestamp();

    protected abstract void doReadUndefined();

    protected abstract void doReadMaxKey();

    protected abstract void doReadMinKey();

    protected abstract void doReadNull();

    protected abstract void doSkipName();

    protected abstract void doSkipValue();

    @Override
    public void readStartDocument() {
        this.checkPreconditions("readStartDocument", BsonType.DOCUMENT);
        this.doReadStartDocument();
        this.state = State.TYPE;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void readEndDocument() {
        if (!(this.isClosed == false && this._context != null)) {
            $i$a$-check-AbstractBsonReader$readEndDocument$1 = false;
            $i$a$-check-AbstractBsonReader$readEndDocument$1 = "BinaryWriter is closed";
            throw new IllegalStateException($i$a$-check-AbstractBsonReader$readEndDocument$1.toString());
        }
        v0 = this._context;
        if ((v0 == null ? null : v0.getContextType()) == BsonContextType.DOCUMENT) ** GOTO lbl-1000
        v1 = this._context;
        if ((v1 == null ? null : v1.getContextType()) == BsonContextType.SCOPE_DOCUMENT) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        value$iv = v2;
        $i$f$validateOperation = false;
        if (!value$iv) {
            $i$a$-validateOperation-AbstractBsonReader$readEndDocument$2 = false;
            v3 = this.get_context();
            message$iv = "readEndDocument can only be called when contextType is " + (Object)BsonContextType.DOCUMENT + " or " + (Object)BsonContextType.SCOPE_DOCUMENT + " , not when contextType is " + (v3 == null ? null : v3.getContextType()) + '.';
            throw new BsonInvalidOperationException(message$iv.toString(), null, 2, null);
        }
        if (this.state == State.TYPE) {
            this.readBsonType();
        }
        value$iv = this.state == State.END_OF_DOCUMENT;
        $i$f$validateOperation = false;
        if (!value$iv) {
            $i$a$-validateOperation-AbstractBsonReader$readEndDocument$3 = false;
            message$iv = "readEndDocument can only be called when State is " + (Object)State.END_OF_DOCUMENT + ", not when State is " + (Object)this.getState() + '.';
            throw new BsonInvalidOperationException(message$iv.toString(), null, 2, null);
        }
        this.doReadEndDocument();
        this.setStateOnEnd();
    }

    @Override
    public void readStartArray() {
        this.checkPreconditions("readStartArray", BsonType.ARRAY);
        this.doReadStartArray();
        this.state = State.TYPE;
    }

    @Override
    public void readEndArray() {
        if (!(!this.isClosed)) {
            boolean $i$a$-check-AbstractBsonReader$readEndArray$22 = false;
            String $i$a$-check-AbstractBsonReader$readEndArray$22 = "BinaryWriter is closed";
            throw new IllegalStateException($i$a$-check-AbstractBsonReader$readEndArray$22.toString());
        }
        Context context = this._context;
        boolean value$iv = (context == null ? null : context.getContextType()) == BsonContextType.ARRAY;
        boolean $i$f$validateOperation = false;
        if (!value$iv) {
            boolean bl = false;
            Context context2 = this.get_context();
            String message$iv = "readEndArray can only be called when contextType is " + (Object)((Object)BsonContextType.ARRAY) + ", not when contextType is " + (context2 == null ? null : context2.getContextType()) + '.';
            throw new BsonInvalidOperationException(message$iv.toString(), null, 2, null);
        }
        if (this.state == State.TYPE) {
            this.readBsonType();
        }
        value$iv = this.state == State.END_OF_ARRAY;
        $i$f$validateOperation = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "readEndArray can only be called when State is " + (Object)((Object)State.END_OF_ARRAY) + ", not when State is " + (Object)((Object)this.getState()) + '.';
            throw new BsonInvalidOperationException(message$iv.toString(), null, 2, null);
        }
        this.doReadEndArray();
        this.setStateOnEnd();
    }

    @Override
    @NotNull
    public BsonBinary readBinary() {
        this.checkPreconditions("readBinaryData", BsonType.BINARY);
        this.state = this.getNextState();
        return this.doReadBinaryData();
    }

    @Override
    @NotNull
    public BsonBoolean readBoolean() {
        this.checkPreconditions("readBoolean", BsonType.BOOLEAN);
        this.state = this.getNextState();
        return new BsonBoolean(this.doReadBoolean());
    }

    @Override
    @NotNull
    public BsonDateTime readDateTime() {
        this.checkPreconditions("readDateTime", BsonType.DATE_TIME);
        this.state = this.getNextState();
        return new BsonDateTime(this.doReadDateTime());
    }

    @Override
    @NotNull
    public BsonDouble readDouble() {
        this.checkPreconditions("readDouble", BsonType.DOUBLE);
        this.state = this.getNextState();
        return new BsonDouble(this.doReadDouble());
    }

    @Override
    @NotNull
    public BsonInt32 readInt32() {
        this.checkPreconditions("readInt32", BsonType.INT32);
        this.state = this.getNextState();
        return new BsonInt32(this.doReadInt32());
    }

    @Override
    @NotNull
    public BsonInt64 readInt64() {
        this.checkPreconditions("readInt64", BsonType.INT64);
        this.state = this.getNextState();
        return new BsonInt64(this.doReadInt64());
    }

    @Override
    @NotNull
    public BsonDecimal128 readDecimal128() {
        this.checkPreconditions("readDecimal", BsonType.DECIMAL128);
        this.state = this.getNextState();
        return this.doReadDecimal128();
    }

    @Override
    @NotNull
    public BsonJavaScript readJavaScript() {
        this.checkPreconditions("readJavaScript", BsonType.JAVASCRIPT);
        this.state = this.getNextState();
        return new BsonJavaScript(this.doReadJavaScript());
    }

    @Override
    @NotNull
    public String readJavaScriptWithScope() {
        this.checkPreconditions("readJavaScriptWithScope", BsonType.JAVASCRIPT_WITH_SCOPE);
        this.state = State.SCOPE_DOCUMENT;
        return this.doReadJavaScriptWithScope();
    }

    @Override
    @NotNull
    public BsonMaxKey readMaxKey() {
        this.checkPreconditions("readMaxKey", BsonType.MAX_KEY);
        this.state = this.getNextState();
        this.doReadMaxKey();
        return BsonMaxKey.INSTANCE;
    }

    @Override
    @NotNull
    public BsonMinKey readMinKey() {
        this.checkPreconditions("readMinKey", BsonType.MIN_KEY);
        this.state = this.getNextState();
        this.doReadMinKey();
        return BsonMinKey.INSTANCE;
    }

    @Override
    @NotNull
    public BsonNull readNull() {
        this.checkPreconditions("readNull", BsonType.NULL);
        this.state = this.getNextState();
        this.doReadNull();
        return BsonNull.INSTANCE;
    }

    @Override
    @NotNull
    public BsonObjectId readObjectId() {
        this.checkPreconditions("readObjectId", BsonType.OBJECT_ID);
        this.state = this.getNextState();
        return this.doReadObjectId();
    }

    @Override
    @NotNull
    public BsonRegularExpression readRegularExpression() {
        this.checkPreconditions("readRegularExpression", BsonType.REGULAR_EXPRESSION);
        this.state = this.getNextState();
        return this.doReadRegularExpression();
    }

    @Override
    @NotNull
    public BsonDBPointer readDBPointer() {
        this.checkPreconditions("readDBPointer", BsonType.DB_POINTER);
        this.state = this.getNextState();
        return this.doReadDBPointer();
    }

    @Override
    @NotNull
    public BsonString readString() {
        this.checkPreconditions("readString", BsonType.STRING);
        this.state = this.getNextState();
        return new BsonString(this.doReadString());
    }

    @Override
    @NotNull
    public BsonSymbol readSymbol() {
        this.checkPreconditions("readSymbol", BsonType.SYMBOL);
        this.state = this.getNextState();
        return new BsonSymbol(this.doReadSymbol());
    }

    @Override
    @NotNull
    public BsonTimestamp readTimestamp() {
        this.checkPreconditions("readTimestamp", BsonType.TIMESTAMP);
        this.state = this.getNextState();
        return new BsonTimestamp(this.doReadTimestamp());
    }

    @Override
    @NotNull
    public BsonUndefined readUndefined() {
        this.checkPreconditions("readUndefined", BsonType.UNDEFINED);
        this.state = this.getNextState();
        this.doReadUndefined();
        return BsonUndefined.INSTANCE;
    }

    @Override
    public void skipName() {
        if (!(!this.isClosed)) {
            boolean $i$a$-check-AbstractBsonReader$skipName$22 = false;
            String $i$a$-check-AbstractBsonReader$skipName$22 = "BsonReader is closed";
            throw new IllegalStateException($i$a$-check-AbstractBsonReader$skipName$22.toString());
        }
        boolean value$iv = this.state == State.NAME;
        boolean $i$f$validateOperation = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "skipName can only be called when State is " + (Object)((Object)State.NAME) + ", not when State is " + (Object)((Object)this.getState()) + '.';
            throw new BsonInvalidOperationException(message$iv.toString(), null, 2, null);
        }
        this.state = State.VALUE;
        this.doSkipName();
    }

    @Override
    public void skipValue() {
        if (!(!this.isClosed)) {
            boolean $i$a$-check-AbstractBsonReader$skipValue$22 = false;
            String $i$a$-check-AbstractBsonReader$skipValue$22 = "BsonReader is closed";
            throw new IllegalStateException($i$a$-check-AbstractBsonReader$skipValue$22.toString());
        }
        boolean value$iv = this.state == State.VALUE;
        boolean $i$f$validateOperation = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "skipValue can only be called when State is " + (Object)((Object)State.VALUE) + ", not when State is " + (Object)((Object)this.getState()) + '.';
            throw new BsonInvalidOperationException(message$iv.toString(), null, 2, null);
        }
        this.doSkipValue();
        this.state = State.TYPE;
    }

    @Override
    @NotNull
    public String readName() {
        if (!(!this.isClosed)) {
            boolean $i$a$-check-AbstractBsonReader$readName$22 = false;
            String $i$a$-check-AbstractBsonReader$readName$22 = "BsonReader is closed";
            throw new IllegalStateException($i$a$-check-AbstractBsonReader$readName$22.toString());
        }
        if (this.state == State.TYPE) {
            this.readBsonType();
        }
        boolean value$iv = this.state == State.NAME;
        boolean $i$f$validateOperation = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "readName can only be called when State is " + (Object)((Object)State.NAME) + ", not when State is " + (Object)((Object)this.getState()) + '.';
            throw new BsonInvalidOperationException(message$iv.toString(), null, 2, null);
        }
        this.state = State.VALUE;
        String string = this.getCurrentName();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    protected void checkPreconditions(@NotNull String methodName, @NotNull BsonType type) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!(!this.isClosed)) {
            boolean $i$a$-check-AbstractBsonReader$checkPreconditions$22 = false;
            String $i$a$-check-AbstractBsonReader$checkPreconditions$22 = "BsonReader is closed";
            throw new IllegalStateException($i$a$-check-AbstractBsonReader$checkPreconditions$22.toString());
        }
        if (this.state == State.INITIAL || this.state == State.SCOPE_DOCUMENT || this.state == State.TYPE) {
            this.readBsonType();
        }
        if (this.state == State.NAME) {
            this.skipName();
        }
        boolean value$iv = this.state == State.VALUE;
        boolean $i$f$validateOperation = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = methodName + " can only be called when State is " + (Object)((Object)State.VALUE) + ", not when State is " + (Object)((Object)this.getState()) + '.';
            throw new BsonInvalidOperationException(message$iv.toString(), null, 2, null);
        }
        value$iv = this.getCurrentBsonType() == type;
        $i$f$validateOperation = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = methodName + " can only be called when CurrentBsonType!! is " + (Object)((Object)type) + ", not when CurrentBsonType is: " + (Object)((Object)this.getCurrentBsonType()) + '.';
            throw new BsonInvalidOperationException(message$iv.toString(), null, 2, null);
        }
    }

    private final State getNextState() {
        State state;
        if (!(this._context != null)) {
            boolean bl = false;
            String string = "Unexpected ContextType";
            throw new IllegalStateException(string.toString());
        }
        Context context = this._context;
        Intrinsics.checkNotNull((Object)context);
        switch (WhenMappings.$EnumSwitchMapping$0[context.getContextType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                state = State.TYPE;
                break;
            }
            case 4: {
                state = State.DONE;
                break;
            }
            default: {
                Context context2 = this._context;
                Intrinsics.checkNotNull((Object)context2);
                throw new BsonException(Intrinsics.stringPlus((String)"Unexpected ContextType ", (Object)((Object)context2.getContextType())), null, null, 6, null);
            }
        }
        this.nextState = state;
        return this.nextState;
    }

    private final void setStateOnEnd() {
        State state;
        Context context = this._context;
        BsonContextType bsonContextType = context == null ? null : context.getContextType();
        switch (bsonContextType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[bsonContextType.ordinal()]) {
            case 1: 
            case 2: {
                state = State.TYPE;
                break;
            }
            case 4: {
                state = State.DONE;
                break;
            }
            case -1: {
                state = State.DONE;
                break;
            }
            default: {
                Context context2 = this._context;
                throw new BsonException(Intrinsics.stringPlus((String)"Unexpected ContextType ", (Object)(context2 == null ? null : context2.getContextType())), null, null, 6, null);
            }
        }
        this.state = state;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0096\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/mongodb/kbson/internal/io/AbstractBsonReader$Context;", "", "contextType", "Lorg/mongodb/kbson/internal/io/BsonContextType;", "(Lorg/mongodb/kbson/internal/io/AbstractBsonReader;Lorg/mongodb/kbson/internal/io/BsonContextType;)V", "getContextType", "()Lorg/mongodb/kbson/internal/io/BsonContextType;", "kbson"})
    public class Context {
        @NotNull
        private final BsonContextType contextType;

        public Context(BsonContextType contextType) {
            Intrinsics.checkNotNullParameter((Object)AbstractBsonReader.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)contextType), (String)"contextType");
            this.contextType = contextType;
        }

        @NotNull
        public final BsonContextType getContextType() {
            return this.contextType;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/mongodb/kbson/internal/io/AbstractBsonReader$State;", "", "(Ljava/lang/String;I)V", "INITIAL", "TYPE", "NAME", "VALUE", "SCOPE_DOCUMENT", "END_OF_DOCUMENT", "END_OF_ARRAY", "DONE", "kbson"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State INITIAL = new State();
        public static final /* enum */ State TYPE = new State();
        public static final /* enum */ State NAME = new State();
        public static final /* enum */ State VALUE = new State();
        public static final /* enum */ State SCOPE_DOCUMENT = new State();
        public static final /* enum */ State END_OF_DOCUMENT = new State();
        public static final /* enum */ State END_OF_ARRAY = new State();
        public static final /* enum */ State DONE = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.INITIAL, State.TYPE, State.NAME, State.VALUE, State.SCOPE_DOCUMENT, State.END_OF_DOCUMENT, State.END_OF_ARRAY, State.DONE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BsonContextType.values().length];
            nArray[BsonContextType.ARRAY.ordinal()] = 1;
            nArray[BsonContextType.DOCUMENT.ordinal()] = 2;
            nArray[BsonContextType.SCOPE_DOCUMENT.ordinal()] = 3;
            nArray[BsonContextType.TOP_LEVEL.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

