/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson.internal.io;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonBinary;
import org.mongodb.kbson.BsonDBPointer;
import org.mongodb.kbson.BsonDecimal128;
import org.mongodb.kbson.BsonInvalidOperationException;
import org.mongodb.kbson.BsonJavaScript;
import org.mongodb.kbson.BsonObjectId;
import org.mongodb.kbson.BsonRegularExpression;
import org.mongodb.kbson.BsonSerializationException;
import org.mongodb.kbson.BsonTimestamp;
import org.mongodb.kbson.BsonType;
import org.mongodb.kbson.internal.io.AbstractBsonWriter;
import org.mongodb.kbson.internal.io.BsonContextType;
import org.mongodb.kbson.internal.io.BsonReader;
import org.mongodb.kbson.internal.io.BsonWriter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001f\b \u0018\u00002\u00020\u0001:\u0002ghB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130 \"\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010!J!\u0010\"\u001a\u00020\u000e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130 \"\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u001cH\u0016J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'H$J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u000eH$J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020*H$J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020,H$J\u0010\u0010-\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020.H$J\u0010\u0010/\u001a\u00020\u001c2\u0006\u0010&\u001a\u000200H$J\b\u00101\u001a\u00020\u001cH$J\b\u00102\u001a\u00020\u001cH$J\u0010\u00103\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u0003H$J\u0010\u00104\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020,H$J\u0010\u00105\u001a\u00020\u001c2\u0006\u0010&\u001a\u000206H$J\u0010\u00107\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001eH$J\b\u00108\u001a\u00020\u001cH$J\b\u00109\u001a\u00020\u001cH$J\u0010\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020\u001eH$J\b\u0010<\u001a\u00020\u001cH$J\u0010\u0010=\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020>H$J\u0010\u0010?\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020@H$J\b\u0010A\u001a\u00020\u001cH$J\b\u0010B\u001a\u00020\u001cH$J\u0010\u0010C\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001eH$J\u0010\u0010D\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001eH$J\u0010\u0010E\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020FH$J\b\u0010G\u001a\u00020\u001cH$J\u0010\u0010H\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010L\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010M\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010N\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010O\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010P\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u000eH\u0016J\u0010\u0010Q\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020*H\u0016J\u0010\u0010R\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020,H\u0016J\u0010\u0010S\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020.H\u0016J\u0010\u0010T\u001a\u00020\u001c2\u0006\u0010&\u001a\u000200H\u0016J\b\u0010U\u001a\u00020\u001cH\u0016J\b\u0010V\u001a\u00020\u001cH\u0016J\u0010\u0010W\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u0003H\u0016J\u0010\u0010X\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020,H\u0016J\u0010\u0010Y\u001a\u00020\u001c2\u0006\u0010&\u001a\u000206H\u0016J\u0010\u0010Z\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001eH\u0016J\b\u0010[\u001a\u00020\u001cH\u0016J\b\u0010\\\u001a\u00020\u001cH\u0016J\u0010\u0010]\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020\u001eH\u0016J\b\u0010^\u001a\u00020\u001cH\u0016J\u0010\u0010_\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020>H\u0016J\u0010\u0010`\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020@H\u0016J\b\u0010a\u001a\u00020\u001cH\u0016J\b\u0010b\u001a\u00020\u001cH\u0016J\u0010\u0010c\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001eH\u0016J\u0010\u0010d\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001eH\u0016J\u0010\u0010e\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020FH\u0016J\b\u0010f\u001a\u00020\u001cH\u0016R&\u0010\u0005\u001a\b\u0018\u00010\u0006R\u00020\u0000X\u0084\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u001a\u00a8\u0006i"}, d2={"Lorg/mongodb/kbson/internal/io/AbstractBsonWriter;", "Lorg/mongodb/kbson/internal/io/BsonWriter;", "maxSerializationDepth", "", "(I)V", "_context", "Lorg/mongodb/kbson/internal/io/AbstractBsonWriter$Context;", "get_context$annotations", "()V", "get_context", "()Lorg/mongodb/kbson/internal/io/AbstractBsonWriter$Context;", "set_context", "(Lorg/mongodb/kbson/internal/io/AbstractBsonWriter$Context;)V", "isClosed", "", "()Z", "setClosed", "(Z)V", "nextState", "Lorg/mongodb/kbson/internal/io/AbstractBsonWriter$State;", "getNextState", "()Lorg/mongodb/kbson/internal/io/AbstractBsonWriter$State;", "serializationDepth", "state", "getState", "setState", "(Lorg/mongodb/kbson/internal/io/AbstractBsonWriter$State;)V", "checkPreconditions", "", "methodName", "", "validStates", "", "(Ljava/lang/String;[Lorg/mongodb/kbson/internal/io/AbstractBsonWriter$State;)V", "checkState", "([Lorg/mongodb/kbson/internal/io/AbstractBsonWriter$State;)Z", "close", "doWriteBinaryData", "value", "Lorg/mongodb/kbson/BsonBinary;", "doWriteBoolean", "doWriteDBPointer", "Lorg/mongodb/kbson/BsonDBPointer;", "doWriteDateTime", "", "doWriteDecimal128", "Lorg/mongodb/kbson/BsonDecimal128;", "doWriteDouble", "", "doWriteEndArray", "doWriteEndDocument", "doWriteInt32", "doWriteInt64", "doWriteJavaScript", "Lorg/mongodb/kbson/BsonJavaScript;", "doWriteJavaScriptWithScope", "doWriteMaxKey", "doWriteMinKey", "doWriteName", "name", "doWriteNull", "doWriteObjectId", "Lorg/mongodb/kbson/BsonObjectId;", "doWriteRegularExpression", "Lorg/mongodb/kbson/BsonRegularExpression;", "doWriteStartArray", "doWriteStartDocument", "doWriteString", "doWriteSymbol", "doWriteTimestamp", "Lorg/mongodb/kbson/BsonTimestamp;", "doWriteUndefined", "pipe", "reader", "Lorg/mongodb/kbson/internal/io/BsonReader;", "pipeArray", "pipeDocument", "pipeJavascriptWithScope", "pipeValue", "writeBinaryData", "writeBoolean", "writeDBPointer", "writeDateTime", "writeDecimal128", "writeDouble", "writeEndArray", "writeEndDocument", "writeInt32", "writeInt64", "writeJavaScript", "writeJavaScriptWithScope", "writeMaxKey", "writeMinKey", "writeName", "writeNull", "writeObjectId", "writeRegularExpression", "writeStartArray", "writeStartDocument", "writeString", "writeSymbol", "writeTimestamp", "writeUndefined", "Context", "State", "kbson"})
public abstract class AbstractBsonWriter
implements BsonWriter {
    private final int maxSerializationDepth;
    @NotNull
    private State state;
    @Nullable
    private Context _context;
    private int serializationDepth;
    private boolean isClosed;

    public AbstractBsonWriter(int maxSerializationDepth) {
        this.maxSerializationDepth = maxSerializationDepth;
        this.state = State.INITIAL;
    }

    public /* synthetic */ AbstractBsonWriter(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1024;
        }
        this(n);
    }

    @NotNull
    protected final State getState() {
        return this.state;
    }

    protected final void setState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    @Nullable
    protected final Context get_context() {
        return this._context;
    }

    protected final void set_context(@Nullable Context context) {
        this._context = context;
    }

    protected static /* synthetic */ void get_context$annotations() {
    }

    protected final boolean isClosed() {
        return this.isClosed;
    }

    protected final void setClosed(boolean bl) {
        this.isClosed = bl;
    }

    protected abstract void doWriteStartDocument();

    protected abstract void doWriteEndDocument();

    protected abstract void doWriteStartArray();

    protected abstract void doWriteEndArray();

    protected abstract void doWriteBinaryData(@NotNull BsonBinary var1);

    protected abstract void doWriteBoolean(boolean var1);

    protected abstract void doWriteDateTime(long var1);

    protected abstract void doWriteDBPointer(@NotNull BsonDBPointer var1);

    protected abstract void doWriteDouble(double var1);

    protected abstract void doWriteInt32(int var1);

    protected abstract void doWriteInt64(long var1);

    protected abstract void doWriteDecimal128(@NotNull BsonDecimal128 var1);

    protected abstract void doWriteJavaScript(@NotNull BsonJavaScript var1);

    protected abstract void doWriteJavaScriptWithScope(@NotNull String var1);

    protected abstract void doWriteMaxKey();

    protected abstract void doWriteMinKey();

    protected abstract void doWriteNull();

    protected abstract void doWriteObjectId(@NotNull BsonObjectId var1);

    protected abstract void doWriteRegularExpression(@NotNull BsonRegularExpression var1);

    protected abstract void doWriteString(@NotNull String var1);

    protected abstract void doWriteSymbol(@NotNull String var1);

    protected abstract void doWriteTimestamp(@NotNull BsonTimestamp var1);

    protected abstract void doWriteUndefined();

    protected abstract void doWriteName(@NotNull String var1);

    @Override
    public void writeStartDocument() {
        State[] stateArray = new State[]{State.INITIAL, State.VALUE, State.SCOPE_DOCUMENT, State.DONE};
        this.checkPreconditions("writeStartDocument", stateArray);
        int n = this.serializationDepth;
        this.serializationDepth = n + 1;
        boolean value$iv = this.serializationDepth <= this.maxSerializationDepth;
        boolean $i$f$validateSerialization = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Maximum serialization depth exceeded (does the object being serialized have a circular reference).";
            throw new BsonSerializationException(message$iv.toString(), null, 2, null);
        }
        this.doWriteStartDocument();
        this.state = State.NAME;
    }

    @Override
    public void writeEndDocument() {
        State[] stateArray = new State[]{State.NAME};
        this.checkPreconditions("writeEndDocument", stateArray);
        Context context = this._context;
        Intrinsics.checkNotNull((Object)context);
        BsonContextType contextType = context.getContextType();
        boolean value$iv = contextType == BsonContextType.DOCUMENT || contextType == BsonContextType.SCOPE_DOCUMENT;
        boolean $i$f$validateOperation = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "WriteEndDocuent can only be called when ContextType is DOCUMENT or SCOPE_DOCUMENT, not when ContextType is " + (Object)((Object)contextType) + '.';
            throw new BsonInvalidOperationException(message$iv.toString(), null, 2, null);
        }
        int n = this.serializationDepth;
        this.serializationDepth = n + -1;
        this.doWriteEndDocument();
        Context context2 = this._context;
        this.state = (context2 == null ? null : context2.getContextType()) == BsonContextType.TOP_LEVEL ? State.DONE : this.getNextState();
    }

    @Override
    public void writeStartArray() {
        State[] stateArray = new State[]{State.VALUE};
        this.checkPreconditions("writeStartArray", stateArray);
        int n = this.serializationDepth;
        this.serializationDepth = n + 1;
        boolean value$iv = this.serializationDepth <= this.maxSerializationDepth;
        boolean $i$f$validateSerialization = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Maximum serialization depth exceeded (does the object being serialized have a circular reference).";
            throw new BsonSerializationException(message$iv.toString(), null, 2, null);
        }
        this.doWriteStartArray();
        this.state = State.VALUE;
    }

    @Override
    public void writeEndArray() {
        State[] stateArray = new State[]{State.VALUE};
        this.checkPreconditions("writeEndArray", stateArray);
        Context context = this._context;
        Intrinsics.checkNotNull((Object)context);
        BsonContextType contextType = context.getContextType();
        boolean value$iv = contextType == BsonContextType.ARRAY;
        boolean $i$f$validateOperation = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "WriteEndArray can only be called when ContextType is Array, not when ContextType is " + (Object)((Object)contextType) + '.';
            throw new BsonInvalidOperationException(message$iv.toString(), null, 2, null);
        }
        int n = this.serializationDepth;
        this.serializationDepth = n + -1;
        this.doWriteEndArray();
        this.state = this.getNextState();
    }

    @Override
    public void writeBinaryData(@NotNull BsonBinary value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        State[] stateArray = new State[]{State.VALUE, State.INITIAL};
        this.checkPreconditions("writeBinaryData", stateArray);
        this.doWriteBinaryData(value);
        this.state = this.getNextState();
    }

    @Override
    public void writeBoolean(boolean value) {
        State[] stateArray = new State[]{State.VALUE, State.INITIAL};
        this.checkPreconditions("writeBoolean", stateArray);
        this.doWriteBoolean(value);
        this.state = this.getNextState();
    }

    @Override
    public void writeDateTime(long value) {
        State[] stateArray = new State[]{State.VALUE, State.INITIAL};
        this.checkPreconditions("writeDateTime", stateArray);
        this.doWriteDateTime(value);
        this.state = this.getNextState();
    }

    @Override
    public void writeDBPointer(@NotNull BsonDBPointer value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        State[] stateArray = new State[]{State.VALUE, State.INITIAL};
        this.checkPreconditions("writeDBPointer", stateArray);
        this.doWriteDBPointer(value);
        this.state = this.getNextState();
    }

    @Override
    public void writeDouble(double value) {
        State[] stateArray = new State[]{State.VALUE, State.INITIAL};
        this.checkPreconditions("writeDBPointer", stateArray);
        this.doWriteDouble(value);
        this.state = this.getNextState();
    }

    @Override
    public void writeInt32(int value) {
        State[] stateArray = new State[]{State.VALUE};
        this.checkPreconditions("writeInt32", stateArray);
        this.doWriteInt32(value);
        this.state = this.getNextState();
    }

    @Override
    public void writeInt64(long value) {
        State[] stateArray = new State[]{State.VALUE};
        this.checkPreconditions("writeInt64", stateArray);
        this.doWriteInt64(value);
        this.state = this.getNextState();
    }

    @Override
    public void writeDecimal128(@NotNull BsonDecimal128 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        State[] stateArray = new State[]{State.VALUE};
        this.checkPreconditions("writeInt64", stateArray);
        this.doWriteDecimal128(value);
        this.state = this.getNextState();
    }

    @Override
    public void writeJavaScript(@NotNull BsonJavaScript value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        State[] stateArray = new State[]{State.VALUE};
        this.checkPreconditions("writeJavaScript", stateArray);
        this.doWriteJavaScript(value);
        this.state = this.getNextState();
    }

    @Override
    public void writeJavaScriptWithScope(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        State[] stateArray = new State[]{State.VALUE};
        this.checkPreconditions("writeJavaScriptWithScope", stateArray);
        this.doWriteJavaScriptWithScope(value);
        this.state = State.SCOPE_DOCUMENT;
    }

    @Override
    public void writeMaxKey() {
        State[] stateArray = new State[]{State.VALUE};
        this.checkPreconditions("writeMaxKey", stateArray);
        this.doWriteMaxKey();
        this.state = this.getNextState();
    }

    @Override
    public void writeMinKey() {
        State[] stateArray = new State[]{State.VALUE};
        this.checkPreconditions("writeMinKey", stateArray);
        this.doWriteMinKey();
        this.state = this.getNextState();
    }

    @Override
    public void writeName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean value$iv = this.state == State.NAME;
        boolean $i$f$validateOperation = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "writeName can only be called when State is " + (Object)((Object)State.NAME) + ", not when State is " + (Object)((Object)this.getState());
            throw new BsonInvalidOperationException(message$iv.toString(), null, 2, null);
        }
        this.doWriteName(name);
        this.state = State.VALUE;
    }

    @Override
    public void writeNull() {
        State[] stateArray = new State[]{State.VALUE};
        this.checkPreconditions("writeNull", stateArray);
        this.doWriteNull();
        this.state = this.getNextState();
    }

    @Override
    public void writeObjectId(@NotNull BsonObjectId value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        State[] stateArray = new State[]{State.VALUE};
        this.checkPreconditions("writeObjectId", stateArray);
        this.doWriteObjectId(value);
        this.state = this.getNextState();
    }

    @Override
    public void writeRegularExpression(@NotNull BsonRegularExpression value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        State[] stateArray = new State[]{State.VALUE};
        this.checkPreconditions("writeRegularExpression", stateArray);
        this.doWriteRegularExpression(value);
        this.state = this.getNextState();
    }

    @Override
    public void writeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        State[] stateArray = new State[]{State.VALUE};
        this.checkPreconditions("writeString", stateArray);
        this.doWriteString(value);
        this.state = this.getNextState();
    }

    @Override
    public void writeSymbol(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        State[] stateArray = new State[]{State.VALUE};
        this.checkPreconditions("writeSymbol", stateArray);
        this.doWriteSymbol(value);
        this.state = this.getNextState();
    }

    @Override
    public void writeTimestamp(@NotNull BsonTimestamp value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        State[] stateArray = new State[]{State.VALUE};
        this.checkPreconditions("writeTimestamp", stateArray);
        this.doWriteTimestamp(value);
        this.state = this.getNextState();
    }

    @Override
    public void writeUndefined() {
        State[] stateArray = new State[]{State.VALUE};
        this.checkPreconditions("writeUndefined", stateArray);
        this.doWriteUndefined();
        this.state = this.getNextState();
    }

    private final State getNextState() {
        Context context = this._context;
        return (context == null ? null : context.getContextType()) == BsonContextType.ARRAY ? State.VALUE : State.NAME;
    }

    private final boolean checkState(State ... validStates) {
        State state;
        block1: {
            for (State state2 : validStates) {
                State it = state2;
                boolean bl = false;
                if (!(it == this.getState())) continue;
                state = state2;
                break block1;
            }
            state = null;
        }
        return state != null;
    }

    private final void checkPreconditions(String methodName, State ... validStates) {
        if (!(!this.isClosed)) {
            boolean $i$a$-check-AbstractBsonWriter$checkPreconditions$22 = false;
            String $i$a$-check-AbstractBsonWriter$checkPreconditions$22 = "BsonWriter is closed";
            throw new IllegalStateException($i$a$-check-AbstractBsonWriter$checkPreconditions$22.toString());
        }
        boolean value$iv = this.checkState(Arrays.copyOf(validStates, validStates.length));
        boolean $i$f$validateOperation = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = methodName + " can only be called when the State is " + ArraysKt.joinToString$default((Object[])validStates, (CharSequence)" or ", null, null, (int)0, null, (Function1)checkPreconditions.2.1.INSTANCE, (int)30, null) + ", not when State is " + (Object)((Object)this.getState()) + '.';
            throw new BsonInvalidOperationException(message$iv.toString(), null, 2, null);
        }
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public void pipe(@NotNull BsonReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.pipeDocument(reader);
    }

    private final void pipeDocument(BsonReader reader) {
        reader.readStartDocument();
        this.writeStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            this.writeName(reader.readName());
            this.pipeValue(reader);
        }
        reader.readEndDocument();
        this.writeEndDocument();
    }

    private final void pipeValue(BsonReader reader) {
        BsonType bsonType = reader.getCurrentBsonType();
        switch (bsonType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[bsonType.ordinal()]) {
            case 1: {
                this.pipeArray(reader);
                break;
            }
            case 2: {
                this.writeBinaryData(reader.readBinary());
                break;
            }
            case 3: {
                this.writeBoolean(reader.readBoolean().getValue());
                break;
            }
            case 4: {
                this.writeDateTime(reader.readDateTime().getValue());
                break;
            }
            case 5: {
                this.writeDBPointer(reader.readDBPointer());
                break;
            }
            case 6: {
                this.writeDecimal128(reader.readDecimal128());
                break;
            }
            case 7: {
                this.pipeDocument(reader);
                break;
            }
            case 8: {
                this.writeDouble(reader.readDouble().doubleValue());
                break;
            }
            case 9: {
                this.writeInt32(reader.readInt32().intValue());
                break;
            }
            case 10: {
                this.writeInt64(reader.readInt64().longValue());
                break;
            }
            case 11: {
                this.writeJavaScript(reader.readJavaScript());
                break;
            }
            case 12: {
                this.pipeJavascriptWithScope(reader);
                break;
            }
            case 13: {
                this.writeObjectId(reader.readObjectId());
                break;
            }
            case 14: {
                this.writeRegularExpression(reader.readRegularExpression());
                break;
            }
            case 15: {
                this.writeString(reader.readString().getValue());
                break;
            }
            case 16: {
                this.writeSymbol(reader.readSymbol().getValue());
                break;
            }
            case 17: {
                this.writeTimestamp(reader.readTimestamp());
                break;
            }
            case 18: {
                reader.readMaxKey();
                this.writeMaxKey();
                break;
            }
            case 19: {
                reader.readMinKey();
                this.writeMinKey();
                break;
            }
            case 20: {
                reader.readNull();
                this.writeNull();
                break;
            }
            case 21: {
                reader.readUndefined();
                this.writeUndefined();
                break;
            }
            default: {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"unhandled BSON type: ", (Object)((Object)reader.getCurrentBsonType())));
            }
        }
    }

    private final void pipeArray(BsonReader reader) {
        reader.readStartArray();
        this.writeStartArray();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            this.pipeValue(reader);
        }
        reader.readEndArray();
        this.writeEndArray();
    }

    private final void pipeJavascriptWithScope(BsonReader reader) {
        this.writeJavaScriptWithScope(reader.readJavaScriptWithScope());
        this.pipeDocument(reader);
    }

    public AbstractBsonWriter() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0084\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/mongodb/kbson/internal/io/AbstractBsonWriter$State;", "", "(Ljava/lang/String;I)V", "INITIAL", "NAME", "VALUE", "SCOPE_DOCUMENT", "DONE", "kbson"})
    protected static final class State
    extends Enum<State> {
        public static final /* enum */ State INITIAL = new State();
        public static final /* enum */ State NAME = new State();
        public static final /* enum */ State VALUE = new State();
        public static final /* enum */ State SCOPE_DOCUMENT = new State();
        public static final /* enum */ State DONE = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.INITIAL, State.NAME, State.VALUE, State.SCOPE_DOCUMENT, State.DONE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0096\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/mongodb/kbson/internal/io/AbstractBsonWriter$Context;", "", "contextType", "Lorg/mongodb/kbson/internal/io/BsonContextType;", "name", "", "(Lorg/mongodb/kbson/internal/io/AbstractBsonWriter;Lorg/mongodb/kbson/internal/io/BsonContextType;Ljava/lang/String;)V", "getContextType", "()Lorg/mongodb/kbson/internal/io/BsonContextType;", "getName", "()Ljava/lang/String;", "kbson"})
    public class Context {
        @NotNull
        private final BsonContextType contextType;
        @Nullable
        private final String name;

        public Context(@Nullable BsonContextType contextType, String name) {
            Intrinsics.checkNotNullParameter((Object)AbstractBsonWriter.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)contextType), (String)"contextType");
            this.contextType = contextType;
            this.name = name;
        }

        public /* synthetic */ Context(BsonContextType bsonContextType, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = null;
            }
            this(bsonContextType, string);
        }

        @NotNull
        public final BsonContextType getContextType() {
            return this.contextType;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BsonType.values().length];
            nArray[BsonType.ARRAY.ordinal()] = 1;
            nArray[BsonType.BINARY.ordinal()] = 2;
            nArray[BsonType.BOOLEAN.ordinal()] = 3;
            nArray[BsonType.DATE_TIME.ordinal()] = 4;
            nArray[BsonType.DB_POINTER.ordinal()] = 5;
            nArray[BsonType.DECIMAL128.ordinal()] = 6;
            nArray[BsonType.DOCUMENT.ordinal()] = 7;
            nArray[BsonType.DOUBLE.ordinal()] = 8;
            nArray[BsonType.INT32.ordinal()] = 9;
            nArray[BsonType.INT64.ordinal()] = 10;
            nArray[BsonType.JAVASCRIPT.ordinal()] = 11;
            nArray[BsonType.JAVASCRIPT_WITH_SCOPE.ordinal()] = 12;
            nArray[BsonType.OBJECT_ID.ordinal()] = 13;
            nArray[BsonType.REGULAR_EXPRESSION.ordinal()] = 14;
            nArray[BsonType.STRING.ordinal()] = 15;
            nArray[BsonType.SYMBOL.ordinal()] = 16;
            nArray[BsonType.TIMESTAMP.ordinal()] = 17;
            nArray[BsonType.MAX_KEY.ordinal()] = 18;
            nArray[BsonType.MIN_KEY.ordinal()] = 19;
            nArray[BsonType.NULL.ordinal()] = 20;
            nArray[BsonType.UNDEFINED.ordinal()] = 21;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

