/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson.internal.io;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonBinary;
import org.mongodb.kbson.BsonBinarySubType;
import org.mongodb.kbson.BsonDBPointer;
import org.mongodb.kbson.BsonDecimal128;
import org.mongodb.kbson.BsonJavaScript;
import org.mongodb.kbson.BsonObjectId;
import org.mongodb.kbson.BsonRegularExpression;
import org.mongodb.kbson.BsonTimestamp;
import org.mongodb.kbson.BsonType;
import org.mongodb.kbson.internal.io.AbstractBsonWriter;
import org.mongodb.kbson.internal.io.BsonContextType;
import org.mongodb.kbson.internal.io.ByteArrayBsonOutput;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 52\u00020\u0001:\u000245B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\fH\u0014J\b\u0010\u001b\u001a\u00020\fH\u0014J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0015H\u0014J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\fH\u0014J\b\u0010$\u001a\u00020\fH\u0014J\u0010\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\"H\u0014J\b\u0010'\u001a\u00020\fH\u0014J\u0010\u0010(\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020+H\u0014J\b\u0010,\u001a\u00020\fH\u0014J\b\u0010-\u001a\u00020\fH\u0014J\u0010\u0010.\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\"H\u0014J\u0010\u0010/\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\"H\u0014J\u0010\u00100\u001a\u00020\f2\u0006\u0010\u000e\u001a\u000201H\u0014J\b\u00102\u001a\u00020\fH\u0014J\b\u00103\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R&\u0010\u0007\u001a\u00060\bR\u00020\u00002\n\u0010\u0007\u001a\u00060\bR\u00020\u0000@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\t\u0010\n\u00a8\u00066"}, d2={"Lorg/mongodb/kbson/internal/io/BsonBinaryWriter;", "Lorg/mongodb/kbson/internal/io/AbstractBsonWriter;", "bsonOutput", "Lorg/mongodb/kbson/internal/io/ByteArrayBsonOutput;", "(Lorg/mongodb/kbson/internal/io/ByteArrayBsonOutput;)V", "getBsonOutput", "()Lorg/mongodb/kbson/internal/io/ByteArrayBsonOutput;", "context", "Lorg/mongodb/kbson/internal/io/BsonBinaryWriter$BsonBinaryWriterContext;", "setContext", "(Lorg/mongodb/kbson/internal/io/BsonBinaryWriter$BsonBinaryWriterContext;)V", "backpatchSize", "", "doWriteBinaryData", "value", "Lorg/mongodb/kbson/BsonBinary;", "doWriteBoolean", "", "doWriteDBPointer", "Lorg/mongodb/kbson/BsonDBPointer;", "doWriteDateTime", "", "doWriteDecimal128", "Lorg/mongodb/kbson/BsonDecimal128;", "doWriteDouble", "", "doWriteEndArray", "doWriteEndDocument", "doWriteInt32", "", "doWriteInt64", "doWriteJavaScript", "Lorg/mongodb/kbson/BsonJavaScript;", "doWriteJavaScriptWithScope", "", "doWriteMaxKey", "doWriteMinKey", "doWriteName", "name", "doWriteNull", "doWriteObjectId", "Lorg/mongodb/kbson/BsonObjectId;", "doWriteRegularExpression", "Lorg/mongodb/kbson/BsonRegularExpression;", "doWriteStartArray", "doWriteStartDocument", "doWriteString", "doWriteSymbol", "doWriteTimestamp", "Lorg/mongodb/kbson/BsonTimestamp;", "doWriteUndefined", "writeCurrentName", "BsonBinaryWriterContext", "Companion", "kbson"})
public final class BsonBinaryWriter
extends AbstractBsonWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteArrayBsonOutput bsonOutput;
    @NotNull
    private BsonBinaryWriterContext context;

    public BsonBinaryWriter(@NotNull ByteArrayBsonOutput bsonOutput) {
        Intrinsics.checkNotNullParameter((Object)bsonOutput, (String)"bsonOutput");
        super(0, 1, null);
        this.bsonOutput = bsonOutput;
        this.context = new BsonBinaryWriterContext(null, BsonContextType.TOP_LEVEL, null, 0, 0, 16, null);
    }

    @NotNull
    public final ByteArrayBsonOutput getBsonOutput() {
        return this.bsonOutput;
    }

    private final void setContext(BsonBinaryWriterContext context) {
        this.set_context(context);
        this.context = context;
    }

    @Override
    protected void doWriteStartDocument() {
        if (this.getState() == AbstractBsonWriter.State.VALUE) {
            this.bsonOutput.writeByte(BsonType.DOCUMENT.toByte$kbson());
            this.writeCurrentName();
        }
        this.setContext(new BsonBinaryWriterContext(this.context, BsonContextType.DOCUMENT, this.context.getName(), this.bsonOutput.getPosition(), 0, 16, null));
        this.bsonOutput.writeInt32(0);
    }

    @Override
    protected void doWriteEndDocument() {
        this.bsonOutput.writeByte((byte)0);
        this.backpatchSize();
        BsonBinaryWriterContext bsonBinaryWriterContext = this.context.getParentContext();
        Intrinsics.checkNotNull((Object)bsonBinaryWriterContext);
        this.setContext(bsonBinaryWriterContext);
        if (this.context.getContextType() == BsonContextType.JAVASCRIPT_WITH_SCOPE) {
            this.backpatchSize();
            BsonBinaryWriterContext bsonBinaryWriterContext2 = this.context.getParentContext();
            Intrinsics.checkNotNull((Object)bsonBinaryWriterContext2);
            this.setContext(bsonBinaryWriterContext2);
        }
    }

    @Override
    protected void doWriteStartArray() {
        this.bsonOutput.writeByte(BsonType.ARRAY.toByte$kbson());
        this.writeCurrentName();
        this.setContext(new BsonBinaryWriterContext(this.context, BsonContextType.ARRAY, this.context.getName(), this.bsonOutput.getPosition(), 0, 16, null));
        this.bsonOutput.writeInt32(0);
    }

    @Override
    protected void doWriteEndArray() {
        this.bsonOutput.writeByte((byte)0);
        this.backpatchSize();
        BsonBinaryWriterContext bsonBinaryWriterContext = this.context.getParentContext();
        Intrinsics.checkNotNull((Object)bsonBinaryWriterContext);
        this.setContext(bsonBinaryWriterContext);
    }

    @Override
    protected void doWriteBinaryData(@NotNull BsonBinary value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bsonOutput.writeByte(BsonType.BINARY.toByte$kbson());
        this.writeCurrentName();
        int totalLength = value.getData().length;
        if (value.getType() == BsonBinarySubType.OLD_BINARY.getValue()) {
            totalLength += 4;
        }
        this.bsonOutput.writeInt32(totalLength);
        this.bsonOutput.writeByte(value.getType());
        if (value.getType() == BsonBinarySubType.OLD_BINARY.getValue()) {
            this.bsonOutput.writeInt32(totalLength - 4);
        }
        this.bsonOutput.writeBytes(value.getData());
    }

    @Override
    protected void doWriteBoolean(boolean value) {
        this.bsonOutput.writeByte(BsonType.BOOLEAN.toByte$kbson());
        this.writeCurrentName();
        this.bsonOutput.writeByte(value ? (byte)1 : 0);
    }

    @Override
    protected void doWriteDateTime(long value) {
        this.bsonOutput.writeByte(BsonType.DATE_TIME.toByte$kbson());
        this.writeCurrentName();
        this.bsonOutput.writeInt64(value);
    }

    @Override
    protected void doWriteDBPointer(@NotNull BsonDBPointer value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bsonOutput.writeByte(BsonType.DB_POINTER.toByte$kbson());
        this.writeCurrentName();
        this.bsonOutput.writeString(value.getNamespace());
        this.bsonOutput.writeBytes(value.getId().toByteArray());
    }

    @Override
    protected void doWriteDouble(double value) {
        this.bsonOutput.writeByte(BsonType.DOUBLE.toByte$kbson());
        this.writeCurrentName();
        this.bsonOutput.writeDouble(value);
    }

    @Override
    protected void doWriteInt32(int value) {
        this.bsonOutput.writeByte(BsonType.INT32.toByte$kbson());
        this.writeCurrentName();
        this.bsonOutput.writeInt32(value);
    }

    @Override
    protected void doWriteInt64(long value) {
        this.bsonOutput.writeByte(BsonType.INT64.toByte$kbson());
        this.writeCurrentName();
        this.bsonOutput.writeInt64(value);
    }

    @Override
    protected void doWriteDecimal128(@NotNull BsonDecimal128 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bsonOutput.writeByte(BsonType.DECIMAL128.toByte$kbson());
        this.writeCurrentName();
        this.bsonOutput.writeInt64(value.getValue$kbson().getLow-s-VKNKU());
        this.bsonOutput.writeInt64(value.getValue$kbson().getHigh-s-VKNKU());
    }

    @Override
    protected void doWriteJavaScript(@NotNull BsonJavaScript value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bsonOutput.writeByte(BsonType.JAVASCRIPT.toByte$kbson());
        this.writeCurrentName();
        this.bsonOutput.writeString(value.getCode());
    }

    @Override
    protected void doWriteJavaScriptWithScope(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bsonOutput.writeByte(BsonType.JAVASCRIPT_WITH_SCOPE.toByte$kbson());
        this.writeCurrentName();
        this.setContext(new BsonBinaryWriterContext(this.context, BsonContextType.JAVASCRIPT_WITH_SCOPE, this.context.getName(), this.bsonOutput.getPosition(), 0, 16, null));
        this.bsonOutput.writeInt32(0);
        this.bsonOutput.writeString(value);
    }

    @Override
    protected void doWriteMaxKey() {
        this.bsonOutput.writeByte(BsonType.MAX_KEY.toByte$kbson());
        this.writeCurrentName();
    }

    @Override
    protected void doWriteMinKey() {
        this.bsonOutput.writeByte(BsonType.MIN_KEY.toByte$kbson());
        this.writeCurrentName();
    }

    @Override
    protected void doWriteNull() {
        this.bsonOutput.writeByte(BsonType.NULL.toByte$kbson());
        this.writeCurrentName();
    }

    @Override
    protected void doWriteObjectId(@NotNull BsonObjectId value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bsonOutput.writeByte(BsonType.OBJECT_ID.toByte$kbson());
        this.writeCurrentName();
        this.bsonOutput.writeBytes(value.toByteArray());
    }

    @Override
    protected void doWriteRegularExpression(@NotNull BsonRegularExpression value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bsonOutput.writeByte(BsonType.REGULAR_EXPRESSION.toByte$kbson());
        this.writeCurrentName();
        this.bsonOutput.writeCString(value.getPattern());
        this.bsonOutput.writeCString(value.getOptions());
    }

    @Override
    protected void doWriteString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bsonOutput.writeByte(BsonType.STRING.toByte$kbson());
        this.writeCurrentName();
        this.bsonOutput.writeString(value);
    }

    @Override
    protected void doWriteSymbol(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bsonOutput.writeByte(BsonType.SYMBOL.toByte$kbson());
        this.writeCurrentName();
        this.bsonOutput.writeString(value);
    }

    @Override
    protected void doWriteTimestamp(@NotNull BsonTimestamp value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bsonOutput.writeByte(BsonType.TIMESTAMP.toByte$kbson());
        this.writeCurrentName();
        this.bsonOutput.writeInt64(value.getValue());
    }

    @Override
    protected void doWriteUndefined() {
        this.bsonOutput.writeByte(BsonType.UNDEFINED.toByte$kbson());
        this.writeCurrentName();
    }

    @Override
    protected void doWriteName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.setContext(new BsonBinaryWriterContext(this.context.getParentContext(), this.context.getContextType(), name, this.context.getStartPosition(), this.context.getIndex()));
    }

    private final void writeCurrentName() {
        if (this.context.getContextType() == BsonContextType.ARRAY) {
            BsonBinaryWriterContext bsonBinaryWriterContext = this.context;
            int n = bsonBinaryWriterContext.getIndex();
            bsonBinaryWriterContext.setIndex(n + 1);
            this.bsonOutput.writeCString(String.valueOf(n));
        } else {
            String string = this.context.getName();
            Intrinsics.checkNotNull((Object)string);
            this.bsonOutput.writeCString(string);
        }
    }

    private final void backpatchSize() {
        int size = this.bsonOutput.getPosition() - this.context.getStartPosition();
        this.bsonOutput.writeInt32(this.bsonOutput.getPosition() - size, size);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B7\u0012\f\u0010\u0003\u001a\b\u0018\u00010\u0000R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fR\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0003\u001a\b\u0018\u00010\u0000R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/mongodb/kbson/internal/io/BsonBinaryWriter$BsonBinaryWriterContext;", "Lorg/mongodb/kbson/internal/io/AbstractBsonWriter$Context;", "Lorg/mongodb/kbson/internal/io/AbstractBsonWriter;", "parentContext", "Lorg/mongodb/kbson/internal/io/BsonBinaryWriter;", "contextType", "Lorg/mongodb/kbson/internal/io/BsonContextType;", "currentName", "", "startPosition", "", "index", "(Lorg/mongodb/kbson/internal/io/BsonBinaryWriter;Lorg/mongodb/kbson/internal/io/BsonBinaryWriter$BsonBinaryWriterContext;Lorg/mongodb/kbson/internal/io/BsonContextType;Ljava/lang/String;II)V", "getIndex", "()I", "setIndex", "(I)V", "getParentContext", "()Lorg/mongodb/kbson/internal/io/BsonBinaryWriter$BsonBinaryWriterContext;", "getStartPosition", "kbson"})
    private final class BsonBinaryWriterContext
    extends AbstractBsonWriter.Context {
        @Nullable
        private final BsonBinaryWriterContext parentContext;
        private final int startPosition;
        private int index;

        public BsonBinaryWriterContext(@NotNull BsonBinaryWriterContext parentContext, @Nullable BsonContextType contextType, String currentName, int startPosition, int index) {
            Intrinsics.checkNotNullParameter((Object)BsonBinaryWriter.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)contextType), (String)"contextType");
            super(contextType, currentName);
            this.parentContext = parentContext;
            this.startPosition = startPosition;
            this.index = index;
        }

        public /* synthetic */ BsonBinaryWriterContext(BsonBinaryWriterContext bsonBinaryWriterContext, BsonContextType bsonContextType, String string, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x10) != 0) {
                n2 = 0;
            }
            this(bsonBinaryWriterContext, bsonContextType, string, n, n2);
        }

        @Nullable
        public final BsonBinaryWriterContext getParentContext() {
            return this.parentContext;
        }

        public final int getStartPosition() {
            return this.startPosition;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/mongodb/kbson/internal/io/BsonBinaryWriter$Companion;", "", "()V", "invoke", "Lorg/mongodb/kbson/internal/io/BsonBinaryWriter;", "kbson"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BsonBinaryWriter invoke() {
            return new BsonBinaryWriter(new ByteArrayBsonOutput(0, 1, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

