/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson.serialization;

import java.util.Iterator;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.mongodb.kbson.BsonArray;
import org.mongodb.kbson.BsonBoolean;
import org.mongodb.kbson.BsonDocument;
import org.mongodb.kbson.BsonDouble;
import org.mongodb.kbson.BsonInt32;
import org.mongodb.kbson.BsonInt64;
import org.mongodb.kbson.BsonNull;
import org.mongodb.kbson.BsonSerializationException;
import org.mongodb.kbson.BsonString;
import org.mongodb.kbson.BsonType;
import org.mongodb.kbson.BsonValue;
import org.mongodb.kbson.serialization.BsonArraySerializer;
import org.mongodb.kbson.serialization.BsonBinarySerializer;
import org.mongodb.kbson.serialization.BsonBooleanSerializer;
import org.mongodb.kbson.serialization.BsonDBPointerSerializer;
import org.mongodb.kbson.serialization.BsonDateTimeSerializer;
import org.mongodb.kbson.serialization.BsonDecimal128Serializer;
import org.mongodb.kbson.serialization.BsonDecoder;
import org.mongodb.kbson.serialization.BsonDocumentSerializer;
import org.mongodb.kbson.serialization.BsonDoubleSerializer;
import org.mongodb.kbson.serialization.BsonEncoder;
import org.mongodb.kbson.serialization.BsonInt32Serializer;
import org.mongodb.kbson.serialization.BsonInt64Serializer;
import org.mongodb.kbson.serialization.BsonJavaScriptSerializer;
import org.mongodb.kbson.serialization.BsonJavaScriptWithScopeSerializer;
import org.mongodb.kbson.serialization.BsonMaxKeySerializer;
import org.mongodb.kbson.serialization.BsonMinKeySerializer;
import org.mongodb.kbson.serialization.BsonNullSerializer;
import org.mongodb.kbson.serialization.BsonObjectIdSerializer;
import org.mongodb.kbson.serialization.BsonRegularExpressionSerializer;
import org.mongodb.kbson.serialization.BsonSerializer;
import org.mongodb.kbson.serialization.BsonStringSerializer;
import org.mongodb.kbson.serialization.BsonSymbolSerializer;
import org.mongodb.kbson.serialization.BsonTimestampSerializer;
import org.mongodb.kbson.serialization.BsonUndefinedSerializer;
import org.mongodb.kbson.serialization.BsonValueSerializer$BsonValueJson$;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/mongodb/kbson/serialization/BsonValueSerializer;", "Lkotlinx/serialization/KSerializer;", "Lorg/mongodb/kbson/BsonValue;", "Lorg/mongodb/kbson/serialization/BsonSerializer;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserializationStrategy", "Lkotlinx/serialization/DeserializationStrategy;", "element", "Lkotlinx/serialization/json/JsonObject;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "processElement", "jsonElement", "Lkotlinx/serialization/json/JsonElement;", "Lkotlinx/serialization/json/JsonDecoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "BsonValueJson", "kbson"})
public final class BsonValueSerializer
implements KSerializer<BsonValue>,
BsonSerializer {
    @NotNull
    public static final BsonValueSerializer INSTANCE = new BsonValueSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = BsonValueJson.Companion.serializer().getDescriptor();

    private BsonValueSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    public void serialize(@NotNull Encoder encoder2, @NotNull BsonValue value) {
        block24: {
            block23: {
                Intrinsics.checkNotNullParameter((Object)encoder2, (String)"encoder");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Encoder encoder3 = encoder2;
                if (!(encoder3 instanceof BsonEncoder ? true : encoder3 instanceof JsonEncoder)) break block23;
                switch (WhenMappings.$EnumSwitchMapping$0[value.getBsonType().ordinal()]) {
                    case 1: {
                        BsonArraySerializer.INSTANCE.serialize(encoder2, value.asArray());
                        break block24;
                    }
                    case 2: {
                        BsonDocumentSerializer.INSTANCE.serialize(encoder2, value.asDocument());
                        break block24;
                    }
                    case 3: {
                        BsonBinarySerializer.INSTANCE.serialize(encoder2, value.asBinary());
                        break block24;
                    }
                    case 4: {
                        BsonBooleanSerializer.INSTANCE.serialize(encoder2, value.asBoolean());
                        break block24;
                    }
                    case 5: {
                        BsonDateTimeSerializer.INSTANCE.serialize(encoder2, value.asDateTime());
                        break block24;
                    }
                    case 6: {
                        BsonDBPointerSerializer.INSTANCE.serialize(encoder2, value.asDBPointer());
                        break block24;
                    }
                    case 7: {
                        BsonDecimal128Serializer.INSTANCE.serialize(encoder2, value.asDecimal128());
                        break block24;
                    }
                    case 8: {
                        BsonDoubleSerializer.INSTANCE.serialize(encoder2, value.asDouble());
                        break block24;
                    }
                    case 9: {
                        BsonInt32Serializer.INSTANCE.serialize(encoder2, value.asInt32());
                        break block24;
                    }
                    case 10: {
                        BsonInt64Serializer.INSTANCE.serialize(encoder2, value.asInt64());
                        break block24;
                    }
                    case 11: {
                        BsonJavaScriptSerializer.INSTANCE.serialize(encoder2, value.asJavaScript());
                        break block24;
                    }
                    case 12: {
                        BsonJavaScriptWithScopeSerializer.INSTANCE.serialize(encoder2, value.asJavaScriptWithScope());
                        break block24;
                    }
                    case 13: {
                        BsonMaxKeySerializer.INSTANCE.serialize(encoder2, value.asBsonMaxKey());
                        break block24;
                    }
                    case 14: {
                        BsonMinKeySerializer.INSTANCE.serialize(encoder2, value.asBsonMinKey());
                        break block24;
                    }
                    case 15: {
                        BsonNullSerializer.INSTANCE.serialize(encoder2, value.asBsonNull());
                        break block24;
                    }
                    case 16: {
                        BsonObjectIdSerializer.INSTANCE.serialize(encoder2, value.asObjectId());
                        break block24;
                    }
                    case 17: {
                        BsonRegularExpressionSerializer.INSTANCE.serialize(encoder2, value.asRegularExpression());
                        break block24;
                    }
                    case 18: {
                        BsonStringSerializer.INSTANCE.serialize(encoder2, value.asString());
                        break block24;
                    }
                    case 19: {
                        BsonSymbolSerializer.INSTANCE.serialize(encoder2, value.asSymbol());
                        break block24;
                    }
                    case 20: {
                        BsonTimestampSerializer.INSTANCE.serialize(encoder2, value.asTimestamp());
                        break block24;
                    }
                    case 21: {
                        BsonUndefinedSerializer.INSTANCE.serialize(encoder2, value.asBsonUndefined());
                        break block24;
                    }
                    default: {
                        throw new SerializationException(Intrinsics.stringPlus((String)"Unsupported bson type: ", (Object)((Object)value.getBsonType())));
                    }
                }
            }
            throw new SerializationException(Intrinsics.stringPlus((String)"Unknown encoder type: ", (Object)encoder2));
        }
    }

    @NotNull
    public BsonValue deserialize(@NotNull Decoder decoder) {
        BsonValue bsonValue;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Decoder decoder2 = decoder;
        if (decoder2 instanceof BsonDecoder) {
            bsonValue = ((BsonDecoder)decoder).currentValue();
        } else if (decoder2 instanceof JsonDecoder) {
            bsonValue = this.processElement(((JsonDecoder)decoder).decodeJsonElement(), (JsonDecoder)decoder);
        } else {
            throw new SerializationException(Intrinsics.stringPlus((String)"Unknown decoder type: ", (Object)decoder));
        }
        return bsonValue;
    }

    private final BsonValue processElement(JsonElement jsonElement, JsonDecoder decoder) {
        JsonElement jsonElement2 = jsonElement;
        if (jsonElement2 instanceof JsonObject) {
            DeserializationStrategy<? extends BsonValue> deserializationStrategy = this.deserializationStrategy((JsonObject)jsonElement);
            if (deserializationStrategy != null) {
                DeserializationStrategy<? extends BsonValue> it = deserializationStrategy;
                boolean bl = false;
                try {
                    return (BsonValue)decoder.getJson().decodeFromJsonElement(it, jsonElement);
                }
                catch (Exception e) {
                    throw new BsonSerializationException("Invalid Json: " + e.getMessage() + " : Source: " + jsonElement, e);
                }
            }
            BsonDocument document = new BsonDocument(null, 1, null);
            Map $this$forEach$iv = (Map)jsonElement;
            boolean $i$f$forEach = false;
            Iterator bl = $this$forEach$iv.entrySet().iterator();
            while (bl.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$k$v = element$iv = bl.next();
                boolean bl2 = false;
                String k = (String)$dstr$k$v.getKey();
                JsonElement v = (JsonElement)$dstr$k$v.getValue();
                BsonValueSerializer $this$processElement_u24lambda_u2d3_u24lambda_u2d2 = INSTANCE;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean value$iv = !StringsKt.contains$default((CharSequence)k, (char)((char)(bl4 ? 1 : 0)), (boolean)false, (int)2, null);
                boolean $i$f$validateSerialization = false;
                if (!value$iv) {
                    boolean bl5 = false;
                    String message$iv = "Invalid key: '" + k + "' contains null byte: " + jsonElement;
                    throw new BsonSerializationException(message$iv.toString(), null, 2, null);
                }
                Map map = document;
                BsonValue bsonValue = $this$processElement_u24lambda_u2d3_u24lambda_u2d2.processElement(v, decoder);
                map.put(k, bsonValue);
            }
            return document;
        }
        if (jsonElement2 instanceof JsonArray) {
            BsonArray bsonArray = new BsonArray(null, 1, null);
            Iterable $this$forEach$iv = (Iterable)jsonElement;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonElement v = (JsonElement)element$iv;
                boolean bl = false;
                bsonArray.add(INSTANCE.processElement(v, decoder));
            }
            return bsonArray;
        }
        if (jsonElement2 instanceof JsonPrimitive) {
            Boolean bl = JsonElementKt.getBooleanOrNull((JsonPrimitive)((JsonPrimitive)jsonElement));
            if (bl != null) {
                boolean it = bl;
                boolean bl6 = false;
                return new BsonBoolean(it);
            }
            Long l = JsonElementKt.getLongOrNull((JsonPrimitive)((JsonPrimitive)jsonElement));
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl7 = false;
                return new BsonInt64(it);
            }
            Integer n = JsonElementKt.getIntOrNull((JsonPrimitive)((JsonPrimitive)jsonElement));
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl8 = false;
                return new BsonInt32(it);
            }
            Float f = JsonElementKt.getFloatOrNull((JsonPrimitive)((JsonPrimitive)jsonElement));
            if (f != null) {
                float it = ((Number)f).floatValue();
                boolean bl9 = false;
                return new BsonDouble(it);
            }
            Double d = JsonElementKt.getDoubleOrNull((JsonPrimitive)((JsonPrimitive)jsonElement));
            if (d != null) {
                double it = ((Number)d).doubleValue();
                boolean bl10 = false;
                return new BsonDouble(it);
            }
            String string = JsonElementKt.getContentOrNull((JsonPrimitive)((JsonPrimitive)jsonElement));
            if (string != null) {
                String it = string;
                boolean bl11 = false;
                return new BsonString(it);
            }
            return BsonNull.INSTANCE;
        }
        if (jsonElement2 instanceof JsonNull) {
            return BsonNull.INSTANCE;
        }
        throw new SerializationException(Intrinsics.stringPlus((String)"Unknown jsonElement type: ", (Object)jsonElement));
    }

    private final DeserializationStrategy<? extends BsonValue> deserializationStrategy(JsonObject element) {
        DeserializationStrategy deserializationStrategy;
        if (element.keySet().isEmpty()) {
            return null;
        }
        switch ((String)CollectionsKt.first((Iterable)element.keySet())) {
            case "$binary": {
                deserializationStrategy = (DeserializationStrategy)BsonBinarySerializer.INSTANCE;
                break;
            }
            case "$code": {
                deserializationStrategy = (DeserializationStrategy)(((Map)element).containsKey("$scope") ? BsonJavaScriptWithScopeSerializer.INSTANCE : BsonJavaScriptSerializer.INSTANCE);
                break;
            }
            case "$date": {
                deserializationStrategy = (DeserializationStrategy)BsonDateTimeSerializer.INSTANCE;
                break;
            }
            case "$dbPointer": {
                deserializationStrategy = (DeserializationStrategy)BsonDBPointerSerializer.INSTANCE;
                break;
            }
            case "$maxKey": {
                deserializationStrategy = (DeserializationStrategy)BsonMaxKeySerializer.INSTANCE;
                break;
            }
            case "$minKey": {
                deserializationStrategy = (DeserializationStrategy)BsonMinKeySerializer.INSTANCE;
                break;
            }
            case "$numberDecimal": {
                deserializationStrategy = (DeserializationStrategy)BsonDecimal128Serializer.INSTANCE;
                break;
            }
            case "$numberDouble": {
                deserializationStrategy = (DeserializationStrategy)BsonDoubleSerializer.INSTANCE;
                break;
            }
            case "$numberInt": {
                deserializationStrategy = (DeserializationStrategy)BsonInt32Serializer.INSTANCE;
                break;
            }
            case "$numberLong": {
                deserializationStrategy = (DeserializationStrategy)BsonInt64Serializer.INSTANCE;
                break;
            }
            case "$oid": {
                deserializationStrategy = (DeserializationStrategy)BsonObjectIdSerializer.INSTANCE;
                break;
            }
            case "$regularExpression": {
                deserializationStrategy = (DeserializationStrategy)BsonRegularExpressionSerializer.INSTANCE;
                break;
            }
            case "$symbol": {
                deserializationStrategy = (DeserializationStrategy)BsonSymbolSerializer.INSTANCE;
                break;
            }
            case "$timestamp": {
                deserializationStrategy = (DeserializationStrategy)BsonTimestampSerializer.INSTANCE;
                break;
            }
            case "$undefined": {
                deserializationStrategy = (DeserializationStrategy)BsonUndefinedSerializer.INSTANCE;
                break;
            }
            default: {
                deserializationStrategy = null;
            }
        }
        return deserializationStrategy;
    }

    @Serializable
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007J!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u00c7\u0001\u00a8\u0006\u0011"}, d2={"Lorg/mongodb/kbson/serialization/BsonValueSerializer$BsonValueJson;", "", "seen1", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()V", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "kbson"})
    private static final class BsonValueJson {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public BsonValueJson() {
        }

        @JvmStatic
        public static final void write$Self(@NotNull BsonValueJson self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ BsonValueJson(int seen1, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen1) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)BsonValueJson$$serializer.INSTANCE.getDescriptor());
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lorg/mongodb/kbson/serialization/BsonValueSerializer$BsonValueJson$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/mongodb/kbson/serialization/BsonValueSerializer$BsonValueJson;", "kbson"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<BsonValueJson> serializer() {
                return (KSerializer)BsonValueJson$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BsonType.values().length];
            nArray[BsonType.ARRAY.ordinal()] = 1;
            nArray[BsonType.DOCUMENT.ordinal()] = 2;
            nArray[BsonType.BINARY.ordinal()] = 3;
            nArray[BsonType.BOOLEAN.ordinal()] = 4;
            nArray[BsonType.DATE_TIME.ordinal()] = 5;
            nArray[BsonType.DB_POINTER.ordinal()] = 6;
            nArray[BsonType.DECIMAL128.ordinal()] = 7;
            nArray[BsonType.DOUBLE.ordinal()] = 8;
            nArray[BsonType.INT32.ordinal()] = 9;
            nArray[BsonType.INT64.ordinal()] = 10;
            nArray[BsonType.JAVASCRIPT.ordinal()] = 11;
            nArray[BsonType.JAVASCRIPT_WITH_SCOPE.ordinal()] = 12;
            nArray[BsonType.MAX_KEY.ordinal()] = 13;
            nArray[BsonType.MIN_KEY.ordinal()] = 14;
            nArray[BsonType.NULL.ordinal()] = 15;
            nArray[BsonType.OBJECT_ID.ordinal()] = 16;
            nArray[BsonType.REGULAR_EXPRESSION.ordinal()] = 17;
            nArray[BsonType.STRING.ordinal()] = 18;
            nArray[BsonType.SYMBOL.ordinal()] = 19;
            nArray[BsonType.TIMESTAMP.ordinal()] = 20;
            nArray[BsonType.UNDEFINED.ordinal()] = 21;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

