/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson.serialization;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.mongodb.kbson.BsonDocument;
import org.mongodb.kbson.BsonInvalidOperationException;
import org.mongodb.kbson.BsonNull;
import org.mongodb.kbson.BsonValue;
import org.mongodb.kbson.serialization.BsonDecoder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J!\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/mongodb/kbson/serialization/ClassBsonDecoder;", "Lorg/mongodb/kbson/serialization/BsonDecoder;", "bsonDocument", "Lorg/mongodb/kbson/BsonDocument;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "ignoreUnknownKeys", "", "(Lorg/mongodb/kbson/BsonDocument;Lkotlinx/serialization/modules/SerializersModule;Z)V", "decodedElementCount", "", "entryKey", "", "isOptional", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "currentValue", "Lorg/mongodb/kbson/BsonValue;", "decodeElementIndex", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "rethrowAsSerializationException", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kbson"})
public final class ClassBsonDecoder
extends BsonDecoder {
    @NotNull
    private final BsonDocument bsonDocument;
    @NotNull
    private final SerializersModule serializersModule;
    private int decodedElementCount;
    private String entryKey;
    private boolean isOptional;

    public ClassBsonDecoder(@NotNull BsonDocument bsonDocument, @NotNull SerializersModule serializersModule, boolean ignoreUnknownKeys) {
        Intrinsics.checkNotNullParameter((Object)bsonDocument, (String)"bsonDocument");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        super(bsonDocument, serializersModule, ignoreUnknownKeys);
        this.bsonDocument = bsonDocument;
        this.serializersModule = serializersModule;
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        int n;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.decodedElementCount < descriptor.getElementsCount()) {
            int n2 = this.decodedElementCount;
            this.decodedElementCount = n2 + 1;
            int it = n2;
            boolean bl = false;
            this.entryKey = descriptor.getElementName(it);
            this.isOptional = descriptor.isElementOptional(it);
            n = n2;
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    @NotNull
    public BsonValue currentValue() {
        BsonValue bsonValue;
        BsonValue bsonValue2;
        String string = this.entryKey;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"entryKey");
            string = null;
        }
        if ((bsonValue2 = (BsonValue)this.bsonDocument.get((Object)string)) == null) {
            if (!this.isOptional) {
                StringBuilder stringBuilder = new StringBuilder().append("Could not decode field '");
                String string2 = this.entryKey;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"entryKey");
                    string2 = null;
                }
                throw new SerializationException(stringBuilder.append(string2).append("': Undefined value on a non-optional field").toString());
            }
            bsonValue = BsonNull.INSTANCE;
        } else {
            bsonValue = bsonValue2;
        }
        return bsonValue;
    }

    @Override
    public <T> T rethrowAsSerializationException(@NotNull Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            object = block.invoke();
        }
        catch (BsonInvalidOperationException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Could not decode field '");
            String string = this.entryKey;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"entryKey");
                string = null;
            }
            throw new SerializationException(stringBuilder.append(string).append("': ").append((Object)e.getMessage()).toString(), (Throwable)e);
        }
        return (T)object;
    }
}

