/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Function;
import com.mongodb.ListCollectionsIterableImpl;
import com.mongodb.MongoClient;
import com.mongodb.MongoCollectionImpl;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ListCollectionsIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.client.model.IndexOptionDefaults;
import com.mongodb.client.model.ValidationOptions;
import com.mongodb.operation.CommandReadOperation;
import com.mongodb.operation.CreateCollectionOperation;
import com.mongodb.operation.CreateViewOperation;
import com.mongodb.operation.DropDatabaseOperation;
import com.mongodb.operation.OperationExecutor;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class MongoDatabaseImpl
implements MongoDatabase {
    private final String name;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final ReadConcern readConcern;
    private final OperationExecutor executor;

    MongoDatabaseImpl(String name, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, ReadConcern readConcern, OperationExecutor executor) {
        this.name = Assertions.notNull("name", name);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.executor = Assertions.notNull("executor", executor);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public MongoDatabase withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoDatabaseImpl(this.name, codecRegistry, this.readPreference, this.writeConcern, this.readConcern, this.executor);
    }

    @Override
    public MongoDatabase withReadPreference(ReadPreference readPreference) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, readPreference, this.writeConcern, this.readConcern, this.executor);
    }

    @Override
    public MongoDatabase withWriteConcern(WriteConcern writeConcern) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, this.readPreference, writeConcern, this.readConcern, this.executor);
    }

    @Override
    public MongoDatabase withReadConcern(ReadConcern readConcern) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, this.readPreference, this.writeConcern, readConcern, this.executor);
    }

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        return this.getCollection(collectionName, Document.class);
    }

    @Override
    public <TDocument> MongoCollection<TDocument> getCollection(String collectionName, Class<TDocument> documentClass) {
        return new MongoCollectionImpl<TDocument>(new MongoNamespace(this.name, collectionName), documentClass, this.codecRegistry, this.readPreference, this.writeConcern, this.readConcern, this.executor);
    }

    @Override
    public Document runCommand(Bson command) {
        return this.runCommand(command, Document.class);
    }

    @Override
    public Document runCommand(Bson command, ReadPreference readPreference) {
        return this.runCommand(command, readPreference, Document.class);
    }

    @Override
    public <TResult> TResult runCommand(Bson command, Class<TResult> resultClass) {
        return this.runCommand(command, ReadPreference.primary(), resultClass);
    }

    @Override
    public <TResult> TResult runCommand(Bson command, ReadPreference readPreference, Class<TResult> resultClass) {
        Assertions.notNull("readPreference", readPreference);
        return this.executor.execute(new CommandReadOperation<TResult>(this.getName(), this.toBsonDocument(command), this.codecRegistry.get(resultClass)), readPreference);
    }

    @Override
    public void drop() {
        this.executor.execute(new DropDatabaseOperation(this.name, this.getWriteConcern()));
    }

    @Override
    public MongoIterable<String> listCollectionNames() {
        return new ListCollectionsIterableImpl<BsonDocument>(this.name, BsonDocument.class, MongoClient.getDefaultCodecRegistry(), ReadPreference.primary(), this.executor).map(new Function<BsonDocument, String>(){

            @Override
            public String apply(BsonDocument result) {
                return result.getString("name").getValue();
            }
        });
    }

    @Override
    public ListCollectionsIterable<Document> listCollections() {
        return this.listCollections(Document.class);
    }

    @Override
    public <TResult> ListCollectionsIterable<TResult> listCollections(Class<TResult> resultClass) {
        return new ListCollectionsIterableImpl<TResult>(this.name, resultClass, this.codecRegistry, ReadPreference.primary(), this.executor);
    }

    @Override
    public void createCollection(String collectionName) {
        this.createCollection(collectionName, new CreateCollectionOptions());
    }

    @Override
    public void createCollection(String collectionName, CreateCollectionOptions createCollectionOptions) {
        ValidationOptions validationOptions;
        CreateCollectionOperation operation = new CreateCollectionOperation(this.name, collectionName, this.writeConcern).collation(createCollectionOptions.getCollation()).capped(createCollectionOptions.isCapped()).sizeInBytes(createCollectionOptions.getSizeInBytes()).autoIndex(createCollectionOptions.isAutoIndex()).maxDocuments(createCollectionOptions.getMaxDocuments()).usePowerOf2Sizes(createCollectionOptions.isUsePowerOf2Sizes()).storageEngineOptions(this.toBsonDocument(createCollectionOptions.getStorageEngineOptions()));
        IndexOptionDefaults indexOptionDefaults = createCollectionOptions.getIndexOptionDefaults();
        if (indexOptionDefaults.getStorageEngine() != null) {
            operation.indexOptionDefaults(new BsonDocument("storageEngine", this.toBsonDocument(indexOptionDefaults.getStorageEngine())));
        }
        if ((validationOptions = createCollectionOptions.getValidationOptions()).getValidator() != null) {
            operation.validator(this.toBsonDocument(validationOptions.getValidator()));
        }
        if (validationOptions.getValidationLevel() != null) {
            operation.validationLevel(validationOptions.getValidationLevel());
        }
        if (validationOptions.getValidationAction() != null) {
            operation.validationAction(validationOptions.getValidationAction());
        }
        this.executor.execute(operation);
    }

    @Override
    public void createView(String viewName, String viewOn, List<? extends Bson> pipeline) {
        this.createView(viewName, viewOn, pipeline, new CreateViewOptions());
    }

    @Override
    public void createView(String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions) {
        Assertions.notNull("createViewOptions", createViewOptions);
        this.executor.execute(new CreateViewOperation(this.name, viewName, viewOn, this.createBsonDocumentList(pipeline), this.writeConcern).collation(createViewOptions.getCollation()));
    }

    private List<BsonDocument> createBsonDocumentList(List<? extends Bson> pipeline) {
        Assertions.notNull("pipeline", pipeline);
        ArrayList<BsonDocument> bsonDocumentPipeline = new ArrayList<BsonDocument>(pipeline.size());
        for (Bson bson : pipeline) {
            if (bson == null) {
                throw new IllegalArgumentException("pipeline can not contain a null value");
            }
            bsonDocumentPipeline.add(bson.toBsonDocument(BsonDocument.class, this.codecRegistry));
        }
        return bsonDocumentPipeline;
    }

    private BsonDocument toBsonDocument(Bson document) {
        return document == null ? null : document.toBsonDocument(BsonDocument.class, this.codecRegistry);
    }
}

