/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.manager;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.SPIServiceRegistry;
import org.mule.api.registry.ServiceRegistry;
import org.mule.common.MuleVersion;
import org.mule.config.i18n.MessageFactory;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Operation;
import org.mule.extension.introspection.Parameter;
import org.mule.extension.runtime.ConfigurationInstanceProvider;
import org.mule.extension.runtime.ConfigurationInstanceRegistrationCallback;
import org.mule.extension.runtime.OperationContext;
import org.mule.extension.runtime.OperationExecutor;
import org.mule.module.extension.internal.introspection.DefaultExtensionFactory;
import org.mule.module.extension.internal.introspection.ExtensionDiscoverer;
import org.mule.module.extension.internal.manager.DefaultExtensionDiscoverer;
import org.mule.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.module.extension.internal.manager.ExtensionRegister;
import org.mule.module.extension.internal.manager.ExtensionStateTracker;
import org.mule.module.extension.internal.runtime.ConfigurationObjectBuilder;
import org.mule.module.extension.internal.runtime.DelegatingOperationExecutor;
import org.mule.module.extension.internal.runtime.StaticConfigurationInstanceProvider;
import org.mule.module.extension.internal.runtime.resolver.EvaluateAndTransformValueResolver;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.module.extension.internal.util.MuleExtensionUtils;
import org.mule.util.ObjectNameHelper;
import org.mule.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultExtensionManager
implements ExtensionManagerAdapter,
MuleContextAware,
Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExtensionManager.class);
    private final ExtensionRegister register = new ExtensionRegister();
    private final ServiceRegistry serviceRegistry = new SPIServiceRegistry();
    private MuleContext muleContext;
    private ObjectNameHelper objectNameHelper;
    private ExtensionDiscoverer extensionDiscoverer = new DefaultExtensionDiscoverer(new DefaultExtensionFactory(this.serviceRegistry), this.serviceRegistry);

    public void initialise() throws InitialisationException {
        for (Map.Entry instanceProviderEntry : this.muleContext.getRegistry().lookupByType(ConfigurationInstanceProvider.class).entrySet()) {
            ConfigurationInstanceProvider instanceProvider = (ConfigurationInstanceProvider)instanceProviderEntry.getValue();
            this.registerConfigurationInstanceProvider((String)instanceProviderEntry.getKey(), instanceProvider);
        }
    }

    public List<Extension> discoverExtensions(ClassLoader classLoader) {
        LOGGER.info("Starting discovery of extensions");
        List<Extension> discovered = this.extensionDiscoverer.discover(classLoader);
        LOGGER.info("Discovered {} extensions", (Object)discovered.size());
        ImmutableList.Builder accepted = ImmutableList.builder();
        for (Extension extension : discovered) {
            if (!this.registerExtension(extension)) continue;
            accepted.add((Object)extension);
        }
        return accepted.build();
    }

    public boolean registerExtension(Extension extension) {
        LOGGER.info("Registering extension {} (version {})", (Object)extension.getName(), (Object)extension.getVersion());
        String extensionName = extension.getName();
        if (this.register.containsExtension(extensionName)) {
            return this.maybeUpdateExtension(extension, extensionName);
        }
        this.doRegisterExtension(extension, extensionName);
        return true;
    }

    public <C> void registerConfigurationInstanceProvider(String providerName, ConfigurationInstanceProvider<C> configurationInstanceProvider) {
        Configuration configuration = configurationInstanceProvider.getConfiguration();
        ExtensionStateTracker extensionStateTracker = this.register.getExtensionState(configuration);
        extensionStateTracker.registerConfigurationInstanceProvider(configuration, providerName, configurationInstanceProvider);
    }

    @Override
    public <C> C getConfigurationInstance(ConfigurationInstanceProvider<C> configurationInstanceProvider, OperationContext operationContext) {
        return (C)configurationInstanceProvider.get(operationContext, new ConfigurationInstanceRegistrationCallback(){

            public <C> void registerNewConfigurationInstance(ConfigurationInstanceProvider<C> configurationInstanceProvider, C configurationInstance) {
                DefaultExtensionManager.this.registerConfigurationInstance(configurationInstanceProvider.getConfiguration(), configurationInstanceProvider.getName(), configurationInstance);
            }
        });
    }

    public OperationExecutor getOperationExecutor(OperationContext operationContext) {
        Extension extension = this.register.getExtension(operationContext.getOperation());
        Map<String, ConfigurationInstanceProvider> providers = this.register.getConfigurationInstanceProviders(extension);
        int matches = providers.size();
        if (matches == 1) {
            ConfigurationInstanceProvider provider = providers.values().iterator().next();
            return this.getOperationExecutor((ConfigurationInstanceProvider<Object>)provider, operationContext);
        }
        if (matches > 1) {
            throw new IllegalStateException(String.format("No config-ref was specified for operation %s of extension %s, but %d are registered. Please specify which to use", operationContext.getOperation().getName(), extension.getName(), matches));
        }
        this.attemptToCreateImplicitConfigurationInstance(extension, operationContext);
        return this.getOperationExecutor(operationContext);
    }

    public OperationExecutor getOperationExecutor(String configurationInstanceProviderName, OperationContext operationContext) {
        ConfigurationInstanceProvider<Object> configurationInstanceProvider = this.getConfigurationInstanceProvider(configurationInstanceProviderName);
        return this.getOperationExecutor(configurationInstanceProvider, operationContext);
    }

    public Set<Extension> getExtensions() {
        return this.register.getExtensions();
    }

    public <C> Set<Extension> getExtensionsCapableOf(Class<C> capabilityType) {
        Preconditions.checkArgument((capabilityType != null ? 1 : 0) != 0, (String)"capability type cannot be null");
        return this.register.getExtensionsCapableOf(capabilityType);
    }

    private <C> void registerConfigurationInstance(Configuration configuration, String configurationInstanceName, C configurationInstance) {
        ExtensionStateTracker extensionStateTracker = this.register.getExtensionState(configuration);
        extensionStateTracker.registerConfigurationInstance(configuration, configurationInstanceName, configurationInstance);
        this.putInRegistryAndApplyLifecycle(configurationInstanceName, configurationInstance);
    }

    private void putInRegistryAndApplyLifecycle(String key, Object object) {
        try {
            this.muleContext.getRegistry().registerObject(this.objectNameHelper.getUniqueName(key), object);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationExecutor getOperationExecutor(ConfigurationInstanceProvider<Object> configurationInstanceProvider, OperationContext operationContext) {
        OperationExecutor executor;
        Object configurationInstance;
        Object object = configurationInstance = this.getConfigurationInstance(configurationInstanceProvider, operationContext);
        synchronized (object) {
            ExtensionStateTracker extensionStateTracker = this.register.getExtensionState(configurationInstanceProvider.getConfiguration());
            executor = extensionStateTracker.getOperationExecutor(configurationInstanceProvider.getConfiguration(), configurationInstance, operationContext);
            if (executor == null) {
                executor = this.createOperationExecutor(configurationInstance, operationContext);
                extensionStateTracker.registerOperationExecutor(configurationInstanceProvider.getConfiguration(), operationContext.getOperation(), configurationInstance, executor);
            }
        }
        return executor;
    }

    private ConfigurationInstanceProvider<Object> getConfigurationInstanceProvider(String configurationInstanceProviderName) {
        ConfigurationInstanceProvider configurationInstanceProvider = this.register.getConfigurationInstanceProviders().get(configurationInstanceProviderName);
        if (configurationInstanceProvider == null) {
            throw new IllegalArgumentException("There's no registered ConfigurationInstanceProvider under name" + configurationInstanceProviderName);
        }
        return configurationInstanceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptToCreateImplicitConfigurationInstance(Extension extension, OperationContext operationContext) {
        Configuration implicitConfiguration = this.getImplicitConfiguration(extension);
        if (implicitConfiguration == null) {
            throw new IllegalStateException(String.format("Could not find a config for extension %s and none can be created automatically. Please define one", extension.getName()));
        }
        Configuration configuration = implicitConfiguration;
        synchronized (configuration) {
            Object configurationInstance;
            if (!this.register.getConfigurationInstanceProviders(extension).isEmpty()) {
                return;
            }
            ConfigurationObjectBuilder configurationObjectBuilder = new ConfigurationObjectBuilder(implicitConfiguration, this.buildImplicitConfigurationResolverSet(implicitConfiguration));
            try {
                configurationInstance = configurationObjectBuilder.build(MuleExtensionUtils.asOperationContextAdapter(operationContext).getEvent());
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            String instanceName = this.objectNameHelper.getUniqueName(String.format("%s-%s", extension.getName(), implicitConfiguration.getName()));
            this.registerConfigurationInstanceProvider(instanceName, new StaticConfigurationInstanceProvider<Object>(instanceName, implicitConfiguration, configurationInstance));
        }
    }

    private ResolverSet buildImplicitConfigurationResolverSet(Configuration configuration) {
        ResolverSet resolverSet = new ResolverSet();
        for (Parameter parameter : configuration.getParameters()) {
            Object defaultValue = parameter.getDefaultValue();
            if (defaultValue == null) continue;
            ValueResolver<Object> valueResolver = defaultValue instanceof String && this.muleContext.getExpressionManager().isExpression((String)defaultValue) ? new EvaluateAndTransformValueResolver((String)defaultValue, parameter.getType()) : new StaticValueResolver<Object>(defaultValue);
            resolverSet.add(parameter, valueResolver);
        }
        return resolverSet;
    }

    private Configuration getImplicitConfiguration(Extension extension) {
        for (Configuration configuration : extension.getConfigurations()) {
            if (!this.canBeUsedImplicitly(configuration)) continue;
            return configuration;
        }
        return null;
    }

    private boolean canBeUsedImplicitly(Configuration configuration) {
        for (Parameter parameter : configuration.getParameters()) {
            if (!parameter.isRequired() || parameter.getDefaultValue() != null) continue;
            return false;
        }
        return true;
    }

    private boolean maybeUpdateExtension(Extension extension, String extensionName) {
        MuleVersion newVersion;
        Extension actual = this.register.getExtension(extensionName);
        try {
            newVersion = new MuleVersion(extension.getVersion());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn(String.format("Found extensions %s with invalid version %s. Skipping registration", extension.getName(), extension.getVersion()), (Throwable)e);
            return false;
        }
        if (newVersion.newerThan(actual.getVersion())) {
            this.logExtensionHotUpdate(extension, actual);
            this.doRegisterExtension(extension, extensionName);
            return true;
        }
        LOGGER.info("Found extension {} but version {} was already registered. Keeping existing definition", (Object)extension.getName(), (Object)extension.getVersion());
        return false;
    }

    private void doRegisterExtension(Extension extension, String extensionName) {
        this.register.registerExtension(extensionName, extension);
    }

    private void logExtensionHotUpdate(Extension extension, Extension actual) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Found extension %s which was already registered with version %s. New version %s was found. Hot updating extension definition", extension.getName(), actual.getVersion(), extension.getVersion()));
        }
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.objectNameHelper = new ObjectNameHelper(muleContext);
    }

    private <C> OperationExecutor createOperationExecutor(C configurationInstance, OperationContext operationContext) {
        Operation operation = operationContext.getOperation();
        OperationExecutor executor = operation.getExecutor(configurationInstance);
        if (executor instanceof DelegatingOperationExecutor) {
            Extension extension = this.register.getExtension(operation);
            String executorName = this.objectNameHelper.getUniqueName(String.format("%s_executor_%s", extension.getName(), operation.getName()));
            try {
                this.muleContext.getRegistry().registerObject(executorName, ((DelegatingOperationExecutor)executor).getExecutorDelegate());
            }
            catch (RegistrationException e) {
                throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Could not create new executor for operation"), (Throwable)e);
            }
        }
        return executor;
    }

    protected void setExtensionsDiscoverer(ExtensionDiscoverer discoverer) {
        this.extensionDiscoverer = discoverer;
    }
}

