/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.DOMReader;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.api.construct.Pipeline;
import org.mule.common.MuleArtifact;
import org.mule.common.MuleArtifactFactoryException;
import org.mule.common.config.XmlConfigurationCallback;
import org.mule.common.config.XmlConfigurationMuleArtifactFactory;
import org.mule.config.ConfigResource;
import org.mule.config.spring.DefaultMuleArtifact;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;
import org.mule.util.xmlsecurity.XMLSecureFactories;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SpringXmlConfigurationMuleArtifactFactory
implements XmlConfigurationMuleArtifactFactory {
    public static final String BEANS_ELEMENT = "beans";
    public static final String REFS_SUFFIX = "-refs";
    public static final String REFS_TOKENS = " \t";
    public static final String REF_SUFFIX = "-ref";
    public static final String REF_ATTRIBUTE_NAME = "ref";
    public static final String NAME_ATTRIBUTE_NAME = "name";
    private Map<MuleArtifact, SpringXmlConfigurationBuilder> builders = new HashMap<MuleArtifact, SpringXmlConfigurationBuilder>();
    private Map<MuleArtifact, MuleContext> contexts = new HashMap<MuleArtifact, MuleContext>();

    public MuleArtifact getArtifact(Element element, XmlConfigurationCallback callback) throws MuleArtifactFactoryException {
        return this.doGetArtifact(element, callback, false);
    }

    public MuleArtifact getArtifactForMessageProcessor(Element element, XmlConfigurationCallback callback) throws MuleArtifactFactoryException {
        return this.doGetArtifact(element, callback, true);
    }

    protected String getArtifactMuleConfig(String flowName, Element element, XmlConfigurationCallback callback, boolean embedInFlow) throws MuleArtifactFactoryException {
        Element[] placeholders;
        HashMap<String, String> schemaLocations = new HashMap<String, String>();
        schemaLocations.put("http://www.mulesoft.org/schema/mule/core", "http://www.mulesoft.org/schema/mule/core/current/mule.xsd");
        Document document = DocumentHelper.createDocument();
        org.dom4j.Element rootElement = document.addElement("mule", "http://www.mulesoft.org/schema/mule/core");
        for (Element placeholder : placeholders = callback.getPropertyPlaceholders()) {
            try {
                org.dom4j.Element newPlaceholder = this.convert(placeholder);
                rootElement.add(newPlaceholder);
                this.addSchemaLocation(placeholder, callback, schemaLocations);
            }
            catch (ParserConfigurationException e) {
                throw new MuleArtifactFactoryException("Error parsing XML", (Throwable)e);
            }
        }
        org.dom4j.Element parentElement = rootElement;
        this.addSchemaLocation(element, callback, schemaLocations);
        if (embedInFlow) {
            parentElement = rootElement.addElement("flow", "http://www.mulesoft.org/schema/mule/core");
            parentElement.addAttribute(NAME_ATTRIBUTE_NAME, flowName);
        }
        try {
            parentElement.add(this.convert(element));
            this.processGlobalReferences(element, callback, rootElement, schemaLocations);
            if (embedInFlow) {
                parentElement.addElement("logger", "http://www.mulesoft.org/schema/mule/core");
            }
            this.setSchemaLocation(rootElement, schemaLocations);
            return document.asXML();
        }
        catch (Throwable t) {
            throw new MuleArtifactFactoryException("Error generating minimal XML configuration.", t);
        }
    }

    private void processGlobalReferences(Element element, XmlConfigurationCallback callback, org.dom4j.Element rootElement, Map<String, String> schemaLocations) throws ParserConfigurationException {
        this.processGlobalReferencesInAttributes(element, callback, rootElement, schemaLocations);
        this.processGlobalReferencesInChildElements(element, callback, rootElement, schemaLocations);
    }

    private void processGlobalReferencesInChildElements(Element element, XmlConfigurationCallback callback, org.dom4j.Element rootElement, Map<String, String> schemaLocations) throws ParserConfigurationException {
        if (element != null && element.getChildNodes() != null) {
            for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
                this.processGlobalReferencesInAttributes(element.getChildNodes().item(i), callback, rootElement, schemaLocations);
            }
        }
    }

    private void processGlobalReferencesInAttributes(Node element, XmlConfigurationCallback callback, org.dom4j.Element rootElement, Map<String, String> schemaLocations) throws ParserConfigurationException {
        if (element != null && element.getAttributes() != null) {
            for (int i = 0; i < element.getAttributes().getLength(); ++i) {
                String attributeName = element.getAttributes().item(i).getLocalName();
                if (attributeName != null && (attributeName.endsWith(REF_SUFFIX) || attributeName.equals(REF_ATTRIBUTE_NAME) || element.getNodeName().endsWith(REF_SUFFIX) && attributeName.equals(NAME_ATTRIBUTE_NAME))) {
                    Element dependentElement = callback.getGlobalElement(element.getAttributes().item(i).getNodeValue());
                    this.addReferencedGlobalElement(callback, rootElement, dependentElement, schemaLocations);
                    continue;
                }
                if (attributeName == null || !attributeName.endsWith(REFS_SUFFIX)) continue;
                StringTokenizer refs = new StringTokenizer(element.getAttributes().item(i).getNodeValue(), REFS_TOKENS);
                while (refs.hasMoreTokens()) {
                    String referenceName = refs.nextToken();
                    if (!StringUtils.isNotBlank((String)referenceName)) continue;
                    Element dependentElement = callback.getGlobalElement(referenceName);
                    this.addReferencedGlobalElement(callback, rootElement, dependentElement, schemaLocations);
                }
            }
        }
    }

    private void addReferencedGlobalElement(XmlConfigurationCallback callback, org.dom4j.Element rootElement, Element dependentElement, Map<String, String> schemaLocations) throws ParserConfigurationException {
        if (dependentElement != null) {
            if (this.isSpringBean(dependentElement)) {
                this.wrapElementInSpringBeanContainer(rootElement, dependentElement);
            } else {
                rootElement.add(this.convert(dependentElement));
                this.addSchemaLocation(dependentElement, callback, schemaLocations);
            }
            this.processGlobalReferences(dependentElement, callback, rootElement, schemaLocations);
        }
    }

    private void wrapElementInSpringBeanContainer(org.dom4j.Element rootElement, Element dependentElement) throws ParserConfigurationException {
        String namespaceUri = dependentElement.getNamespaceURI();
        Namespace namespace = new Namespace(dependentElement.getPrefix(), namespaceUri);
        org.dom4j.Element beans = rootElement.element(new QName(BEANS_ELEMENT, namespace));
        if (beans == null) {
            beans = rootElement.addElement(BEANS_ELEMENT, namespaceUri);
        }
        beans.add(this.convert(dependentElement));
    }

    private boolean isSpringBean(Element dependentElement) {
        return "http://www.springframework.org/schema/beans".equals(dependentElement.getNamespaceURI());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected MuleArtifact doGetArtifact(Element element, XmlConfigurationCallback callback, boolean embedInFlow) throws MuleArtifactFactoryException {
        String flowName = "flow-" + Integer.toString(element.hashCode());
        InputStream xmlConfig = IOUtils.toInputStream((String)this.getArtifactMuleConfig(flowName, element, callback, embedInFlow));
        MuleContext muleContext = null;
        SpringXmlConfigurationBuilder builder = null;
        Map environmentProperties = callback.getEnvironmentProperties();
        Properties systemProperties = System.getProperties();
        HashMap<Object, Object> originalSystemProperties = new HashMap<Object, Object>(systemProperties);
        try {
            ConfigResource config = new ConfigResource("embedded-datasense.xml", xmlConfig);
            ConfigResource defaultConfigOverride = new ConfigResource(this.getClass().getClassLoader().getResource("default-mule-config-override.xml").toURI().toURL());
            if (environmentProperties != null) {
                systemProperties.putAll((Map<?, ?>)environmentProperties);
            }
            DefaultMuleContextFactory factory = new DefaultMuleContextFactory();
            builder = new SpringXmlConfigurationBuilder(new ConfigResource[]{config, defaultConfigOverride});
            muleContext = factory.createMuleContext((ConfigurationBuilder)builder);
            muleContext.start();
            DefaultMuleArtifact artifact = null;
            if (embedInFlow) {
                Pipeline pipeline = (Pipeline)muleContext.getRegistry().lookupObject(flowName);
                if (pipeline.getMessageSource() == null) {
                    if (pipeline.getMessageProcessors() == null || pipeline.getMessageProcessors().size() <= 0) throw new IllegalArgumentException("artifact is null");
                    artifact = new DefaultMuleArtifact(pipeline.getMessageProcessors().get(0));
                } else {
                    artifact = new DefaultMuleArtifact(pipeline.getMessageSource());
                }
            } else {
                artifact = new DefaultMuleArtifact(muleContext.getRegistry().lookupObject(element.getAttribute(NAME_ATTRIBUTE_NAME)));
            }
            this.builders.put(artifact, builder);
            this.contexts.put(artifact, muleContext);
            DefaultMuleArtifact defaultMuleArtifact = artifact;
            return defaultMuleArtifact;
        }
        catch (ConfigurationException ce) {
            this.dispose(builder, muleContext);
            throw new MuleArtifactFactoryException("There seems to be a problem in your XML configuration. Please fix and retry.", (Throwable)ce);
        }
        catch (Throwable t) {
            this.dispose(builder, muleContext);
            throw new MuleArtifactFactoryException("Error starting minimal XML configuration.", t);
        }
        finally {
            systemProperties.clear();
            systemProperties.putAll((Map<?, ?>)originalSystemProperties);
            IOUtils.closeQuietly((InputStream)xmlConfig);
        }
    }

    protected void addSchemaLocation(Element element, XmlConfigurationCallback callback, Map<String, String> schemaLocations) {
        String key = element.getNamespaceURI();
        if (key != null && !schemaLocations.containsKey(key)) {
            schemaLocations.put(element.getNamespaceURI(), callback.getSchemaLocation(element.getNamespaceURI()));
        }
    }

    protected void setSchemaLocation(org.dom4j.Element rootElement, Map<String, String> schemaLocations) {
        StringBuilder schemaLocation = new StringBuilder();
        for (String key : schemaLocations.keySet()) {
            schemaLocation.append(key + " " + schemaLocations.get(key) + "\n");
        }
        rootElement.addAttribute(QName.get((String)"schemaLocation", (String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"), schemaLocation.toString().trim());
    }

    public org.dom4j.Element convert(Element element) throws ParserConfigurationException {
        DocumentBuilderFactory factory = XMLSecureFactories.createDefault().getDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        org.w3c.dom.Document doc1 = builder.newDocument();
        Element importedElement = (Element)doc1.importNode(element, Boolean.TRUE);
        doc1.appendChild(importedElement);
        DOMReader reader = new DOMReader();
        Document doc2 = reader.read(doc1);
        return doc2.getRootElement();
    }

    public void returnArtifact(MuleArtifact artifact) {
        SpringXmlConfigurationBuilder builder = this.builders.remove(artifact);
        MuleContext context = this.contexts.remove(artifact);
        this.dispose(builder, context);
    }

    protected void dispose(SpringXmlConfigurationBuilder builder, MuleContext context) {
        try {
            if (context != null) {
                context.dispose();
            }
        }
        finally {
            this.deleteLoggingThreads();
        }
    }

    private void deleteLoggingThreads() {
        String[] threadsToDelete = new String[]{"Mule.log.clogging.ref.handler", "Mule.log.slf4j.ref.handler"};
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        Thread[] threadArray = threadSet.toArray(new Thread[threadSet.size()]);
        for (String threadToDelete : threadsToDelete) {
            for (Thread t : threadArray) {
                if (!threadToDelete.equals(t.getName())) continue;
                try {
                    t.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
    }
}

