/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal;

import org.mule.api.MuleEvent;
import org.mule.extension.annotations.Operation;
import org.mule.extension.annotations.ParameterGroup;
import org.mule.extension.annotations.param.Optional;
import org.mule.extension.annotations.param.UseConfig;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.ValidationExtension;
import org.mule.extension.validation.internal.ValidationOptions;
import org.mule.extension.validation.internal.ValidationSupport;
import org.mule.extension.validation.internal.validator.BooleanValidator;
import org.mule.extension.validation.internal.validator.EmailValidator;
import org.mule.extension.validation.internal.validator.EmptyValidator;
import org.mule.extension.validation.internal.validator.IpValidator;
import org.mule.extension.validation.internal.validator.MatchesRegexValidator;
import org.mule.extension.validation.internal.validator.NotEmptyValidator;
import org.mule.extension.validation.internal.validator.NotNullValidator;
import org.mule.extension.validation.internal.validator.NullValidator;
import org.mule.extension.validation.internal.validator.SizeValidator;
import org.mule.extension.validation.internal.validator.TimeValidator;
import org.mule.extension.validation.internal.validator.UrlValidator;

public final class CommonValidationOperations
extends ValidationSupport {
    @Operation
    public void isTrue(boolean expression, @ParameterGroup ValidationOptions options, MuleEvent event, @UseConfig ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, event, config);
        this.validateWith(new BooleanValidator(expression, true, context), context, event);
    }

    @Operation
    public void isFalse(boolean expression, @ParameterGroup ValidationOptions options, MuleEvent event, @UseConfig ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, event, config);
        this.validateWith(new BooleanValidator(expression, false, context), context, event);
    }

    @Operation
    public void isEmail(String email, @ParameterGroup ValidationOptions options, MuleEvent event, @UseConfig ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, event, config);
        this.validateWith(new EmailValidator(email, context), context, event);
    }

    @Operation
    public void isIp(String ip, @ParameterGroup ValidationOptions options, MuleEvent event, @UseConfig ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, event, config);
        this.validateWith(new IpValidator(ip, context), context, event);
    }

    @Operation
    public void validateSize(Object value, @Optional(defaultValue="0") int min, @Optional Integer max, @ParameterGroup ValidationOptions options, MuleEvent event, @UseConfig ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, event, config);
        this.validateWith(new SizeValidator(value, min, max, context), context, event);
    }

    @Operation
    public void isNotEmpty(Object value, @ParameterGroup ValidationOptions options, MuleEvent event, @UseConfig ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, event, config);
        this.validateWith(new NotEmptyValidator(value, context), context, event);
    }

    @Operation
    public void isEmpty(Object value, @ParameterGroup ValidationOptions options, MuleEvent event, @UseConfig ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, event, config);
        this.validateWith(new EmptyValidator(value, context), context, event);
    }

    @Operation
    public void isNotNull(Object value, @ParameterGroup ValidationOptions options, MuleEvent event, @UseConfig ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, event, config);
        this.validateWith(new NotNullValidator(value, context), context, event);
    }

    @Operation
    public void isNull(Object value, @ParameterGroup ValidationOptions options, MuleEvent event, @UseConfig ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, event, config);
        this.validateWith(new NullValidator(value, context), context, event);
    }

    @Operation
    public void isTime(String time, @Optional String locale, @Optional String pattern, @ParameterGroup ValidationOptions options, MuleEvent event, @UseConfig ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, event, config);
        this.validateWith(new TimeValidator(time, this.nullSafeLocale(locale), pattern, context), context, event);
    }

    @Operation
    public void isUrl(String url, @ParameterGroup ValidationOptions options, MuleEvent event, @UseConfig ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, event, config);
        this.validateWith(new UrlValidator(url, context), context, event);
    }

    @Operation
    public void matchesRegex(String value, String regex, @Optional(defaultValue="true") boolean caseSensitive, @ParameterGroup ValidationOptions options, MuleEvent event, @UseConfig ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, event, config);
        this.validateWith(new MatchesRegexValidator(value, regex, caseSensitive, context), context, event);
    }

    private String nullSafeLocale(String locale) {
        return locale == null ? ValidationExtension.DEFAULT_LOCALE : locale;
    }
}

