/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.consumer;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.wsdl.WSDLException;
import org.mule.module.ws.consumer.WsdlRetrieverStrategy;
import org.mule.util.Base64;
import org.mule.util.IOUtils;

public class URLRetrieverStrategy
implements WsdlRetrieverStrategy {
    @Override
    public InputStream retrieveWsdlResource(String url) throws WSDLException {
        InputStream responseStream = null;
        URL location = IOUtils.getResourceAsUrl((String)url, this.getClass());
        if (location == null) {
            throw new WSDLException("No resource was found on: %s", url.toString());
        }
        try {
            URLConnection urlConnection = location.openConnection();
            if (location.getUserInfo() != null) {
                urlConnection.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])location.getUserInfo().getBytes()));
            }
            responseStream = urlConnection.getInputStream();
            return responseStream;
        }
        catch (Exception e) {
            throw new WSDLException("Exception retrieving WSDL for URL: %s", url.toString(), (Throwable)e);
        }
    }
}

