/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.security;

import java.util.Map;
import java.util.Properties;
import org.mule.module.ws.security.AbstractSecurityStrategy;
import org.mule.module.ws.security.WSCryptoUtils;
import org.mule.transport.ssl.api.TlsContextFactory;

public class WssVerifySignatureSecurityStrategy
extends AbstractSecurityStrategy {
    private static final String WS_VERIFY_SIGNATURE_PROPERTIES_KEY = "verifySignatureProperties";
    private TlsContextFactory tlsContextFactory;

    @Override
    public void apply(Map<String, Object> outConfigProperties, Map<String, Object> inConfigProperties) {
        this.appendAction(inConfigProperties, "Signature");
        Properties signatureProperties = this.tlsContextFactory == null ? WSCryptoUtils.createDefaultTrustStoreProperties() : WSCryptoUtils.createTrustStoreProperties(this.tlsContextFactory.getTrustStoreConfiguration());
        inConfigProperties.put("signaturePropRefId", WS_VERIFY_SIGNATURE_PROPERTIES_KEY);
        inConfigProperties.put(WS_VERIFY_SIGNATURE_PROPERTIES_KEY, signatureProperties);
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContextFactory;
    }

    public void setTlsContext(TlsContextFactory tlsContextFactory) {
        this.tlsContextFactory = tlsContextFactory;
    }
}

