/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.message;

import java.util.ServiceLoader;
import org.mule.runtime.api.message.MuleMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMuleMessageBuilderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMuleMessageBuilderFactory.class);
    private static final AbstractMuleMessageBuilderFactory DEFAULT_FACTORY;

    static final AbstractMuleMessageBuilderFactory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    protected abstract MuleMessage.PayloadBuilder create();

    protected abstract MuleMessage.Builder create(MuleMessage var1);

    static {
        try {
            AbstractMuleMessageBuilderFactory factory = ServiceLoader.load(AbstractMuleMessageBuilderFactory.class).iterator().next();
            LOGGER.info(String.format("Loaded MuleMessageBuilderFactory impementation '%s' form classloader '%s'", factory.getClass().getName(), factory.getClass().getClassLoader().toString()));
            DEFAULT_FACTORY = factory;
        }
        catch (Exception e) {
            LOGGER.error("Error loading MuleMessageBuilderFactory implementation.", (Throwable)e);
            throw e;
        }
    }
}

