/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata.descriptor.builder;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ImmutableComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;

public class ComponentMetadataDescriptorBuilder {
    private final String name;
    private List<MetadataResult<ParameterMetadataDescriptor>> parameters;
    private MetadataResult<OutputMetadataDescriptor> output;
    private MetadataResult<ParameterMetadataDescriptor> content;

    ComponentMetadataDescriptorBuilder(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name parameter cannot be blank for an ComponentMetadataDescriptor");
        }
        this.name = name;
    }

    public ComponentMetadataDescriptorBuilder withParametersDescriptor(List<MetadataResult<ParameterMetadataDescriptor>> parameters) {
        this.parameters = parameters;
        return this;
    }

    public ComponentMetadataDescriptorBuilder withOutputDescriptor(MetadataResult<OutputMetadataDescriptor> output) {
        this.output = output;
        return this;
    }

    public ComponentMetadataDescriptorBuilder withContentDescriptor(MetadataResult<ParameterMetadataDescriptor> content) {
        this.content = content;
        return this;
    }

    public ComponentMetadataDescriptor build() {
        if (this.output == null) {
            throw new IllegalArgumentException("OutputMetadataDescriptor cannot be null in an ComponentMetadataDescriptor");
        }
        if (this.parameters == null) {
            this.parameters = Collections.unmodifiableList(Collections.emptyList());
        }
        return new ImmutableComponentMetadataDescriptor(this.name, this.parameters, this.output, this.content);
    }
}

