/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata.descriptor.builder;

import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.descriptor.ImmutableOutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.builder.MetadataDescriptorBuilder;
import org.mule.runtime.api.metadata.resolving.MetadataResult;

public class OutputMetadataDescriptorBuilder {
    private MetadataResult<TypeMetadataDescriptor> returnTypeResult;
    private MetadataResult<TypeMetadataDescriptor> attributes;

    OutputMetadataDescriptorBuilder() {
    }

    public OutputMetadataDescriptorBuilder withReturnType(MetadataResult<TypeMetadataDescriptor> returnTypeResult) {
        this.returnTypeResult = returnTypeResult;
        return this;
    }

    public OutputMetadataDescriptorBuilder withAttributesType(MetadataResult<TypeMetadataDescriptor> attributesTypeResult) {
        this.attributes = attributesTypeResult;
        return this;
    }

    public OutputMetadataDescriptorBuilder withReturnType(MetadataType returnType) {
        this.returnTypeResult = MetadataResult.success(MetadataDescriptorBuilder.typeDescriptor().withType(returnType).build());
        return this;
    }

    public OutputMetadataDescriptorBuilder withAttributesType(MetadataType attributesType) {
        this.attributes = MetadataResult.success(MetadataDescriptorBuilder.typeDescriptor().withType(attributesType).build());
        return this;
    }

    public OutputMetadataDescriptor build() {
        if (this.returnTypeResult == null) {
            throw new IllegalArgumentException("Payload type parameter cannot be null for OutputMetadataDescriptor");
        }
        if (this.attributes == null) {
            throw new IllegalArgumentException("Attributes type parameter cannot be null for OutputMetadataDescriptor");
        }
        return new ImmutableOutputMetadataDescriptor(this.returnTypeResult, this.attributes);
    }
}

