/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata.resolving;

import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;

public final class ImmutableMetadataResult<T>
implements MetadataResult<T> {
    private final T result;
    private final boolean isSuccess;
    private final MetadataFailure failure;

    ImmutableMetadataResult(T result) {
        this.result = result;
        this.isSuccess = true;
        this.failure = null;
    }

    ImmutableMetadataResult(Exception e) {
        this(null, e);
    }

    ImmutableMetadataResult(T result, Exception e) {
        this(result, e.getMessage(), e);
    }

    ImmutableMetadataResult(T result, String message, Exception e) {
        this.result = result;
        this.isSuccess = false;
        this.failure = new MetadataFailure(message, ExceptionUtils.getStackTrace((Throwable)e), this.getFailureCode(e));
    }

    ImmutableMetadataResult(T result, MetadataFailure failure) {
        this.result = result;
        this.isSuccess = false;
        this.failure = failure;
    }

    @Override
    public T get() {
        return this.result;
    }

    @Override
    public boolean isSuccess() {
        return this.isSuccess;
    }

    @Override
    public Optional<MetadataFailure> getFailure() {
        return Optional.ofNullable(this.failure);
    }

    private FailureCode getFailureCode(Exception e) {
        return e instanceof MetadataResolvingException ? ((MetadataResolvingException)e).getFailure() : FailureCode.UNKNOWN;
    }
}

