/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.apidoc;

import com.google.gson.GsonBuilder;
import org.mule.devkit.model.apidoc.config.Config;
import org.mule.devkit.model.apidoc.desarializer.ConfigSerializer;
import org.mule.devkit.model.apidoc.metadata.Metadata;
import org.mule.devkit.model.apidoc.operation.FilterOperation;
import org.mule.devkit.model.apidoc.operation.ProcessorOperation;
import org.mule.devkit.model.apidoc.operation.SourceOperation;
import org.mule.devkit.model.apidoc.operation.TransformerOperation;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents a Mule Module component
 * One of @Connector or @Module.
 *
 * Contains Operations and configs
 */
public class ModuleModel extends AbstractElement implements Metadata {

    protected String minMuleVersion;
    protected Boolean requiresEntitlement = false;
    protected Boolean requiresEnterpriseLicense = false;
    protected List<Config> configs = new ArrayList<>();
    protected List<Variable> attributes = new ArrayList<>();
    protected List<ProcessorOperation> processors = new ArrayList<>();
    protected List<FilterOperation> filters = new ArrayList<>();
    protected List<TransformerOperation> transformers = new ArrayList<>();
    protected List<SourceOperation> sources = new ArrayList<>();

    public ModuleModel() {}

    public String minMuleVersion() {
        return setEmptyForNull(minMuleVersion);
    }

    public List<Variable> attributes() {
        return new ArrayList<>(attributes);
    }

    public List<Config> configs() {
        return new ArrayList<>(configs);
    }

    public List<ProcessorOperation> processors() {
        return new ArrayList<>(processors);
    }

    public List<SourceOperation> sources() {
        return new ArrayList<>(sources);
    }

    public List<FilterOperation> filters() {
        return new ArrayList<>(filters);
    }

    public List<TransformerOperation> transformers() {
        return new ArrayList<>(transformers);
    }

    public void attributes(List<Variable> attributes) {
        this.attributes = attributes;
    }

    public void configs(List<Config> configs) {
        this.configs = configs;
    }

    public void minMuleVersion(String minMuleVersion) {
        this.minMuleVersion = minMuleVersion;
    }

    public void filters(List<FilterOperation> filters) {
        this.filters = filters;
    }

    public void processors(List<ProcessorOperation> processors) {
        this.processors = processors;
    }

    public void sources(List<SourceOperation> sources) {
        this.sources = sources;
    }

    public void transformers(List<TransformerOperation> transformers) {
        this.transformers = transformers;
    }

    public Boolean requiresEntitlement() {
        return requiresEntitlement;
    }

    public void requiresEntitlement(Boolean requiresEntitlement) {
        this.requiresEntitlement = requiresEntitlement;
    }

    public Boolean requiresEnterpriseLicense() {
        return requiresEnterpriseLicense;
    }

    public void requiresEnterpriseLicense(Boolean requiresEnterpriseLicense) {
        this.requiresEnterpriseLicense = requiresEnterpriseLicense;
    }

    public String toJson() {
        return new GsonBuilder()
                .registerTypeAdapter(Config.class, new ConfigSerializer())
                .setPrettyPrinting()
                .create().toJson(this);
    }

    @Override
    public boolean hasMetaData() {
        return false;
    }
}
