/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.apidoc.builder;

import com.google.gson.GsonBuilder;
import org.mule.devkit.model.apidoc.ModuleModel;
import org.mule.devkit.model.apidoc.Variable;
import org.mule.devkit.model.apidoc.config.Config;
import org.mule.devkit.model.apidoc.desarializer.ConfigSerializer;
import org.mule.devkit.model.apidoc.misc.TypeLinkCreator;
import org.mule.devkit.model.apidoc.operation.FilterOperation;
import org.mule.devkit.model.apidoc.operation.ProcessorOperation;
import org.mule.devkit.model.apidoc.operation.SourceOperation;
import org.mule.devkit.model.apidoc.operation.TransformerOperation;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;

public class ModuleBuilder {

    ModuleModel module;

    private ModuleBuilder(){
        module = new ModuleModel();
    }

    public ModuleBuilder description(String description) {
        build().description(description);
        return this;
    }

    public ModuleBuilder friendlyName(String friendlyName) {
        build().friendlyName(friendlyName);
        return this;
    }

    public ModuleBuilder javaName(String name) {
        build().javaName(name);
        return this;
    }

    public ModuleBuilder attributes(List<Variable> attributes) {
        module.attributes(attributes);
        return this;
    }

    public ModuleBuilder configs(List<Config> configs) {
        module.configs(configs);
        return this;
    }

    public ModuleBuilder minMuleVersion(String minMuleVersion) {
        module.minMuleVersion(minMuleVersion);
        return this;
    }

    public ModuleBuilder addProcessors(List<ProcessorOperation> operations) {
        module.processors(operations);
        return this;
    }

    public ModuleBuilder addTransformers(List<TransformerOperation> operations) {
        module.transformers(operations);
        return this;
    }

    public ModuleBuilder addFilters(List<FilterOperation> operations) {
        module.filters(operations);
        return this;
    }

    public ModuleBuilder addSources(List<SourceOperation> operations) {
        module.sources(operations);
        return this;
    }

    public ModuleBuilder xsdName(String xsdName) {
        module.xsdName(xsdName);
        return this;
    }

    public ModuleBuilder requiresEntitlement(Boolean value) {
        module.requiresEntitlement(value);
        return this;
    }

    public ModuleBuilder requiresEnterpriseLicense(Boolean value) {
        module.requiresEnterpriseLicense(value);
        return this;
    }

    public ModuleBuilder addJavadocUrls(String javadocUrlTag){
        TypeLinkCreator.getInstance().putEntriesFromJavadocTag(javadocUrlTag);
        return this;
    }

    public ModuleBuilder addJavadocUrl(String _package, String url){
        TypeLinkCreator.getInstance().putPackageUrl(_package, url);
        return this;
    }

    public static ModuleModel fromJson(String filePath) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(filePath));
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Config.class, new ConfigSerializer());
        return gsonBuilder.create().fromJson(new String(encoded), ModuleModel.class);
    }

    public static ModuleModel fromJson(File file) throws IOException {
        return fromJson(file.getAbsolutePath());
    }

    public static ModuleBuilder getInstance(){
        return new ModuleBuilder();
    }

    public ModuleModel build() {
        return module;
    }

}