/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.apidoc.config;

import org.mule.devkit.model.apidoc.AbstractElement;
import org.mule.devkit.model.apidoc.Variable;

import java.util.ArrayList;
import java.util.List;

public abstract class Config extends AbstractElement {

    private String configElementName;
    private List<Variable> attributes = new ArrayList<>();

    public List<Variable> attributes() {
        return new ArrayList<>(attributes);
    }

    public void attributes(List<Variable> attributes) {
        this.attributes.addAll(attributes);
    }

    public void configElementName(String configElementName) {
        this.configElementName = configElementName;
    }

    @Override
    public String xsdName() {
        return setEmptyForNull(configElementName);
    }

    public Boolean isConnectionManagement() {
        return false;
    }

    public Boolean isOAuth2() {
        return false;
    }

    public Boolean isConfiguration() {
        return false;
    }

    public boolean isWSDLProviderConfig(){ return false; }

}
