/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.AuthorizationExpiredException;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.async.ResultCursorsHolder;
import org.neo4j.driver.internal.cursor.AsyncResultCursor;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;

public class UnmanagedTransaction {
    private final Connection connection;
    private final BoltProtocol protocol;
    private final BookmarkHolder bookmarkHolder;
    private final ResultCursorsHolder resultCursors;
    private final long fetchSize;
    private volatile StateHolder state = StateHolder.of(State.ACTIVE);

    public UnmanagedTransaction(Connection connection, BookmarkHolder bookmarkHolder, long fetchSize) {
        this(connection, bookmarkHolder, fetchSize, new ResultCursorsHolder());
    }

    protected UnmanagedTransaction(Connection connection, BookmarkHolder bookmarkHolder, long fetchSize, ResultCursorsHolder resultCursors) {
        this.connection = connection;
        this.protocol = connection.protocol();
        this.bookmarkHolder = bookmarkHolder;
        this.resultCursors = resultCursors;
        this.fetchSize = fetchSize;
    }

    public CompletionStage<UnmanagedTransaction> beginAsync(Bookmark initialBookmark, TransactionConfig config) {
        return this.protocol.beginTransaction(this.connection, initialBookmark, config).handle((ignore, beginError) -> {
            if (beginError != null) {
                if (beginError instanceof AuthorizationExpiredException) {
                    this.connection.terminateAndRelease("Authorization information kept on the server has expired, this connection is no longer valid.");
                } else {
                    this.connection.release();
                }
                throw Futures.asCompletionException(beginError);
            }
            return this;
        });
    }

    public CompletionStage<Void> closeAsync() {
        if (this.isOpen()) {
            return this.rollbackAsync();
        }
        return Futures.completedWithNull();
    }

    public CompletionStage<Void> commitAsync() {
        if (this.state.value == State.COMMITTED) {
            return Futures.failedFuture(new ClientException("Can't commit, transaction has been committed"));
        }
        if (this.state.value == State.ROLLED_BACK) {
            return Futures.failedFuture(new ClientException("Can't commit, transaction has been rolled back"));
        }
        return this.resultCursors.retrieveNotConsumedError().thenCompose(error -> this.doCommitAsync((Throwable)error).handle(UnmanagedTransaction.handleCommitOrRollback(error))).whenComplete((ignore, error) -> this.handleTransactionCompletion(true, (Throwable)error));
    }

    public CompletionStage<Void> rollbackAsync() {
        if (this.state.value == State.COMMITTED) {
            return Futures.failedFuture(new ClientException("Can't rollback, transaction has been committed"));
        }
        if (this.state.value == State.ROLLED_BACK) {
            return Futures.failedFuture(new ClientException("Can't rollback, transaction has been rolled back"));
        }
        return this.resultCursors.retrieveNotConsumedError().thenCompose(error -> this.doRollbackAsync().handle(UnmanagedTransaction.handleCommitOrRollback(error))).whenComplete((ignore, error) -> this.handleTransactionCompletion(false, (Throwable)error));
    }

    public CompletionStage<ResultCursor> runAsync(Query query) {
        this.ensureCanRunQueries();
        CompletionStage<AsyncResultCursor> cursorStage = this.protocol.runInUnmanagedTransaction(this.connection, query, this, this.fetchSize).asyncResult();
        this.resultCursors.add(cursorStage);
        return cursorStage.thenCompose(AsyncResultCursor::mapSuccessfulRunCompletionAsync).thenApply(cursor -> cursor);
    }

    public CompletionStage<RxResultCursor> runRx(Query query) {
        this.ensureCanRunQueries();
        CompletionStage<RxResultCursor> cursorStage = this.protocol.runInUnmanagedTransaction(this.connection, query, this, this.fetchSize).rxResult();
        this.resultCursors.add(cursorStage);
        return cursorStage;
    }

    public boolean isOpen() {
        return this.state.isOpen();
    }

    public void markTerminated(Throwable cause) {
        if (this.state.value == State.TERMINATED) {
            if (this.state.causeOfTermination != null) {
                this.addSuppressedWhenNotCaptured(this.state.causeOfTermination, cause);
            }
        } else {
            this.state = StateHolder.terminatedWith(cause);
        }
    }

    private void addSuppressedWhenNotCaptured(Throwable currentCause, Throwable newCause) {
        boolean noneMatch;
        if (currentCause != newCause && (noneMatch = Arrays.stream(currentCause.getSuppressed()).noneMatch(suppressed -> suppressed == newCause))) {
            currentCause.addSuppressed(newCause);
        }
    }

    public Connection connection() {
        return this.connection;
    }

    private void ensureCanRunQueries() {
        if (this.state.value == State.COMMITTED) {
            throw new ClientException("Cannot run more queries in this transaction, it has been committed");
        }
        if (this.state.value == State.ROLLED_BACK) {
            throw new ClientException("Cannot run more queries in this transaction, it has been rolled back");
        }
        if (this.state.value == State.TERMINATED) {
            throw new ClientException("Cannot run more queries in this transaction, it has either experienced an fatal error or was explicitly terminated", this.state.causeOfTermination);
        }
    }

    private CompletionStage<Void> doCommitAsync(Throwable cursorFailure) {
        if (this.state.value == State.TERMINATED) {
            return Futures.failedFuture(new ClientException("Transaction can't be committed. It has been rolled back either because of an error or explicit termination", cursorFailure != this.state.causeOfTermination ? this.state.causeOfTermination : null));
        }
        return this.protocol.commitTransaction(this.connection).thenAccept(this.bookmarkHolder::setBookmark);
    }

    private CompletionStage<Void> doRollbackAsync() {
        if (this.state.value == State.TERMINATED) {
            return Futures.completedWithNull();
        }
        return this.protocol.rollbackTransaction(this.connection);
    }

    private static BiFunction<Void, Throwable, Void> handleCommitOrRollback(Throwable cursorFailure) {
        return (ignore, commitOrRollbackError) -> {
            CompletionException combinedError = Futures.combineErrors(cursorFailure, commitOrRollbackError);
            if (combinedError != null) {
                throw combinedError;
            }
            return null;
        };
    }

    private void handleTransactionCompletion(boolean commitOnSuccess, Throwable throwable) {
        this.state = commitOnSuccess && throwable == null ? StateHolder.of(State.COMMITTED) : StateHolder.of(State.ROLLED_BACK);
        if (throwable instanceof AuthorizationExpiredException) {
            this.connection.terminateAndRelease("Authorization information kept on the server has expired, this connection is no longer valid.");
        } else {
            this.connection.release();
        }
    }

    private static final class StateHolder {
        private static final EnumSet<State> OPEN_STATES = EnumSet.of(State.ACTIVE, State.TERMINATED);
        private static final StateHolder ACTIVE_HOLDER = new StateHolder(State.ACTIVE, null);
        private static final StateHolder COMMITTED_HOLDER = new StateHolder(State.COMMITTED, null);
        private static final StateHolder ROLLED_BACK_HOLDER = new StateHolder(State.ROLLED_BACK, null);
        final State value;
        final Throwable causeOfTermination;

        static StateHolder of(State value) {
            switch (value) {
                case ACTIVE: {
                    return ACTIVE_HOLDER;
                }
                case COMMITTED: {
                    return COMMITTED_HOLDER;
                }
                case ROLLED_BACK: {
                    return ROLLED_BACK_HOLDER;
                }
            }
            throw new IllegalArgumentException("Cannot provide a default state holder for state " + (Object)((Object)value));
        }

        static StateHolder terminatedWith(Throwable cause) {
            return new StateHolder(State.TERMINATED, cause);
        }

        private StateHolder(State value, Throwable causeOfTermination) {
            this.value = value;
            this.causeOfTermination = causeOfTermination;
        }

        boolean isOpen() {
            return OPEN_STATES.contains((Object)this.value);
        }
    }

    private static enum State {
        ACTIVE,
        TERMINATED,
        COMMITTED,
        ROLLED_BACK;

    }
}

