/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.driver.NotificationClassification;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.NotificationSeverity;
import org.neo4j.driver.internal.InternalNotificationConfig;

public record GqlNotificationConfig(NotificationSeverity minimumSeverity, Set<NotificationClassification> disabledClassifications) {
    public static GqlNotificationConfig defaultConfig() {
        return new GqlNotificationConfig(null, null);
    }

    public static GqlNotificationConfig from(NotificationConfig notificationConfig) {
        Objects.requireNonNull(notificationConfig);
        InternalNotificationConfig config = (InternalNotificationConfig)notificationConfig;
        Set disabledClassifications = config.disabledCategories() != null ? config.disabledCategories().stream().map(NotificationClassification.class::cast).collect(Collectors.toUnmodifiableSet()) : null;
        return new GqlNotificationConfig(config.minimumSeverity(), disabledClassifications);
    }
}

