/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.driver.NotificationCategory;
import org.neo4j.driver.NotificationClassification;
import org.neo4j.driver.NotificationSeverity;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.summary.InternalGqlStatusObject;
import org.neo4j.driver.summary.InputPosition;
import org.neo4j.driver.summary.Notification;

public class InternalNotification
extends InternalGqlStatusObject
implements Notification {
    private final String code;
    private final String title;
    private final String description;
    private final NotificationSeverity severityLevel;
    private final String rawSeverityLevel;
    private final NotificationClassification classification;
    private final String rawClassification;
    private final InputPosition position;

    public static Optional<NotificationCategory> valueOf(String value) {
        return Arrays.stream(NotificationClassification.values()).filter(type -> type.toString().equals(value)).findFirst().map(type -> switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NotificationClassification.HINT -> NotificationCategory.HINT;
            case NotificationClassification.UNRECOGNIZED -> NotificationCategory.UNRECOGNIZED;
            case NotificationClassification.UNSUPPORTED -> NotificationCategory.UNSUPPORTED;
            case NotificationClassification.PERFORMANCE -> NotificationCategory.PERFORMANCE;
            case NotificationClassification.DEPRECATION -> NotificationCategory.DEPRECATION;
            case NotificationClassification.SECURITY -> NotificationCategory.SECURITY;
            case NotificationClassification.TOPOLOGY -> NotificationCategory.TOPOLOGY;
            case NotificationClassification.GENERIC -> NotificationCategory.GENERIC;
            case NotificationClassification.SCHEMA -> NotificationCategory.SCHEMA;
        });
    }

    public InternalNotification(String gqlStatus, String statusDescription, Map<String, Value> diagnosticRecord, String code, String title, String description, NotificationSeverity severityLevel, String rawSeverityLevel, NotificationClassification classification, String rawClassification, InputPosition position) {
        super(gqlStatus, statusDescription, diagnosticRecord);
        this.code = Objects.requireNonNull(code);
        this.title = title;
        this.description = description;
        this.severityLevel = severityLevel;
        this.rawSeverityLevel = rawSeverityLevel;
        this.classification = classification;
        this.rawClassification = rawClassification;
        this.position = position;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public InputPosition position() {
        return this.position;
    }

    @Override
    public Optional<NotificationSeverity> severityLevel() {
        return Optional.ofNullable(this.severityLevel);
    }

    @Override
    public Optional<String> rawSeverityLevel() {
        return Optional.ofNullable(this.rawSeverityLevel);
    }

    @Override
    public Optional<NotificationClassification> classification() {
        return Optional.ofNullable(this.classification);
    }

    @Override
    public Optional<String> rawClassification() {
        return Optional.ofNullable(this.rawClassification);
    }

    @Override
    public Optional<NotificationCategory> category() {
        return Optional.ofNullable(this.classification);
    }

    @Override
    public Optional<String> rawCategory() {
        return Optional.ofNullable(this.rawClassification);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InternalNotification that = (InternalNotification)o;
        return Objects.equals(this.code, that.code) && Objects.equals(this.title, that.title) && Objects.equals(this.description, that.description) && Objects.equals(this.severityLevel, that.severityLevel) && Objects.equals(this.rawSeverityLevel, that.rawSeverityLevel) && this.classification == that.classification && Objects.equals(this.rawClassification, that.rawClassification) && Objects.equals(this.position, that.position);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.code, this.title, this.description, this.severityLevel, this.rawSeverityLevel, this.classification, this.rawClassification, this.position);
    }

    @Override
    public String toString() {
        String info = "code=" + this.code + ", title=" + this.title + ", description=" + this.description + ", severityLevel=" + this.severityLevel + ", rawSeverityLevel=" + this.rawSeverityLevel + ", classification=" + this.classification + ", rawClassification=" + this.rawClassification;
        return this.position == null ? info : info + ", position={" + this.position + "}";
    }
}

