/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.bolt.api.AccessMode;
import org.neo4j.driver.internal.bolt.api.BoltAgent;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.DomainNameResolver;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.api.MetricsListener;
import org.neo4j.driver.internal.bolt.api.NotificationConfig;
import org.neo4j.driver.internal.bolt.api.RoutingContext;
import org.neo4j.driver.internal.bolt.api.SecurityPlan;
import org.neo4j.driver.internal.bolt.basicimpl.ConnectionProvider;
import org.neo4j.driver.internal.bolt.basicimpl.async.NetworkConnection;
import org.neo4j.driver.internal.bolt.basicimpl.async.connection.ChannelConnectedListener;
import org.neo4j.driver.internal.bolt.basicimpl.async.connection.ChannelPipelineBuilderImpl;
import org.neo4j.driver.internal.bolt.basicimpl.async.connection.NettyChannelInitializer;
import org.neo4j.driver.internal.bolt.basicimpl.async.connection.NettyDomainNameResolverGroup;
import org.neo4j.driver.internal.bolt.basicimpl.async.inbound.ConnectTimeoutHandler;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.BoltProtocol;
import org.neo4j.driver.internal.bolt.basicimpl.spi.Connection;

public final class NettyConnectionProvider
implements ConnectionProvider {
    private final EventLoopGroup eventLoopGroup;
    private final Clock clock;
    private final DomainNameResolver domainNameResolver;
    private final AddressResolverGroup<InetSocketAddress> addressResolverGroup;
    private final LocalAddress localAddress;
    private final LoggingProvider logging;

    public NettyConnectionProvider(EventLoopGroup eventLoopGroup, Clock clock, DomainNameResolver domainNameResolver, LocalAddress localAddress, LoggingProvider logging) {
        this.eventLoopGroup = eventLoopGroup;
        this.clock = Objects.requireNonNull(clock);
        this.domainNameResolver = Objects.requireNonNull(domainNameResolver);
        this.addressResolverGroup = new NettyDomainNameResolverGroup(this.domainNameResolver);
        this.localAddress = localAddress;
        this.logging = logging;
    }

    @Override
    public CompletionStage<Connection> acquireConnection(BoltServerAddress address, SecurityPlan securityPlan, RoutingContext routingContext, String databaseName, Map<String, Value> authMap, BoltAgent boltAgent, String userAgent, AccessMode mode, int connectTimeoutMillis, String impersonatedUser, CompletableFuture<Long> latestAuthMillisFuture, NotificationConfig notificationConfig, MetricsListener metricsListener) {
        Object socketAddress;
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.eventLoopGroup)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeoutMillis)).channel(this.localAddress != null ? LocalChannel.class : NioSocketChannel.class)).resolver(this.addressResolverGroup).handler((ChannelHandler)new NettyChannelInitializer(address, securityPlan, connectTimeoutMillis, this.clock, this.logging));
        if (this.localAddress == null) {
            try {
                socketAddress = new InetSocketAddress(this.domainNameResolver.resolve(address.connectionHost())[0], address.port());
            }
            catch (Throwable t) {
                socketAddress = InetSocketAddress.createUnresolved(address.connectionHost(), address.port());
            }
        } else {
            socketAddress = this.localAddress;
        }
        return this.installChannelConnectedListeners(address, bootstrap.connect((SocketAddress)socketAddress), connectTimeoutMillis).thenCompose(channel -> BoltProtocol.forChannel(channel).initializeChannel((Channel)channel, Objects.requireNonNull(userAgent), Objects.requireNonNull(boltAgent), authMap, routingContext, notificationConfig, this.clock, latestAuthMillisFuture)).thenApply(channel -> new NetworkConnection((Channel)channel, this.logging));
    }

    private CompletionStage<Channel> installChannelConnectedListeners(BoltServerAddress address, ChannelFuture channelConnected, int connectTimeoutMillis) {
        ChannelPipeline pipeline = channelConnected.channel().pipeline();
        channelConnected.addListener(future -> pipeline.addFirst(new ChannelHandler[]{new ConnectTimeoutHandler(connectTimeoutMillis)}));
        CompletableFuture<Channel> handshakeCompleted = new CompletableFuture<Channel>();
        channelConnected.addListener((GenericFutureListener)new ChannelConnectedListener(address, new ChannelPipelineBuilderImpl(), handshakeCompleted, this.logging));
        return handshakeCompleted.whenComplete((channel, throwable) -> {
            if (throwable == null) {
                channel.pipeline().remove(ConnectTimeoutHandler.class);
            }
        });
    }
}

