/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.handlers;

import io.netty.channel.Channel;
import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.basicimpl.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v43.BoltProtocolV43;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v44.BoltProtocolV44;
import org.neo4j.driver.internal.bolt.basicimpl.spi.ResponseHandler;
import org.neo4j.driver.internal.bolt.basicimpl.util.MetadataExtractor;

public class HelloResponseHandler
implements ResponseHandler {
    private static final String CONNECTION_ID_METADATA_KEY = "connection_id";
    public static final String CONFIGURATION_HINTS_KEY = "hints";
    public static final String CONNECTION_RECEIVE_TIMEOUT_SECONDS_KEY = "connection.recv_timeout_seconds";
    private final CompletableFuture<String> future;
    private final Channel channel;
    private final Clock clock;
    private final CompletableFuture<Long> latestAuthMillisFuture;

    public HelloResponseHandler(CompletableFuture<String> future, Channel channel, Clock clock, CompletableFuture<Long> latestAuthMillisFuture) {
        Objects.requireNonNull(clock, "clock must not be null");
        this.future = future;
        this.channel = channel;
        this.clock = clock;
        this.latestAuthMillisFuture = Objects.requireNonNull(latestAuthMillisFuture);
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        try {
            Set<String> boltPatches;
            String serverAgent = MetadataExtractor.extractServer(metadata).asString();
            ChannelAttributes.setServerAgent(this.channel, serverAgent);
            String connectionId = HelloResponseHandler.extractConnectionId(metadata);
            ChannelAttributes.setConnectionId(this.channel, connectionId);
            this.processConfigurationHints(metadata);
            BoltProtocolVersion protocolVersion = ChannelAttributes.protocolVersion(this.channel);
            if ((BoltProtocolV44.VERSION.equals(protocolVersion) || BoltProtocolV43.VERSION.equals(protocolVersion)) && !(boltPatches = MetadataExtractor.extractBoltPatches(metadata)).isEmpty()) {
                ChannelAttributes.boltPatchesListeners(this.channel).forEach(listener -> listener.handle(boltPatches));
            }
            this.latestAuthMillisFuture.complete(this.clock.millis());
            this.future.complete(serverAgent);
        }
        catch (Throwable error) {
            this.onFailure(error);
            throw error;
        }
    }

    @Override
    public void onFailure(Throwable error) {
        this.channel.close().addListener(future -> this.future.completeExceptionally(error));
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }

    private static String extractConnectionId(Map<String, Value> metadata) {
        Value value = metadata.get(CONNECTION_ID_METADATA_KEY);
        if (value == null || value.isNull()) {
            throw new IllegalStateException("Unable to extract connection_id from a response to HELLO message. Received metadata: " + metadata);
        }
        return value.asString();
    }

    private void processConfigurationHints(Map<String, Value> metadata) {
        Value configurationHints = metadata.get(CONFIGURATION_HINTS_KEY);
        if (configurationHints != null) {
            HelloResponseHandler.getFromSupplierOrEmptyOnException(() -> configurationHints.get(CONNECTION_RECEIVE_TIMEOUT_SECONDS_KEY).asLong()).ifPresent(timeout -> ChannelAttributes.setConnectionReadTimeout(this.channel, timeout));
        }
    }

    private static <T> Optional<T> getFromSupplierOrEmptyOnException(Supplier<T> supplier) {
        try {
            return Optional.of(supplier.get());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

