/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.summary;

import java.util.function.Function;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.internal.bolt.api.GqlStatusError;

public enum QueryType {
    READ_ONLY,
    READ_WRITE,
    WRITE_ONLY,
    SCHEMA_WRITE;

    private static final String UNEXPECTED_TYPE_MSG_FMT = "Unknown query type: `%s`.";
    private static final Function<String, ClientException> UNEXPECTED_TYPE_EXCEPTION_SUPPLIER;

    public static QueryType fromCode(String type) {
        return QueryType.fromCode(type, UNEXPECTED_TYPE_EXCEPTION_SUPPLIER);
    }

    public static QueryType fromCode(String type, Function<String, ? extends Neo4jException> exceptionFunction) {
        switch (type) {
            case "r": {
                return READ_ONLY;
            }
            case "rw": {
                return READ_WRITE;
            }
            case "w": {
                return WRITE_ONLY;
            }
            case "s": {
                return SCHEMA_WRITE;
            }
        }
        if (exceptionFunction != null) {
            throw exceptionFunction.apply(type);
        }
        return null;
    }

    static {
        UNEXPECTED_TYPE_EXCEPTION_SUPPLIER = type -> new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(String.format(UNEXPECTED_TYPE_MSG_FMT, type)), "N/A", String.format(UNEXPECTED_TYPE_MSG_FMT, type), GqlStatusError.DIAGNOSTIC_RECORD, null);
    }
}

