/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.backup.BackupClient;
import org.neo4j.backup.IncrementalBackupNotPossibleException;
import org.neo4j.backup.LogicalLogSeeder;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.backup.VerificationLevel;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.TxExtractor;
import org.neo4j.com.storecopy.RemoteStoreCopier;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.Triplet;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigParam;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchLogVersionException;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

class BackupService {
    static final String TOO_OLD_BACKUP = "It's been too long since this backup was last updated, and it has fallen too far behind the database transaction stream for incremental backup to be possible. You need to perform a full backup at this point. You can modify this time interval by setting the '" + GraphDatabaseSettings.keep_logical_logs.name() + "' configuration on the database to a higher value.";
    static final String DIFFERENT_STORE = "Target directory contains full backup of a logically different store.";
    private final FileSystemAbstraction fileSystem;
    private final StringLogger logger;

    BackupService() {
        this((FileSystemAbstraction)new DefaultFileSystemAbstraction(), StringLogger.SYSTEM);
    }

    BackupService(FileSystemAbstraction fileSystem) {
        this(fileSystem, StringLogger.SYSTEM);
    }

    BackupService(FileSystemAbstraction fileSystem, StringLogger logger) {
        this.fileSystem = fileSystem;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackupOutcome doFullBackup(final String sourceHostNameOrIp, final int sourcePort, String targetDirectory, boolean checkConsistency, Config tuningConfiguration, final boolean forensics) {
        if (this.directoryContainsDb(targetDirectory)) {
            throw new RuntimeException(targetDirectory + " already contains a database");
        }
        Map params = tuningConfiguration.getParams();
        params.put(GraphDatabaseSettings.store_dir.name(), targetDirectory);
        tuningConfiguration.applyChanges(params);
        long timestamp = System.currentTimeMillis();
        TreeMap<String, Long> lastCommittedTxs = new TreeMap<String, Long>();
        boolean consistent = !checkConsistency;
        GraphDatabaseAPI targetDb = null;
        try {
            ConsoleLogger consoleLog = new ConsoleLogger(StringLogger.SYSTEM);
            RemoteStoreCopier storeCopier = new RemoteStoreCopier(tuningConfiguration, this.loadKernelExtensions(), consoleLog, (Logging)new DevNullLoggingService(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), new Monitors());
            storeCopier.copyStore(new RemoteStoreCopier.StoreCopyRequester(){
                private BackupClient client;

                public Response<?> copyStore(StoreWriter writer) {
                    this.client = new BackupClient(sourceHostNameOrIp, sourcePort, (Logging)new DevNullLoggingService(), new Monitors(), null);
                    this.client.start();
                    return this.client.fullBackup(writer, forensics);
                }

                public void done() {
                    this.client.stop();
                }
            }, CancellationRequest.NONE);
            targetDb = BackupService.startTemporaryDb(targetDirectory, VerificationLevel.NONE);
            new LogicalLogSeeder(this.logger).ensureAtLeastOneLogicalLogPresent(sourceHostNameOrIp, sourcePort, targetDb);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (targetDb != null) {
                targetDb.shutdown();
            }
        }
        BackupService.bumpLogFile(targetDirectory, timestamp);
        if (checkConsistency) {
            try {
                consistent = new ConsistencyCheckService().runFullConsistencyCheck(targetDirectory, tuningConfiguration, ProgressMonitorFactory.textual((OutputStream)System.err), this.logger).isSuccessful();
            }
            catch (ConsistencyCheckIncompleteException e) {
                this.logger.error("Consistency check incomplete", (Throwable)e);
            }
            finally {
                this.logger.flush();
            }
        }
        return new BackupOutcome(lastCommittedTxs, consistent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackupOutcome doIncrementalBackup(String sourceHostNameOrIp, int sourcePort, String targetDirectory, boolean verification) throws IncrementalBackupNotPossibleException {
        if (!this.directoryContainsDb(targetDirectory)) {
            throw new RuntimeException(targetDirectory + " doesn't contain a database");
        }
        ConfigParam keepLogs = new ConfigParam(){

            public void configure(Map<String, String> config) {
                config.put(GraphDatabaseSettings.keep_logical_logs.name(), "true");
            }
        };
        GraphDatabaseAPI targetDb = BackupService.startTemporaryDb(targetDirectory, VerificationLevel.valueOf(verification), keepLogs);
        long backupStartTime = System.currentTimeMillis();
        BackupOutcome outcome = null;
        try {
            outcome = this.doIncrementalBackup(sourceHostNameOrIp, sourcePort, targetDb);
        }
        finally {
            targetDb.shutdown();
        }
        BackupService.bumpLogFile(targetDirectory, backupStartTime);
        return outcome;
    }

    BackupOutcome doIncrementalBackupOrFallbackToFull(String sourceHostNameOrIp, int sourcePort, String targetDirectory, boolean verification, Config config, boolean forensics) {
        if (!this.directoryContainsDb(targetDirectory)) {
            return this.doFullBackup(sourceHostNameOrIp, sourcePort, targetDirectory, verification, config, forensics);
        }
        try {
            return this.doIncrementalBackup(sourceHostNameOrIp, sourcePort, targetDirectory, verification);
        }
        catch (IncrementalBackupNotPossibleException e) {
            try {
                this.logger.info("Existing backup is too far out of date, a new full backup will be performed.");
                File targetDirFile = new File(targetDirectory);
                FileUtils.deleteRecursively((File)targetDirFile);
                return this.doFullBackup(sourceHostNameOrIp, sourcePort, targetDirFile.getAbsolutePath(), verification, config, forensics);
            }
            catch (Exception fullBackupFailure) {
                throw new RuntimeException("Failed to perform incremental backup, fell back to full backup, but that failed as well: '" + fullBackupFailure.getMessage() + "'.", fullBackupFailure);
            }
        }
    }

    BackupOutcome doIncrementalBackup(String sourceHostNameOrIp, int sourcePort, GraphDatabaseAPI targetDb) throws IncrementalBackupNotPossibleException {
        return this.incrementalWithContext(sourceHostNameOrIp, sourcePort, targetDb, this.slaveContextOf(targetDb));
    }

    private RequestContext slaveContextOf(GraphDatabaseAPI graphDb) {
        XaDataSourceManager dsManager = this.dsManager(graphDb);
        ArrayList<RequestContext.Tx> txs = new ArrayList<RequestContext.Tx>();
        for (XaDataSource ds : dsManager.getAllRegisteredDataSources()) {
            txs.add(RequestContext.lastAppliedTx((String)ds.getName(), (long)ds.getLastCommittedTxId()));
        }
        return RequestContext.anonymous((RequestContext.Tx[])txs.toArray(new RequestContext.Tx[txs.size()]));
    }

    boolean directoryContainsDb(String targetDirectory) {
        return this.fileSystem.fileExists(new File(targetDirectory, "neostore"));
    }

    static GraphDatabaseAPI startTemporaryDb(String targetDirectory, ConfigParam ... params) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(OnlineBackupSettings.online_backup_enabled.name(), "false");
        config.put(InternalAbstractGraphDatabase.Configuration.log_configuration_file.name(), "neo4j-backup-logback.xml");
        for (ConfigParam param : params) {
            if (param == null) continue;
            param.configure(config);
        }
        return (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(targetDirectory).setConfig(config).newGraphDatabase();
    }

    private BackupOutcome incrementalWithContext(String sourceHostNameOrIp, int sourcePort, GraphDatabaseAPI targetDb, RequestContext context) throws IncrementalBackupNotPossibleException {
        Map<String, Long> lastCommittedTxs;
        BackupClient client = new BackupClient(sourceHostNameOrIp, sourcePort, (Logging)targetDb.getDependencyResolver().resolveDependency(Logging.class), (Monitors)targetDb.getDependencyResolver().resolveDependency(Monitors.class), targetDb.storeId());
        client.start();
        boolean successfullyReadLastCommittedTxs = false;
        try {
            lastCommittedTxs = this.unpackResponse(client.incrementalBackup(context), (XaDataSourceManager)targetDb.getDependencyResolver().resolveDependency(XaDataSourceManager.class), new ProgressTxHandler());
            this.trimLogicalLogCount(targetDb);
            successfullyReadLastCommittedTxs = true;
        }
        catch (MismatchingStoreIdException e) {
            throw new RuntimeException(DIFFERENT_STORE, e);
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof NoSuchLogVersionException) {
                throw new IncrementalBackupNotPossibleException(TOO_OLD_BACKUP, e.getCause());
            }
            throw new RuntimeException("Failed to perform incremental backup.", e);
        }
        finally {
            try {
                client.stop();
            }
            catch (Throwable throwable) {
                if (successfullyReadLastCommittedTxs) {
                    this.logger.warn("Unable to stop backup client", throwable);
                }
                throw new RuntimeException("Unable to stop backup client", throwable);
            }
        }
        return new BackupOutcome(lastCommittedTxs, true);
    }

    private void trimLogicalLogCount(GraphDatabaseAPI targetDb) {
        for (XaDataSource ds : this.dsManager(targetDb).getAllRegisteredDataSources()) {
            long currentVersion;
            try {
                ds.rotateLogicalLog();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (currentVersion = ds.getCurrentLogVersion() - 1L; ds.getLogicalLogLength(currentVersion) <= 16L && currentVersion > 0L; --currentVersion) {
            }
            --currentVersion;
            while (ds.getLogicalLogLength(currentVersion) > 0L) {
                ds.deleteLogicalLog(currentVersion);
                --currentVersion;
            }
        }
    }

    private XaDataSourceManager dsManager(GraphDatabaseAPI targetDb) {
        return (XaDataSourceManager)targetDb.getDependencyResolver().resolveDependency(XaDataSourceManager.class);
    }

    private Map<String, Long> unpackResponse(Response<Void> response, XaDataSourceManager xaDsm, ServerUtil.TxHandler txHandler) {
        try {
            ServerUtil.applyReceivedTransactions(response, (XaDataSourceManager)xaDsm, (ServerUtil.TxHandler)txHandler);
            return this.extractLastCommittedTxs(xaDsm);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to apply received transactions", e);
        }
    }

    private Map<String, Long> extractLastCommittedTxs(XaDataSourceManager xaDsm) {
        TreeMap<String, Long> lastCommittedTxs = new TreeMap<String, Long>();
        for (XaDataSource ds : xaDsm.getAllRegisteredDataSources()) {
            lastCommittedTxs.put(ds.getName(), ds.getLastCommittedTxId());
        }
        return lastCommittedTxs;
    }

    private static boolean bumpLogFile(String targetDirectory, long toTimestamp) {
        File dbDirectory = new File(targetDirectory);
        File[] candidates = dbDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals("messages.log");
            }
        });
        if (candidates.length != 1) {
            return false;
        }
        File previous = candidates[0];
        File to = new File(previous.getParentFile(), "messages.log." + toTimestamp);
        return previous.renameTo(to);
    }

    private List<KernelExtensionFactory<?>> loadKernelExtensions() {
        ArrayList kernelExtensions = new ArrayList();
        for (KernelExtensionFactory factory : Service.load(KernelExtensionFactory.class)) {
            kernelExtensions.add(factory);
        }
        return kernelExtensions;
    }

    private static class ProgressTxHandler
    implements ServerUtil.TxHandler {
        private final ProgressListener progress = ProgressMonitorFactory.textual((OutputStream)System.out).openEnded("Transactions applied", 1000);

        private ProgressTxHandler() {
        }

        public void accept(Triplet<String, Long, TxExtractor> tx, XaDataSource dataSource) {
            this.progress.add(1L);
        }

        public void done() {
            this.progress.done();
        }
    }

    class BackupOutcome {
        private final Map<String, Long> lastCommittedTxs;
        private final boolean consistent;

        BackupOutcome(Map<String, Long> lastCommittedTxs, boolean consistent) {
            this.lastCommittedTxs = lastCommittedTxs;
            this.consistent = consistent;
        }

        public Map<String, Long> getLastCommittedTxs() {
            return Collections.unmodifiableMap(this.lastCommittedTxs);
        }

        public boolean isConsistent() {
            return this.consistent;
        }
    }
}

