/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.backup.BackupService;
import org.neo4j.backup.VerificationLevel;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.direct.DirectStoreAccess;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigParam;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;
import org.neo4j.kernel.impl.nioneo.xa.LogDeserializer;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriter;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriterFactory;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandWriter;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriterv1;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.util.Consumer;
import org.neo4j.kernel.impl.util.Cursor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;

class RebuildFromLogs {
    private static final FileSystemAbstraction FS = new DefaultFileSystemAbstraction();
    private final NeoStoreXaDataSource nioneo;
    private final StoreAccess stores;

    RebuildFromLogs(GraphDatabaseAPI graphdb) {
        this.nioneo = RebuildFromLogs.getDataSource(graphdb, "nioneodb");
        this.stores = new StoreAccess(graphdb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RebuildFromLogs applyTransactionsFrom(ProgressListener progress, File sourceDir) throws IOException {
        LogExtractor extractor = null;
        try {
            long txId;
            extractor = LogExtractor.from((FileSystemAbstraction)FS, (XaCommandReaderFactory)XaCommandReaderFactory.DEFAULT, (XaCommandWriterFactory)new XaCommandWriterFactory(){

                public XaCommandWriter newInstance() {
                    return new PhysicalLogNeoXaCommandWriter();
                }
            }, (ByteCounterMonitor)((ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0])), (LogEntryWriter)new LogEntryWriterv1(), (File)sourceDir);
            InMemoryLogBuffer buffer = new InMemoryLogBuffer();
            while ((txId = extractor.extractNext((LogBuffer)buffer)) != -1L) {
                this.applyTransaction(txId, (ReadableByteChannel)buffer);
                progress.set(txId);
                buffer.reset();
            }
        }
        finally {
            if (extractor != null) {
                extractor.close();
            }
            progress.done();
        }
        return this;
    }

    public void applyTransaction(long txId, ReadableByteChannel txData) throws IOException {
        this.nioneo.applyCommittedTransaction(txId, txData);
    }

    private static NeoStoreXaDataSource getDataSource(GraphDatabaseAPI graphdb, String name) {
        NeoStoreXaDataSource datasource = ((XaDataSourceManager)graphdb.getDependencyResolver().resolveDependency(XaDataSourceManager.class)).getNeoStoreDataSource();
        if (datasource == null) {
            throw new NullPointerException("Could not access " + name);
        }
        return datasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ProgressMonitorFactory progress;
        long maxFileId;
        if (args == null) {
            RebuildFromLogs.printUsage(new String[0]);
            return;
        }
        Args params = new Args(args);
        boolean full = params.getBoolean("full", Boolean.valueOf(false), Boolean.valueOf(true));
        List orphans = params.orphans();
        args = orphans.toArray(new String[orphans.size()]);
        if (args.length != 2) {
            RebuildFromLogs.printUsage("Exactly two positional arguments expected: <source dir with logs> <target dir for graphdb>, got " + args.length);
            System.exit(-1);
            return;
        }
        File source = new File(args[0]);
        File target = new File(args[1]);
        if (!source.isDirectory()) {
            RebuildFromLogs.printUsage(source + " is not a directory");
            System.exit(-1);
            return;
        }
        if (target.exists()) {
            if (target.isDirectory()) {
                if (new BackupService().directoryContainsDb(target.getAbsolutePath())) {
                    RebuildFromLogs.printUsage("target graph database already exists");
                    System.exit(-1);
                    return;
                }
                System.err.println("WARNING: the directory " + target + " already exists");
            } else {
                RebuildFromLogs.printUsage(target + " is a file");
                System.exit(-1);
                return;
            }
        }
        if ((maxFileId = RebuildFromLogs.findMaxLogFileId(source)) < 0L) {
            RebuildFromLogs.printUsage("Inconsistent number of log files found in " + source);
            System.exit(-1);
            return;
        }
        long txCount = RebuildFromLogs.findLastTransactionId(source, "nioneo_logical.log.v" + maxFileId);
        String txdifflog = params.get("txdifflog", null, new File(target, "txdiff.log").getAbsolutePath());
        GraphDatabaseAPI graphdb = BackupService.startTemporaryDb(target.getAbsolutePath(), new TxDiffLogConfig(full ? VerificationLevel.FULL_WITH_LOGGING : VerificationLevel.LOGGING, txdifflog));
        if (txCount < 0L) {
            progress = ProgressMonitorFactory.NONE;
            System.err.println("Unable to report progress, cannot find highest txId, attempting rebuild anyhow.");
        } else {
            progress = ProgressMonitorFactory.textual((OutputStream)System.err);
        }
        try {
            try {
                ProgressListener listener = progress.singlePart(String.format("Rebuilding store from %s transactions ", txCount), txCount);
                RebuildFromLogs rebuilder = new RebuildFromLogs(graphdb).applyTransactionsFrom(listener, source);
                if (!full) {
                    rebuilder.checkConsistency();
                }
            }
            finally {
                graphdb.shutdown();
            }
        }
        catch (Exception e) {
            System.err.println();
            e.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long findLastTransactionId(File storeDir, String logFileName) {
        final AtomicLong txId = new AtomicLong();
        try (FileChannel channel = new RandomAccessFile(new File(storeDir, logFileName), "r").getChannel();){
            ByteBuffer buffer = ByteBuffer.allocateDirect(713);
            txId.set(VersionAwareLogEntryReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)channel, (boolean)true)[1]);
            LogDeserializer deserializer = new LogDeserializer(buffer, XaCommandReaderFactory.DEFAULT);
            Cursor cursor = deserializer.cursor((ReadableByteChannel)channel);
            Consumer<LogEntry, IOException> consumer = new Consumer<LogEntry, IOException>(){

                public boolean accept(LogEntry entry) throws IOException {
                    if (entry instanceof LogEntry.Commit) {
                        txId.set(((LogEntry.Commit)entry).getTxId());
                    }
                    return true;
                }
            };
            while (cursor.next((Consumer)consumer)) {
            }
        }
        catch (IOException e) {
            return -1L;
        }
        return txId.get();
    }

    private void checkConsistency() throws ConsistencyCheckIncompleteException {
        Config tuningConfiguration = new Config(MapUtil.stringMap((String[])new String[0]), new Class[]{GraphDatabaseSettings.class, ConsistencyCheckSettings.class});
        new FullCheck(tuningConfiguration, ProgressMonitorFactory.textual((OutputStream)System.err)).execute(new DirectStoreAccess(this.stores, this.nioneo.getLabelScanStore(), this.nioneo.getIndexProvider()), StringLogger.SYSTEM);
    }

    private static void printUsage(String ... msgLines) {
        for (String line : msgLines) {
            System.err.println(line);
        }
        System.err.println(Args.jarUsage(RebuildFromLogs.class, (String[])new String[]{"[-full] <source dir with logs> <target dir for graphdb>"}));
        System.err.println("WHERE:   <source dir>  is the path for where transactions to rebuild from are stored");
        System.err.println("         <target dir>  is the path for where to create the new graph database");
        System.err.println("         -full     --  to run a full check over the entire store for each transaction");
    }

    private static long findMaxLogFileId(File source) {
        return XaLogicalLog.getHighestHistoryLogVersion((FileSystemAbstraction)FS, (File)source, (String)"nioneo_logical.log");
    }

    private static class TxDiffLogConfig
    implements ConfigParam {
        private final String targetFile;
        private final VerificationLevel level;

        TxDiffLogConfig(VerificationLevel level, String targetFile) {
            this.level = level;
            this.targetFile = targetFile;
        }

        public void configure(Map<String, String> config) {
            if (this.targetFile != null) {
                this.level.configureWithDiffLog(config, this.targetFile);
            } else {
                this.level.configure(config);
            }
        }
    }
}

