/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.logging;

import java.io.File;
import java.io.IOException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;

public class BoltMessageLog
extends LifecycleAdapter {
    private static final long ROTATION_THRESHOLD_BYTES = ByteUnit.MebiByte.toBytes(20L);
    private static final long ROTATION_DELAY_MS = TimeUnit.SECONDS.toMillis(500L);
    private static final int MAX_ARCHIVES = 10;
    private final Log inner;
    private final RotatingFileOutputStreamSupplier outputStreamSupplier;

    BoltMessageLog(FileSystemAbstraction fileSystem, ZoneId logTimeZone, File logFile, Executor executor) throws IOException {
        this.outputStreamSupplier = new RotatingFileOutputStreamSupplier(fileSystem, logFile, ROTATION_THRESHOLD_BYTES, ROTATION_DELAY_MS, 10, executor);
        DateTimeFormatter isoDateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        FormattedLog formattedLog = FormattedLog.withZoneId((ZoneId)logTimeZone).withDateTimeFormatter(isoDateTimeFormatter).toOutputStream((Supplier)this.outputStreamSupplier);
        formattedLog.setLevel(Level.DEBUG);
        this.inner = formattedLog;
    }

    public void error(String remoteAddress, String message) {
        this.inner.error("%s %s", new Object[]{remoteAddress, message});
    }

    public void error(String remoteAddress, String message, String arg1) {
        this.inner.error("%s %s %s", new Object[]{remoteAddress, message, arg1});
    }

    public void error(String remoteAddress, String message, String arg1, String arg2) {
        this.inner.error("%s %s %s %s", new Object[]{remoteAddress, message, arg1, arg2});
    }

    public void warn(String remoteAddress, String message) {
        this.inner.warn("%s %s", new Object[]{remoteAddress, message});
    }

    public void warn(String remoteAddress, String message, String arg1) {
        this.inner.warn("%s %s %s", new Object[]{remoteAddress, message, arg1});
    }

    public void warn(String remoteAddress, String message, String arg1, String arg2) {
        this.inner.warn("%s %s %s %s", new Object[]{remoteAddress, message, arg1, arg2});
    }

    public void info(String remoteAddress, String message) {
        this.inner.info("%s %s", new Object[]{remoteAddress, message});
    }

    public void info(String remoteAddress, String message, String arg1) {
        this.inner.info("%s %s %s", new Object[]{remoteAddress, message, arg1});
    }

    public void info(String remoteAddress, String message, String arg1, String arg2) {
        this.inner.info("%s %s %s %s", new Object[]{remoteAddress, message, arg1, arg2});
    }

    public void info(String remoteAddress, String message, String arg1, String arg2, String arg3) {
        this.inner.info("%s %s %s %s", new Object[]{remoteAddress, message, arg1, arg2, arg3});
    }

    public void debug(String remoteAddress, String message) {
        this.inner.debug("%s %s", new Object[]{remoteAddress, message});
    }

    public void debug(String remoteAddress, String message, String arg1) {
        this.inner.debug("%s %s %s", new Object[]{remoteAddress, message, arg1});
    }

    public void debug(String remoteAddress, String message, String arg1, String arg2) {
        this.inner.debug("%s %s %s %s", new Object[]{remoteAddress, message, arg1, arg2});
    }

    public void shutdown() throws Throwable {
        if (this.outputStreamSupplier != null) {
            this.outputStreamSupplier.close();
        }
    }
}

