/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import java.time.Clock;
import java.time.Duration;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.BoltStateMachineFactory;
import org.neo4j.bolt.runtime.TransactionStateMachineSPI;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.v1.runtime.BoltStateMachineV1;
import org.neo4j.bolt.v1.runtime.BoltStateMachineV1SPI;
import org.neo4j.bolt.v3.BoltStateMachineV3;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.udc.UsageData;

public class BoltStateMachineFactoryImpl
implements BoltStateMachineFactory {
    private final GraphDatabaseAPI db;
    private final UsageData usageData;
    private final AvailabilityGuard availabilityGuard;
    private final LogService logging;
    private final Authentication authentication;
    private final BoltConnectionTracker connectionTracker;
    private final Config config;
    private final Clock clock;

    public BoltStateMachineFactoryImpl(GraphDatabaseAPI db, UsageData usageData, AvailabilityGuard availabilityGuard, Authentication authentication, BoltConnectionTracker connectionTracker, Clock clock, Config config, LogService logging) {
        this.db = db;
        this.usageData = usageData;
        this.availabilityGuard = availabilityGuard;
        this.logging = logging;
        this.authentication = authentication;
        this.connectionTracker = connectionTracker;
        this.config = config;
        this.clock = clock;
    }

    @Override
    public BoltStateMachine newStateMachine(long protocolVersion, BoltChannel boltChannel) {
        if (protocolVersion == 1L || protocolVersion == 2L) {
            return this.newStateMachineV1(boltChannel);
        }
        if (protocolVersion == 3L) {
            return this.newStateMachineV3(boltChannel);
        }
        throw new IllegalArgumentException("Failed to create a state machine for protocol version " + protocolVersion);
    }

    private BoltStateMachine newStateMachineV1(BoltChannel boltChannel) {
        TransactionStateMachineSPI transactionSPI = this.createTxSpi(this.clock);
        BoltStateMachineV1SPI boltSPI = new BoltStateMachineV1SPI(boltChannel, this.usageData, this.logging, this.authentication, this.connectionTracker, transactionSPI);
        return new BoltStateMachineV1(boltSPI, boltChannel, this.clock);
    }

    private BoltStateMachine newStateMachineV3(BoltChannel boltChannel) {
        TransactionStateMachineSPI transactionSPI = this.createTxSpi(this.clock);
        BoltStateMachineV1SPI boltSPI = new BoltStateMachineV1SPI(boltChannel, this.usageData, this.logging, this.authentication, this.connectionTracker, transactionSPI);
        return new BoltStateMachineV3(boltSPI, boltChannel, this.clock);
    }

    private TransactionStateMachineSPI createTxSpi(Clock clock) {
        long bookmarkReadyTimeout = ((Duration)this.config.get(GraphDatabaseSettings.bookmark_ready_timeout)).toMillis();
        Duration txAwaitDuration = Duration.ofMillis(bookmarkReadyTimeout);
        return new org.neo4j.bolt.v1.runtime.TransactionStateMachineSPI(this.db, this.availabilityGuard, txAwaitDuration, clock);
    }
}

