/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.Neo4jError;
import org.neo4j.bolt.runtime.StatementProcessor;
import org.neo4j.values.AnyValue;

public class MutableConnectionState
implements BoltResponseHandler {
    private String owner;
    private Neo4jError pendingError;
    private boolean pendingIgnore;
    private volatile boolean terminated;
    private boolean closed;
    private BoltResponseHandler responseHandler;
    private StatementProcessor statementProcessor = StatementProcessor.EMPTY;
    private final AtomicInteger interruptCounter = new AtomicInteger();

    @Override
    public void onRecords(BoltResult result, boolean pull) throws Exception {
        if (this.responseHandler != null) {
            this.responseHandler.onRecords(result, pull);
        }
    }

    @Override
    public void onMetadata(String key, AnyValue value) {
        if (this.responseHandler != null) {
            this.responseHandler.onMetadata(key, value);
        }
    }

    @Override
    public void markIgnored() {
        if (this.responseHandler != null) {
            this.responseHandler.markIgnored();
        } else {
            this.pendingIgnore = true;
        }
    }

    @Override
    public void markFailed(Neo4jError error) {
        if (this.responseHandler != null) {
            this.responseHandler.markFailed(error);
        } else {
            this.pendingError = error;
        }
    }

    @Override
    public void onFinish() {
        if (this.responseHandler != null) {
            this.responseHandler.onFinish();
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Neo4jError getPendingError() {
        return this.pendingError;
    }

    public boolean hasPendingIgnore() {
        return this.pendingIgnore;
    }

    public void resetPendingFailedAndIgnored() {
        this.pendingError = null;
        this.pendingIgnore = false;
    }

    public boolean canProcessMessage() {
        return !this.closed && this.pendingError == null && !this.pendingIgnore;
    }

    public BoltResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public void setResponseHandler(BoltResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    public StatementProcessor getStatementProcessor() {
        return this.statementProcessor;
    }

    public void setStatementProcessor(StatementProcessor statementProcessor) {
        this.statementProcessor = statementProcessor;
    }

    public boolean isInterrupted() {
        return this.interruptCounter.get() > 0;
    }

    public int incrementInterruptCounter() {
        return this.interruptCounter.incrementAndGet();
    }

    public int decrementInterruptCounter() {
        return this.interruptCounter.decrementAndGet();
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void markTerminated() {
        this.terminated = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void markClosed() {
        this.closed = true;
    }
}

