/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.kernel.impl.logging.LogService;

public class HouseKeeper
extends ChannelInboundHandlerAdapter {
    private final BoltConnection connection;
    private final LogService logging;

    public HouseKeeper(BoltConnection connection, LogService logging) {
        this.connection = connection;
        this.logging = logging;
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.connection.stop();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logging.getInternalLog(((Object)((Object)this)).getClass()).error("Fatal error occurred when handling a client connection: " + ctx.channel(), cause);
        ctx.close();
    }
}

