/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.util.Arrays;
import java.util.List;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.messaging.RequestMessageDecoder;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.messaging.MessageProcessingHandler;
import org.neo4j.bolt.v1.messaging.ResultHandler;
import org.neo4j.bolt.v1.messaging.decoder.AckFailureMessageDecoder;
import org.neo4j.bolt.v1.messaging.decoder.DiscardAllMessageDecoder;
import org.neo4j.bolt.v1.messaging.decoder.InitMessageDecoder;
import org.neo4j.bolt.v1.messaging.decoder.PullAllMessageDecoder;
import org.neo4j.bolt.v1.messaging.decoder.ResetMessageDecoder;
import org.neo4j.bolt.v1.messaging.decoder.RunMessageDecoder;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;

public class BoltRequestMessageReaderV1
extends BoltRequestMessageReader {
    public BoltRequestMessageReaderV1(BoltConnection connection, BoltResponseMessageWriter responseMessageWriter, BoltMessageLogger messageLogger, LogService logService) {
        super(connection, BoltRequestMessageReaderV1.newSimpleResponseHandler(connection, responseMessageWriter, logService), BoltRequestMessageReaderV1.buildDecoders(connection, responseMessageWriter, messageLogger, logService), messageLogger);
    }

    private static List<RequestMessageDecoder> buildDecoders(BoltConnection connection, BoltResponseMessageWriter responseMessageWriter, BoltMessageLogger messageLogger, LogService logService) {
        BoltResponseHandler initHandler = BoltRequestMessageReaderV1.newSimpleResponseHandler(connection, responseMessageWriter, logService);
        BoltResponseHandler runHandler = BoltRequestMessageReaderV1.newSimpleResponseHandler(connection, responseMessageWriter, logService);
        ResultHandler resultHandler = new ResultHandler(responseMessageWriter, connection, BoltRequestMessageReaderV1.internalLog(logService));
        BoltResponseHandler defaultHandler = BoltRequestMessageReaderV1.newSimpleResponseHandler(connection, responseMessageWriter, logService);
        return Arrays.asList(new InitMessageDecoder(initHandler, messageLogger), new AckFailureMessageDecoder(defaultHandler, messageLogger), new ResetMessageDecoder(connection, defaultHandler, messageLogger), new RunMessageDecoder(runHandler, messageLogger), new DiscardAllMessageDecoder(resultHandler, messageLogger), new PullAllMessageDecoder(resultHandler, messageLogger));
    }

    private static BoltResponseHandler newSimpleResponseHandler(BoltConnection connection, BoltResponseMessageWriter responseMessageWriter, LogService logService) {
        return new MessageProcessingHandler(responseMessageWriter, connection, BoltRequestMessageReaderV1.internalLog(logService));
    }

    private static Log internalLog(LogService logService) {
        return logService.getInternalLog(BoltRequestMessageReaderV1.class);
    }
}

