/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.PackProvider;
import org.neo4j.bolt.messaging.ResponseMessage;
import org.neo4j.bolt.messaging.ResponseMessageEncoder;
import org.neo4j.bolt.v1.messaging.encoder.FailureMessageEncoder;
import org.neo4j.bolt.v1.messaging.encoder.IgnoredMessageEncoder;
import org.neo4j.bolt.v1.messaging.encoder.RecordMessageEncoder;
import org.neo4j.bolt.v1.messaging.encoder.SuccessMessageEncoder;
import org.neo4j.bolt.v1.messaging.response.FatalFailureMessage;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;

public class BoltResponseMessageWriterV1
implements BoltResponseMessageWriter {
    private final PackOutput output;
    private final Neo4jPack.Packer packer;
    private final Log log;
    private final Map<Byte, ResponseMessageEncoder<ResponseMessage>> encoders;

    public BoltResponseMessageWriterV1(PackProvider packerProvider, PackOutput output, LogService logService, BoltMessageLogger messageLogger) {
        this.output = output;
        this.packer = packerProvider.newPacker(output);
        this.log = logService.getInternalLog(this.getClass());
        this.encoders = this.registerEncoders(messageLogger);
    }

    private Map<Byte, ResponseMessageEncoder<ResponseMessage>> registerEncoders(BoltMessageLogger messageLogger) {
        HashMap<Byte, ResponseMessageEncoder<ResponseMessage>> encoders = new HashMap<Byte, ResponseMessageEncoder<ResponseMessage>>();
        encoders.put((byte)112, new SuccessMessageEncoder(messageLogger));
        encoders.put((byte)113, new RecordMessageEncoder());
        encoders.put((byte)126, new IgnoredMessageEncoder(messageLogger));
        encoders.put((byte)127, new FailureMessageEncoder(messageLogger));
        return encoders;
    }

    @Override
    public void write(ResponseMessage message) throws IOException {
        this.packCompleteMessageOrFail(message);
        if (message instanceof FatalFailureMessage) {
            this.flush();
        }
    }

    public void flush() throws IOException {
        this.packer.flush();
    }

    private void packCompleteMessageOrFail(ResponseMessage message) throws IOException {
        boolean packingFailed = true;
        this.output.beginMessage();
        try {
            ResponseMessageEncoder<ResponseMessage> encoder = this.encoders.get(message.signature());
            if (encoder == null) {
                throw new BoltIOException((Status)Status.Request.InvalidFormat, String.format("Message %s is not supported in this protocol version.", message));
            }
            encoder.encode(this.packer, message);
            packingFailed = false;
            this.output.messageSucceeded();
        }
        catch (Throwable error) {
            if (packingFailed) {
                this.output.messageFailed();
                this.log.error("Failed to write full %s message because: %s", new Object[]{message, error.getMessage()});
            }
            throw error;
        }
    }
}

