/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.decoder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.RequestMessageDecoder;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.messaging.decoder.PrimitiveOnlyValueWriter;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;

public class InitMessageDecoder
implements RequestMessageDecoder {
    private final BoltResponseHandler responseHandler;
    private final BoltMessageLogger messageLogger;

    public InitMessageDecoder(BoltResponseHandler responseHandler, BoltMessageLogger messageLogger) {
        this.responseHandler = responseHandler;
        this.messageLogger = messageLogger;
    }

    @Override
    public int signature() {
        return 1;
    }

    @Override
    public BoltResponseHandler responseHandler() {
        return this.responseHandler;
    }

    @Override
    public RequestMessage decode(Neo4jPack.Unpacker unpacker) throws IOException {
        String userAgent = unpacker.unpackString();
        Map<String, Object> authToken = InitMessageDecoder.readAuthToken(unpacker);
        this.messageLogger.logInit(userAgent);
        return new InitMessage(userAgent, authToken);
    }

    private static Map<String, Object> readAuthToken(Neo4jPack.Unpacker unpacker) throws IOException {
        MapValue authTokenValue = unpacker.unpackMap();
        PrimitiveOnlyValueWriter writer = new PrimitiveOnlyValueWriter();
        HashMap<String, Object> tokenMap = new HashMap<String, Object>(authTokenValue.size());
        authTokenValue.foreach((key, value) -> tokenMap.put((String)key, writer.valueAsObject((AnyValue)value)));
        return tokenMap;
    }
}

