/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.encoder;

import java.io.IOException;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.ResponseMessageEncoder;
import org.neo4j.bolt.v1.messaging.response.FailureMessage;
import org.neo4j.bolt.v1.messaging.response.FatalFailureMessage;

public class FailureMessageEncoder
implements ResponseMessageEncoder<FailureMessage> {
    private BoltMessageLogger messageLogger;

    public FailureMessageEncoder(BoltMessageLogger messageLogger) {
        this.messageLogger = messageLogger;
    }

    @Override
    public void encode(Neo4jPack.Packer packer, FailureMessage message) throws IOException {
        if (message instanceof FatalFailureMessage) {
            this.messageLogger.serverError("FATAL", message.status());
        }
        this.encodeFailure(message, packer);
    }

    private void encodeFailure(FailureMessage message, Neo4jPack.Packer packer) throws IOException {
        packer.packStructHeader(1, message.signature());
        packer.packMapHeader(2);
        packer.pack("code");
        packer.pack(message.status().code().serialize());
        packer.pack("message");
        packer.pack(message.message());
        this.messageLogger.logFailure(message.status());
    }
}

