/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.util.Map;
import org.neo4j.bolt.BoltConnectionDescriptor;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.BoltStateMachineSPI;
import org.neo4j.bolt.runtime.Neo4jError;
import org.neo4j.bolt.runtime.TransactionStateMachineSPI;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v1.runtime.ErrorReporter;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.api.bolt.ManagedBoltStateMachine;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.internal.Version;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;
import org.neo4j.util.concurrent.RecentK;

public class BoltStateMachineV1SPI
implements BoltStateMachineSPI {
    public static final String BOLT_SERVER_VERSION_PREFIX = "Neo4j/";
    private final BoltConnectionDescriptor connectionDescriptor;
    private final UsageData usageData;
    private final ErrorReporter errorReporter;
    private final BoltConnectionTracker connectionTracker;
    private final Authentication authentication;
    private final String version;
    private final TransactionStateMachineSPI transactionSpi;

    public BoltStateMachineV1SPI(BoltConnectionDescriptor connectionDescriptor, UsageData usageData, LogService logging, Authentication authentication, BoltConnectionTracker connectionTracker, TransactionStateMachineSPI transactionStateMachineSPI) {
        this.connectionDescriptor = connectionDescriptor;
        this.usageData = usageData;
        this.errorReporter = new ErrorReporter(logging);
        this.connectionTracker = connectionTracker;
        this.authentication = authentication;
        this.transactionSpi = transactionStateMachineSPI;
        this.version = BOLT_SERVER_VERSION_PREFIX + Version.getNeo4jVersion();
    }

    @Override
    public BoltConnectionDescriptor connectionDescriptor() {
        return this.connectionDescriptor;
    }

    @Override
    public void register(BoltStateMachine machine, String owner) {
        this.connectionTracker.onRegister((ManagedBoltStateMachine)machine, owner);
    }

    @Override
    public TransactionStateMachineSPI transactionSpi() {
        return this.transactionSpi;
    }

    @Override
    public void onTerminate(BoltStateMachine machine) {
        this.connectionTracker.onTerminate((ManagedBoltStateMachine)machine);
    }

    @Override
    public void reportError(Neo4jError err) {
        this.errorReporter.report(err);
    }

    @Override
    public AuthenticationResult authenticate(Map<String, Object> authToken) throws AuthenticationException {
        return this.authentication.authenticate(authToken);
    }

    @Override
    public void udcRegisterClient(String clientName) {
        ((RecentK)this.usageData.get(UsageDataKeys.clientNames)).add((Object)clientName);
    }

    @Override
    public String version() {
        return this.version;
    }
}

