/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.util.Map;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltQuerySource;
import org.neo4j.bolt.runtime.BoltStateMachineState;
import org.neo4j.bolt.runtime.StateMachineContext;
import org.neo4j.bolt.runtime.StatementProcessor;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.runtime.TransactionStateMachine;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class ConnectedState
implements BoltStateMachineState {
    private BoltStateMachineState readyState;
    private BoltStateMachineState failedState;

    @Override
    public BoltStateMachineState process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        this.assertInitialized();
        if (message instanceof InitMessage) {
            return this.processInitMessage((InitMessage)message, context);
        }
        return null;
    }

    @Override
    public String name() {
        return "CONNECTED";
    }

    public void setReadyState(BoltStateMachineState readyState) {
        this.readyState = readyState;
    }

    public void setFailedState(BoltStateMachineState failedState) {
        this.failedState = failedState;
    }

    private BoltStateMachineState processInitMessage(InitMessage message, StateMachineContext context) throws BoltConnectionFatality {
        String userAgent = message.userAgent();
        Map<String, Object> authToken = message.authToken();
        Object principal = authToken.get("principal");
        String owner = String.valueOf(principal);
        try {
            AuthenticationResult authResult = context.boltSpi().authenticate(authToken);
            StatementProcessor statementProcessor = ConnectedState.newStatementProcessor(owner, userAgent, authResult, context);
            context.connectionState().setStatementProcessor(statementProcessor);
            if (authResult.credentialsExpired()) {
                context.connectionState().onMetadata("credentials_expired", (AnyValue)Values.TRUE);
            }
            context.connectionState().onMetadata("server", (AnyValue)Values.stringValue((String)context.boltSpi().version()));
            context.boltSpi().udcRegisterClient(userAgent);
            if (principal != null) {
                context.connectionState().setOwner(owner);
                context.registerMachine(owner);
            }
            return this.readyState;
        }
        catch (Throwable t) {
            context.handleFailure(t, true);
            return this.failedState;
        }
    }

    private static StatementProcessor newStatementProcessor(String owner, String userAgent, AuthenticationResult authResult, StateMachineContext context) {
        TransactionStateMachine statementProcessor = new TransactionStateMachine(context.boltSpi().transactionSpi(), authResult, context.clock());
        statementProcessor.setQuerySource(new BoltQuerySource(owner, userAgent, context.boltSpi().connectionDescriptor()));
        return statementProcessor;
    }

    private void assertInitialized() {
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
        Preconditions.checkState((this.failedState != null ? 1 : 0) != 0, (String)"Failed state not set");
    }
}

