/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.v1.runtime.ExecutionPlanConverter;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;

class CypherAdapterStream
implements BoltResult {
    private final QueryResult delegate;
    private final String[] fieldNames;
    private final Clock clock;

    CypherAdapterStream(QueryResult delegate, Clock clock) {
        this.delegate = delegate;
        this.fieldNames = delegate.fieldNames();
        this.clock = clock;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public String[] fieldNames() {
        return this.fieldNames;
    }

    @Override
    public void accept(BoltResult.Visitor visitor) throws Exception {
        Iterable notifications;
        long start = this.clock.millis();
        this.delegate.accept(row -> {
            visitor.visit(row);
            return true;
        });
        visitor.addMetadata("result_consumed_after", (AnyValue)Values.longValue((long)(this.clock.millis() - start)));
        QueryExecutionType qt = this.delegate.executionType();
        visitor.addMetadata("type", (AnyValue)Values.stringValue((String)this.queryTypeCode(qt.queryType())));
        if (this.delegate.queryStatistics().containsUpdates()) {
            MapValue stats = this.queryStats(this.delegate.queryStatistics());
            visitor.addMetadata("stats", (AnyValue)stats);
        }
        if (qt.requestedExecutionPlanDescription()) {
            ExecutionPlanDescription rootPlanTreeNode = this.delegate.executionPlanDescription();
            String metadataFieldName = rootPlanTreeNode.hasProfilerStatistics() ? "profile" : "plan";
            visitor.addMetadata(metadataFieldName, (AnyValue)ExecutionPlanConverter.convert(rootPlanTreeNode));
        }
        if ((notifications = this.delegate.getNotifications()).iterator().hasNext()) {
            visitor.addMetadata("notifications", NotificationConverter.convert(notifications));
        }
    }

    public String toString() {
        return "CypherAdapterStream{delegate=" + this.delegate + ", fieldNames=" + Arrays.toString(this.fieldNames) + '}';
    }

    private MapValue queryStats(QueryStatistics queryStatistics) {
        MapValueBuilder builder = new MapValueBuilder();
        this.addIfNonZero(builder, "nodes-created", queryStatistics.getNodesCreated());
        this.addIfNonZero(builder, "nodes-deleted", queryStatistics.getNodesDeleted());
        this.addIfNonZero(builder, "relationships-created", queryStatistics.getRelationshipsCreated());
        this.addIfNonZero(builder, "relationships-deleted", queryStatistics.getRelationshipsDeleted());
        this.addIfNonZero(builder, "properties-set", queryStatistics.getPropertiesSet());
        this.addIfNonZero(builder, "labels-added", queryStatistics.getLabelsAdded());
        this.addIfNonZero(builder, "labels-removed", queryStatistics.getLabelsRemoved());
        this.addIfNonZero(builder, "indexes-added", queryStatistics.getIndexesAdded());
        this.addIfNonZero(builder, "indexes-removed", queryStatistics.getIndexesRemoved());
        this.addIfNonZero(builder, "constraints-added", queryStatistics.getConstraintsAdded());
        this.addIfNonZero(builder, "constraints-removed", queryStatistics.getConstraintsRemoved());
        return builder.build();
    }

    private void addIfNonZero(MapValueBuilder builder, String name, int count) {
        if (count > 0) {
            builder.add(name, (AnyValue)Values.intValue((int)count));
        }
    }

    private String queryTypeCode(QueryExecutionType.QueryType queryType) {
        switch (queryType) {
            case READ_ONLY: {
                return "r";
            }
            case READ_WRITE: {
                return "rw";
            }
            case WRITE: {
                return "w";
            }
            case SCHEMA_WRITE: {
                return "s";
            }
        }
        return queryType.name();
    }

    private static class NotificationConverter {
        private NotificationConverter() {
        }

        public static AnyValue convert(Iterable<Notification> notifications) {
            ArrayList<MapValue> out = new ArrayList<MapValue>();
            for (Notification notification : notifications) {
                InputPosition pos = notification.getPosition();
                boolean includePosition = !pos.equals((Object)InputPosition.empty);
                int size = includePosition ? 5 : 4;
                MapValueBuilder builder = new MapValueBuilder(size);
                builder.add("code", (AnyValue)Values.stringValue((String)notification.getCode()));
                builder.add("title", (AnyValue)Values.stringValue((String)notification.getTitle()));
                builder.add("description", (AnyValue)Values.stringValue((String)notification.getDescription()));
                builder.add("severity", (AnyValue)Values.stringValue((String)notification.getSeverity().toString()));
                if (includePosition) {
                    builder.add("position", (AnyValue)VirtualValues.map((String[])new String[]{"offset", "line", "column"}, (AnyValue[])new AnyValue[]{Values.intValue((int)pos.getOffset()), Values.intValue((int)pos.getLine()), Values.intValue((int)pos.getColumn())}));
                }
                out.add(builder.build());
            }
            return VirtualValues.fromList(out);
        }
    }
}

