/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import org.neo4j.bolt.runtime.Neo4jError;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;

class ErrorReporter {
    private final Log userLog;
    private final Log debugLog;

    ErrorReporter(LogService logging) {
        this.userLog = logging.getUserLog(ErrorReporter.class);
        this.debugLog = logging.getInternalLog(ErrorReporter.class);
    }

    ErrorReporter(Log userLog, Log debugLog) {
        this.userLog = userLog;
        this.debugLog = debugLog;
    }

    public void report(Neo4jError error) {
        if (error.status().code().classification() == Status.Classification.DatabaseError) {
            String message = String.format("Client triggered an unexpected error [%s]: %s, reference %s.", error.status().code().serialize(), error.message(), error.reference());
            this.userLog.error(message);
            if (error.cause() != null) {
                this.debugLog.error(message, error.cause());
            }
        }
    }
}

