/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.util.Optional;
import org.neo4j.bolt.runtime.BoltQuerySource;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.BoltResultHandle;
import org.neo4j.bolt.runtime.StatementMetadata;
import org.neo4j.bolt.runtime.StatementProcessor;
import org.neo4j.bolt.runtime.TransactionStateMachineSPI;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v1.runtime.bookmarking.Bookmark;
import org.neo4j.bolt.v1.runtime.spi.BookmarkResult;
import org.neo4j.cypher.InvalidSemanticsException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.values.virtual.MapValue;

public class TransactionStateMachine
implements StatementProcessor {
    final TransactionStateMachineSPI spi;
    final MutableTransactionState ctx;
    State state = State.AUTO_COMMIT;

    TransactionStateMachine(TransactionStateMachineSPI spi, AuthenticationResult authenticationResult, Clock clock) {
        this.spi = spi;
        this.ctx = new MutableTransactionState(authenticationResult, clock);
    }

    public State state() {
        return this.state;
    }

    private void before() {
        if (this.ctx.currentTransaction != null) {
            this.spi.bindTransactionToCurrentThread(this.ctx.currentTransaction);
        }
    }

    @Override
    public void beginTransaction(Bookmark bookmark) throws KernelException {
        this.before();
        try {
            this.ensureNoPendingTerminationNotice();
            this.state = this.state.beginTransaction(this.ctx, this.spi, bookmark);
        }
        finally {
            this.after();
        }
    }

    @Override
    public StatementMetadata run(String statement, MapValue params) throws KernelException {
        return this.run(statement, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementMetadata run(String statement, MapValue params, Bookmark bookmark) throws KernelException {
        this.before();
        try {
            this.ensureNoPendingTerminationNotice();
            this.state = this.state.run(this.ctx, this.spi, statement, params, bookmark);
            StatementMetadata statementMetadata = this.ctx.currentStatementMetadata;
            return statementMetadata;
        }
        finally {
            this.after();
        }
    }

    @Override
    public void streamResult(ThrowingConsumer<BoltResult, Exception> resultConsumer) throws Exception {
        this.before();
        try {
            this.ensureNoPendingTerminationNotice();
            this.state.streamResult(this.ctx, resultConsumer);
        }
        finally {
            this.after();
        }
    }

    @Override
    public Bookmark commitTransaction() throws KernelException {
        this.before();
        try {
            this.ensureNoPendingTerminationNotice();
            this.state = this.state.commitTransaction(this.ctx, this.spi);
            Bookmark bookmark = TransactionStateMachine.newestBookmark(this.spi);
            return bookmark;
        }
        catch (TransactionFailureException ex) {
            this.state = State.AUTO_COMMIT;
            throw ex;
        }
        finally {
            this.after();
        }
    }

    @Override
    public void rollbackTransaction() throws KernelException {
        this.before();
        try {
            this.ensureNoPendingTerminationNotice();
            this.state = this.state.rollbackTransaction(this.ctx, this.spi);
        }
        finally {
            this.after();
        }
    }

    @Override
    public boolean hasOpenStatement() {
        return this.ctx.currentResultHandle != null;
    }

    @Override
    public void reset() throws TransactionFailureException {
        this.state.terminateQueryAndRollbackTransaction(this.ctx);
        this.state = State.AUTO_COMMIT;
    }

    private void after() {
        this.spi.unbindTransactionFromCurrentThread();
    }

    @Override
    public void markCurrentTransactionForTermination() {
        KernelTransaction tx = this.ctx.currentTransaction;
        if (tx != null) {
            tx.markForTermination((Status)Status.Transaction.Terminated);
        }
    }

    @Override
    public void validateTransaction() throws KernelException {
        Optional statusOpt;
        KernelTransaction tx = this.ctx.currentTransaction;
        if (tx != null && (statusOpt = tx.getReasonIfTerminated()).isPresent() && ((Status)statusOpt.get()).code().classification().rollbackTransaction()) {
            this.ctx.pendingTerminationNotice = (Status)statusOpt.get();
            this.reset();
        }
    }

    private void ensureNoPendingTerminationNotice() {
        if (this.ctx.pendingTerminationNotice != null) {
            Status status = this.ctx.pendingTerminationNotice;
            this.ctx.pendingTerminationNotice = null;
            throw new TransactionTerminatedException(status);
        }
    }

    @Override
    public boolean hasTransaction() {
        return this.state == State.EXPLICIT_TRANSACTION;
    }

    @Override
    public void setQuerySource(BoltQuerySource querySource) {
        this.ctx.querySource = querySource;
    }

    private static void waitForBookmark(TransactionStateMachineSPI spi, Bookmark bookmark) throws TransactionFailureException {
        if (bookmark != null) {
            spi.awaitUpToDate(bookmark.txId());
        }
    }

    private static Bookmark newestBookmark(TransactionStateMachineSPI spi) {
        long txId = spi.newestEncounteredTxId();
        return new Bookmark(txId);
    }

    static class MutableTransactionState {
        final LoginContext loginContext;
        KernelTransaction currentTransaction;
        Status pendingTerminationNotice;
        String lastStatement = "";
        BoltResult currentResult;
        final Clock clock;
        private final StatementMetadata currentStatementMetadata = new StatementMetadata(){

            @Override
            public String[] fieldNames() {
                return currentResult.fieldNames();
            }
        };
        BoltQuerySource querySource;
        BoltResultHandle currentResultHandle;

        private MutableTransactionState(AuthenticationResult authenticationResult, Clock clock) {
            this.clock = clock;
            this.loginContext = authenticationResult.getLoginContext();
        }
    }

    static enum State {
        AUTO_COMMIT{

            @Override
            State beginTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi, Bookmark bookmark) throws KernelException {
                TransactionStateMachine.waitForBookmark(spi, bookmark);
                ctx.currentResult = BoltResult.EMPTY;
                ctx.currentTransaction = spi.beginTransaction(ctx.loginContext);
                return EXPLICIT_TRANSACTION;
            }

            @Override
            State run(MutableTransactionState ctx, TransactionStateMachineSPI spi, String statement, MapValue params, Bookmark bookmark) throws KernelException {
                statement = this.parseStatement(ctx, statement);
                TransactionStateMachine.waitForBookmark(spi, bookmark);
                this.execute(ctx, spi, statement, params, spi.isPeriodicCommit(statement));
                return AUTO_COMMIT;
            }

            private String parseStatement(MutableTransactionState ctx, String statement) {
                if (statement.isEmpty()) {
                    statement = ctx.lastStatement;
                } else {
                    ctx.lastStatement = statement;
                }
                return statement;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void execute(MutableTransactionState ctx, TransactionStateMachineSPI spi, String statement, MapValue params, boolean isPeriodicCommit) throws KernelException {
                if (!isPeriodicCommit) {
                    ctx.currentTransaction = spi.beginTransaction(ctx.loginContext);
                }
                boolean failed = true;
                try {
                    BoltResultHandle resultHandle = spi.executeQuery(ctx.querySource, ctx.loginContext, statement, params);
                    this.startExecution(ctx, resultHandle);
                    failed = false;
                }
                finally {
                    if (!isPeriodicCommit) {
                        if (failed) {
                            this.closeTransaction(ctx, false);
                        }
                    } else {
                        ctx.currentTransaction = spi.beginTransaction(ctx.loginContext);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void streamResult(MutableTransactionState ctx, ThrowingConsumer<BoltResult, Exception> resultConsumer) throws Exception {
                assert (ctx.currentResult != null);
                boolean success = false;
                try {
                    success = this.consumeResult(ctx, resultConsumer);
                }
                finally {
                    this.closeTransaction(ctx, success);
                }
            }

            @Override
            State commitTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi) throws KernelException {
                throw new QueryExecutionKernelException((Throwable)new InvalidSemanticsException("No current transaction to commit."));
            }

            @Override
            State rollbackTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi) {
                ctx.currentResult = BoltResult.EMPTY;
                return AUTO_COMMIT;
            }
        }
        ,
        EXPLICIT_TRANSACTION{

            @Override
            State beginTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi, Bookmark bookmark) throws KernelException {
                throw new QueryExecutionKernelException((Throwable)new InvalidSemanticsException("Nested transactions are not supported."));
            }

            @Override
            State run(MutableTransactionState ctx, TransactionStateMachineSPI spi, String statement, MapValue params, Bookmark bookmark) throws KernelException {
                if (statement.isEmpty()) {
                    statement = ctx.lastStatement;
                } else {
                    ctx.lastStatement = statement;
                }
                if (spi.isPeriodicCommit(statement)) {
                    throw new QueryExecutionKernelException((Throwable)new InvalidSemanticsException("Executing queries that use periodic commit in an open transaction is not possible."));
                }
                BoltResultHandle resultHandle = spi.executeQuery(ctx.querySource, ctx.loginContext, statement, params);
                this.startExecution(ctx, resultHandle);
                return EXPLICIT_TRANSACTION;
            }

            @Override
            void streamResult(MutableTransactionState ctx, ThrowingConsumer<BoltResult, Exception> resultConsumer) throws Exception {
                assert (ctx.currentResult != null);
                this.consumeResult(ctx, resultConsumer);
            }

            @Override
            State commitTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi) throws KernelException {
                this.closeTransaction(ctx, true);
                Bookmark bookmark = TransactionStateMachine.newestBookmark(spi);
                ctx.currentResult = new BookmarkResult(bookmark);
                return AUTO_COMMIT;
            }

            @Override
            State rollbackTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi) throws KernelException {
                this.closeTransaction(ctx, false);
                ctx.currentResult = BoltResult.EMPTY;
                return AUTO_COMMIT;
            }
        };


        abstract State beginTransaction(MutableTransactionState var1, TransactionStateMachineSPI var2, Bookmark var3) throws KernelException;

        abstract State run(MutableTransactionState var1, TransactionStateMachineSPI var2, String var3, MapValue var4, Bookmark var5) throws KernelException;

        abstract void streamResult(MutableTransactionState var1, ThrowingConsumer<BoltResult, Exception> var2) throws Exception;

        abstract State commitTransaction(MutableTransactionState var1, TransactionStateMachineSPI var2) throws KernelException;

        abstract State rollbackTransaction(MutableTransactionState var1, TransactionStateMachineSPI var2) throws KernelException;

        void terminateQueryAndRollbackTransaction(MutableTransactionState ctx) throws TransactionFailureException {
            if (ctx.currentResultHandle != null) {
                ctx.currentResultHandle.terminate();
                ctx.currentResultHandle = null;
            }
            if (ctx.currentResult != null) {
                ctx.currentResult.close();
                ctx.currentResult = null;
            }
            this.closeTransaction(ctx, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeTransaction(MutableTransactionState ctx, boolean success) throws TransactionFailureException {
            KernelTransaction tx = ctx.currentTransaction;
            ctx.currentTransaction = null;
            if (tx != null) {
                try {
                    if (success) {
                        tx.success();
                    } else {
                        tx.failure();
                    }
                    if (tx.isOpen()) {
                        tx.close();
                    }
                }
                finally {
                    ctx.currentTransaction = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean consumeResult(MutableTransactionState ctx, ThrowingConsumer<BoltResult, Exception> resultConsumer) throws Exception {
            boolean success = false;
            try {
                resultConsumer.accept((Object)ctx.currentResult);
                success = true;
            }
            finally {
                ctx.currentResult.close();
                ctx.currentResult = null;
                if (ctx.currentResultHandle != null) {
                    ctx.currentResultHandle.close(success);
                    ctx.currentResultHandle = null;
                }
            }
            return success;
        }

        void startExecution(MutableTransactionState ctx, BoltResultHandle resultHandle) throws KernelException {
            ctx.currentResultHandle = resultHandle;
            try {
                ctx.currentResult = resultHandle.start();
            }
            catch (Throwable t) {
                ctx.currentResultHandle.close(false);
                ctx.currentResultHandle = null;
                throw t;
            }
        }
    }
}

