/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging;

import java.util.Arrays;
import java.util.List;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.messaging.RequestMessageDecoder;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.messaging.MessageProcessingHandler;
import org.neo4j.bolt.v1.messaging.ResultHandler;
import org.neo4j.bolt.v1.messaging.decoder.DiscardAllMessageDecoder;
import org.neo4j.bolt.v1.messaging.decoder.PullAllMessageDecoder;
import org.neo4j.bolt.v1.messaging.decoder.ResetMessageDecoder;
import org.neo4j.bolt.v3.messaging.decoder.BeginMessageDecoder;
import org.neo4j.bolt.v3.messaging.decoder.CommitMessageDecoder;
import org.neo4j.bolt.v3.messaging.decoder.HelloMessageDecoder;
import org.neo4j.bolt.v3.messaging.decoder.RollbackMessageDecoder;
import org.neo4j.bolt.v3.messaging.decoder.RunMessageDecoder;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;

public class BoltRequestMessageReaderV3
extends BoltRequestMessageReader {
    public BoltRequestMessageReaderV3(BoltConnection connection, BoltResponseMessageWriter responseMessageWriter, BoltMessageLogger messageLogger, LogService logService) {
        super(connection, BoltRequestMessageReaderV3.newSimpleResponseHandler(responseMessageWriter, connection, logService), BoltRequestMessageReaderV3.buildDecoders(connection, responseMessageWriter, messageLogger, logService), messageLogger);
    }

    private static List<RequestMessageDecoder> buildDecoders(BoltConnection connection, BoltResponseMessageWriter responseMessageWriter, BoltMessageLogger messageLogger, LogService logService) {
        ResultHandler resultHandler = new ResultHandler(responseMessageWriter, connection, BoltRequestMessageReaderV3.internalLog(logService));
        BoltResponseHandler defaultHandler = BoltRequestMessageReaderV3.newSimpleResponseHandler(responseMessageWriter, connection, logService);
        return Arrays.asList(new HelloMessageDecoder(defaultHandler), new RunMessageDecoder(defaultHandler), new DiscardAllMessageDecoder(resultHandler, messageLogger), new PullAllMessageDecoder(resultHandler, messageLogger), new BeginMessageDecoder(defaultHandler), new CommitMessageDecoder(resultHandler), new RollbackMessageDecoder(resultHandler), new ResetMessageDecoder(connection, defaultHandler, messageLogger));
    }

    private static BoltResponseHandler newSimpleResponseHandler(BoltResponseMessageWriter responseMessageWriter, BoltConnection connection, LogService logService) {
        return new MessageProcessingHandler(responseMessageWriter, connection, BoltRequestMessageReaderV3.internalLog(logService));
    }

    private static Log internalLog(LogService logService) {
        return logService.getInternalLog(BoltRequestMessageReaderV3.class);
    }
}

