/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging.decoder;

import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.kernel.api.exceptions.Status;

public enum StatementMode {
    READ("R"),
    WRITE("W");

    private final String signature;

    private StatementMode(String name) {
        this.signature = name;
    }

    public String signature() {
        return this.signature;
    }

    public static StatementMode parseMode(String str) throws BoltIOException {
        if (READ.signature().equalsIgnoreCase(str)) {
            return READ;
        }
        if (WRITE.signature().equalsIgnoreCase(str)) {
            return WRITE;
        }
        throw new BoltIOException((Status)Status.Request.InvalidFormat, String.format("Unknown mode '%s' for input cypher statement.", str));
    }
}

