/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging.request;

import java.time.Duration;
import java.util.Objects;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.v1.runtime.bookmarking.Bookmark;
import org.neo4j.bolt.v3.messaging.decoder.StatementMode;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class BeginMessage
implements RequestMessage {
    private final MapValue meta;
    private final StatementMode mode;
    private final Bookmark bookmark;
    private final Duration txTimeout;
    private static final String MODE_KEY = "mode";
    private static final String TX_TIMEOUT_KEY = "tx_timeout";
    public static final byte SIGNATURE = 17;

    public BeginMessage() throws BoltIOException {
        this(VirtualValues.EMPTY_MAP);
    }

    public BeginMessage(MapValue meta) throws BoltIOException {
        this.meta = Objects.requireNonNull(meta);
        this.bookmark = BeginMessage.parseBookmark(meta);
        this.mode = BeginMessage.parseStatementMode(meta);
        this.txTimeout = BeginMessage.parseTransactionTimeout(meta);
    }

    static Bookmark parseBookmark(MapValue meta) throws BoltIOException {
        try {
            return Bookmark.fromParamsOrNull(meta);
        }
        catch (KernelException e) {
            throw new BoltIOException((Status)Status.Request.InvalidFormat, e.getMessage(), e);
        }
    }

    static Duration parseTransactionTimeout(MapValue meta) throws BoltIOException {
        AnyValue anyValue = meta.get(TX_TIMEOUT_KEY);
        if (anyValue == Values.NO_VALUE) {
            return null;
        }
        if (anyValue instanceof LongValue) {
            return Duration.ofMillis(((LongValue)anyValue).longValue());
        }
        throw new BoltIOException((Status)Status.Request.InvalidFormat, "Expecting transaction timeout value to be a Long value, but got: " + anyValue);
    }

    static StatementMode parseStatementMode(MapValue meta) throws BoltIOException {
        AnyValue anyValue = meta.get(MODE_KEY);
        if (anyValue == Values.NO_VALUE) {
            return null;
        }
        if (anyValue instanceof TextValue) {
            return StatementMode.parseMode(((TextValue)anyValue).stringValue());
        }
        throw new BoltIOException((Status)Status.Request.InvalidFormat, "Expecting transaction statement mode value to be a String value, but got: " + anyValue);
    }

    public Bookmark bookmark() {
        return this.bookmark;
    }

    public StatementMode mode() {
        return this.mode;
    }

    public Duration transactionTimeout() {
        return this.txTimeout;
    }

    @Override
    public boolean safeToProcessInAnyState() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeginMessage that = (BeginMessage)o;
        return Objects.equals(this.meta, that.meta) && Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        return Objects.hash(this.meta);
    }

    public String toString() {
        return "BEGIN " + this.meta;
    }

    public MapValue meta() {
        return this.meta;
    }
}

