/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging.request;

import java.time.Duration;
import java.util.Objects;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.v1.runtime.bookmarking.Bookmark;
import org.neo4j.bolt.v3.messaging.decoder.StatementMode;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class RunMessage
implements RequestMessage {
    public static final byte SIGNATURE = 16;
    private final String statement;
    private final MapValue params;
    private final MapValue meta;
    private final StatementMode mode;
    private final Bookmark bookmark;
    private final Duration txTimeout;

    public RunMessage(String statement) throws BoltIOException {
        this(statement, VirtualValues.EMPTY_MAP);
    }

    public RunMessage(String statement, MapValue params) throws BoltIOException {
        this(statement, params, VirtualValues.EMPTY_MAP);
    }

    public RunMessage(String statement, MapValue params, MapValue meta) throws BoltIOException {
        this.statement = Objects.requireNonNull(statement);
        this.params = Objects.requireNonNull(params);
        this.meta = Objects.requireNonNull(meta);
        this.mode = BeginMessage.parseStatementMode(meta);
        this.bookmark = BeginMessage.parseBookmark(meta);
        this.txTimeout = BeginMessage.parseTransactionTimeout(meta);
    }

    public String statement() {
        return this.statement;
    }

    public MapValue params() {
        return this.params;
    }

    public MapValue meta() {
        return this.meta;
    }

    @Override
    public boolean safeToProcessInAnyState() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunMessage that = (RunMessage)o;
        return Objects.equals(this.statement, that.statement) && Objects.equals(this.params, that.params) && Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        return Objects.hash(this.statement, this.params, this.meta);
    }

    public String toString() {
        return "RUN " + this.statement + ' ' + this.params + ' ' + this.meta;
    }

    public Bookmark bookmark() {
        return this.bookmark;
    }

    public StatementMode mode() {
        return this.mode;
    }

    public Duration transactionTimeout() {
        return this.txTimeout;
    }
}

